/*     */ package org.jboss.serial.objectmetamodel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.apache.log4j.Logger;
/*     */ import org.jboss.serial.classmetamodel.ClassMetaData;
/*     */ import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
/*     */ import org.jboss.serial.classmetamodel.StreamingClass;
/*     */ import org.jboss.serial.exception.SerializationException;
/*     */ import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
/*     */ import org.jboss.serial.persister.ClassReferencePersister;
/*     */ import org.jboss.serial.persister.PersistResolver;
/*     */ import org.jboss.serial.persister.Persister;
/*     */ import org.jboss.serial.util.ClassMetaConsts;
/*     */ 
/*     */ public class ObjectDescriptorFactory
/*     */   implements ClassMetaConsts
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(ObjectDescriptorFactory.class);
/*  56 */   private static final boolean isDebug = log.isDebugEnabled();
/*     */ 
/*     */   static Object objectFromDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input)
/*     */     throws IOException
/*     */   {
/*  62 */     Object description = null;
/*     */ 
/*  64 */     byte byteIdentify = cache.getInput().readByte();
/*     */ 
/*  66 */     if (byteIdentify == 60)
/*     */     {
/*  68 */       cache.reset();
/*  69 */       return objectFromDescription(cache, input);
/*     */     }
/*  71 */     if (byteIdentify == 99)
/*     */     {
/*  73 */       return null;
/*     */     }
/*     */ 
/*  76 */     if (byteIdentify == 51)
/*     */     {
/*  78 */       if (isDebug)
/*     */       {
/*  80 */         log.debug("objectFromDescription::reading new definition");
/*     */       }
/*  82 */       return readObjectDescriptionFromStreaming(cache, input.readObjectReference(), input);
/*     */     }
/*  84 */     if (byteIdentify == 50)
/*     */     {
/*  86 */       int reference = input.readObjectReference();
/*  87 */       if (isDebug)
/*     */       {
/*  89 */         log.debug("objectFromDescription::reading reference from safeClone=" + reference);
/*     */       }
/*  91 */       if (cache.getSafeToReuse() == null)
/*     */       {
/*  93 */         throw new IOException("SafeClone repository mismatch");
/*     */       }
/*  95 */       description = cache.getSafeToReuse().findReference(reference);
/*  96 */       if (description == null)
/*     */       {
/*  98 */         throw new IOException("SafeClone repository mismatch - didn't find reference " + reference);
/*     */       }
/* 100 */       return description;
/*     */     }
/*     */ 
/* 103 */     if (byteIdentify == 3)
/*     */     {
/* 105 */       int reference = input.readObjectReference();
/* 106 */       if (isDebug)
/*     */       {
/* 108 */         log.debug("objectFromDescription::reading circular definition reference=" + reference);
/*     */       }
/*     */ 
/* 111 */       if (description == null)
/*     */       {
/* 113 */         description = cache.findObjectInCacheRead(reference);
/*     */       }
/*     */ 
/* 116 */       if (description == null)
/*     */       {
/* 118 */         throw new SerializationException("Object reference " + reference + " was not found");
/*     */       }
/*     */ 
/* 121 */       return description;
/*     */     }
/*     */ 
/* 125 */     return input.readImmutable(byteIdentify, cache);
/*     */   }
/*     */ 
/*     */   static void describeObject(ObjectsCache cache, Object obj)
/*     */     throws IOException
/*     */   {
/* 140 */     ObjectsCache.JBossSeralizationOutputInterface outputParent = cache.getOutput();
/*     */ 
/* 142 */     if (obj == null)
/*     */     {
/* 144 */       outputParent.writeByte(99);
/* 145 */       return;
/*     */     }
/* 147 */     if ((obj != null) && (ClassMetamodelFactory.isImmutable(obj.getClass())))
/*     */     {
/* 149 */       outputParent.saveImmutable(cache, obj);
/* 150 */       return;
/*     */     }
/*     */ 
/* 153 */     if (isDebug)
/*     */     {
/* 155 */       if (obj == null)
/*     */       {
/* 157 */         log.debug("obj==null", new Exception());
/*     */       }
/*     */     }
/* 160 */     if (isDebug)
/*     */     {
/* 162 */       log.debug("describeObject for class=" + obj.getClass().getName());
/*     */     }
/*     */ 
/* 165 */     ClassMetaData metaData = null;
/* 166 */     if ((obj instanceof Class))
/*     */     {
/* 168 */       metaData = ClassMetamodelFactory.getClassMetaData((Class)obj, cache.isCheckSerializableClass());
/*     */     }
/*     */     else
/*     */     {
/* 172 */       metaData = ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
/* 173 */       if (metaData.getWriteReplaceMethod() != null)
/*     */       {
/* 175 */         if (isDebug)
/*     */         {
/* 177 */           log.debug("describeObject::Calling writeReplace for " + metaData.getClazz().getName());
/*     */         }
/*     */         try {
/* 180 */           Object orig = obj;
/* 181 */           obj = metaData.getWriteReplaceMethod().invoke(obj, EMPTY_OBJECT_ARRAY);
/* 182 */           if ((obj != null) && (obj != orig) && (obj.getClass() != metaData.getClazz()))
/*     */           {
/* 184 */             if (isDebug)
/*     */             {
/* 186 */               log.debug("originalObject=" + orig.getClass().getName() + " substituted by " + obj.getClass().getName());
/*     */             }
/* 188 */             describeObject(cache, obj);
/* 189 */             return;
/*     */           }
/* 191 */           metaData = ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
/*     */         } catch (Exception e) {
/* 193 */           IOException io = new IOException("Metadata Serialization Error");
/* 194 */           io.initCause(e);
/* 195 */           throw io;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 200 */     if (cache.getSubstitution() != null)
/*     */     {
/* 202 */       if (isDebug)
/*     */       {
/* 204 */         log.debug("describeObject::checking substitution on interface");
/*     */       }
/* 206 */       Object orig = obj;
/* 207 */       obj = cache.getSubstitution().replaceObject(obj);
/* 208 */       if ((obj != null) && (obj != orig) && (obj.getClass() != metaData.getClazz()))
/*     */       {
/* 210 */         if (isDebug)
/*     */         {
/* 212 */           log.debug("describeObject::on check interface, original object[" + orig.getClass().getName() + "] was replaced by [" + obj.getClass().getName() + "]");
/*     */         }
/* 214 */         describeObject(cache, obj);
/* 215 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 220 */     int description = 0;
/*     */ 
/* 222 */     if (cache.getSafeToReuse() != null)
/*     */     {
/* 224 */       description = cache.getSafeToReuse().storeSafe(obj);
/* 225 */       if (description != 0)
/*     */       {
/* 227 */         if (isDebug)
/*     */         {
/* 229 */           log.debug("describeObject::a safeClone reference " + description);
/*     */         }
/* 231 */         outputParent.writeByte(50);
/* 232 */         cache.getOutput().addObjectReference(description);
/* 233 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 238 */     description = cache.findIdInCacheWrite(obj);
/*     */ 
/* 240 */     if (description != 0)
/*     */     {
/* 242 */       if (isDebug)
/*     */       {
/* 244 */         log.debug("describeObject::a circular reference " + description);
/*     */       }
/* 246 */       outputParent.writeByte(3);
/* 247 */       cache.getOutput().addObjectReference(description);
/* 248 */       return;
/*     */     }
/*     */ 
/* 251 */     description = cache.putObjectInCacheWrite(obj);
/* 252 */     if (isDebug)
/*     */     {
/* 254 */       log.debug("describeObject::a new reference " + description);
/*     */     }
/* 256 */     outputParent.writeByte(51);
/* 257 */     cache.getOutput().addObjectReference(description);
/*     */ 
/* 259 */     int cacheId = cache.findIdInCacheWrite(metaData);
/* 260 */     if (cacheId == 0)
/*     */     {
/* 262 */       cacheId = cache.putObjectInCacheWrite(metaData);
/* 263 */       outputParent.writeByte(51);
/* 264 */       outputParent.addObjectReference(cacheId);
/* 265 */       StreamingClass.saveStream(metaData, outputParent);
/*     */     }
/*     */     else
/*     */     {
/* 269 */       outputParent.writeByte(3);
/* 270 */       outputParent.addObjectReference(cacheId);
/*     */     }
/*     */ 
/* 273 */     Persister persister = PersistResolver.resolvePersister(obj, metaData);
/*     */ 
/* 275 */     outputParent.writeByte(persister.getId());
/* 276 */     persister.writeData(metaData, cache.getOutput(), obj, cache.getSubstitution());
/*     */   }
/*     */ 
/*     */   private static Object readObjectDescriptionFromStreaming(ObjectsCache cache, int reference, ObjectsCache.JBossSeralizationInputInterface input)
/*     */     throws IOException
/*     */   {
/* 376 */     byte defClass = input.readByte();
/* 377 */     StreamingClass streamingClass = null;
/* 378 */     if (defClass == 51)
/*     */     {
/* 380 */       int referenceId = input.readObjectReference();
/* 381 */       streamingClass = StreamingClass.readStream(input, cache.getClassResolver(), cache.getLoader());
/* 382 */       cache.putObjectInCacheRead(referenceId, streamingClass);
/*     */     }
/*     */     else
/*     */     {
/* 386 */       int referenceId = input.readObjectReference();
/* 387 */       streamingClass = (StreamingClass)cache.findObjectInCacheRead(referenceId);
/* 388 */       if (streamingClass == null)
/*     */       {
/* 390 */         throw new IOException("Didn't find StreamingClass circular refernce id=" + referenceId);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 395 */     ClassMetaData metaData = streamingClass.getMetadata();
/*     */ 
/* 397 */     if (isDebug)
/*     */     {
/* 399 */       log.debug("Reading object for id=" + reference + " classLoader=" + cache.getLoader() + " className = " + metaData.getClassName());
/*     */     }
/*     */ 
/* 402 */     byte persisterId = input.readByte();
/* 403 */     Persister persister = PersistResolver.resolvePersister(persisterId);
/*     */ 
/* 412 */     Object value = persister.readData(cache.getLoader(), streamingClass, metaData, reference, cache, cache.getInput(), cache.getSubstitution());
/*     */ 
/* 414 */     if (!(persister instanceof ClassReferencePersister))
/*     */     {
/* 416 */       if (cache.getSubstitution() != null)
/*     */       {
/* 418 */         value = cache.getSubstitution().replaceObject(value);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 423 */         if (metaData.getReadResolveMethod() != null)
/*     */         {
/* 425 */           if (isDebug)
/*     */           {
/* 427 */             log.debug("readObjectDescriptionFromStreaming::calling readResolve for className = " + metaData.getClassName());
/*     */           }
/* 429 */           value = metaData.getReadResolveMethod().invoke(value, new Object[0]);
/* 430 */           cache.reassignObjectInCacheRead(reference, value);
/*     */         }
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/* 435 */         throw new SerializationException(e);
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 439 */         throw new SerializationException(e);
/*     */       }
/*     */     }
/*     */ 
/* 443 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.objectmetamodel.ObjectDescriptorFactory
 * JD-Core Version:    0.6.0
 */