/*      */ package org.jboss.serial.objectmetamodel;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.DataInput;
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutput;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.EOFException;
/*      */ import java.io.Externalizable;
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInput;
/*      */ import java.io.ObjectOutput;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Iterator;
/*      */ import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
/*      */ import org.jboss.serial.classmetamodel.ClassResolver;
/*      */ import org.jboss.serial.exception.SerializationException;
/*      */ import org.jboss.serial.finalcontainers.BooleanContainer;
/*      */ import org.jboss.serial.finalcontainers.ByteContainer;
/*      */ import org.jboss.serial.finalcontainers.CharacterContainer;
/*      */ import org.jboss.serial.finalcontainers.DoubleContainer;
/*      */ import org.jboss.serial.finalcontainers.FloatContainer;
/*      */ import org.jboss.serial.finalcontainers.IntegerContainer;
/*      */ import org.jboss.serial.finalcontainers.LongContainer;
/*      */ import org.jboss.serial.finalcontainers.ShortContainer;
/*      */ import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
/*      */ import org.jboss.serial.util.StringUtil;
/*      */ import org.jboss.serial.util.StringUtilBuffer;
/*      */ 
/*      */ public class DataContainer extends DataExport
/*      */   implements DataContainerConstants, Externalizable
/*      */ {
/*      */   byte[] controlStreaming;
/*   68 */   DataContainerOutput currentOutput = null;
/*      */ 
/*   70 */   ArrayList content = new ArrayList();
/*      */   transient ObjectsCache cache;
/*      */ 
/*      */   public DataContainer cloneContainer()
/*      */   {
/*   81 */     DataContainer newContainer = new DataContainer();
/*   82 */     newContainer.content = this.content;
/*   83 */     newContainer.controlStreaming = this.controlStreaming;
/*   84 */     newContainer.cache = this.cache.cloneCache();
/*   85 */     return newContainer;
/*      */   }
/*      */ 
/*      */   private DataContainer()
/*      */   {
/*      */   }
/*      */ 
/*      */   public DataContainer(boolean checkSerializable)
/*      */   {
/*   94 */     this((ClassLoader)null, checkSerializable, null);
/*      */   }
/*      */ 
/*      */   public DataContainer(boolean checkSerializable, StringUtilBuffer buffer)
/*      */   {
/*   99 */     this((ClassLoader)null, checkSerializable, buffer);
/*      */   }
/*      */ 
/*      */   public DataContainer(ClassLoader loader, boolean checkSerializable, StringUtilBuffer buffer)
/*      */   {
/*  104 */     this(loader, null, checkSerializable, buffer);
/*      */   }
/*      */ 
/*      */   public DataContainer(ClassLoader loader, boolean checkSerializable, StringUtilBuffer buffer, ClassResolver resolver)
/*      */   {
/*  109 */     this(loader, null, checkSerializable, buffer);
/*      */   }
/*      */ 
/*      */   public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, boolean checkSerializable)
/*      */   {
/*  114 */     this(loader, substitution, null, checkSerializable, null);
/*      */   }
/*      */ 
/*      */   public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, boolean checkSerializable, StringUtilBuffer buffer)
/*      */   {
/*  119 */     this(loader, substitution, null, checkSerializable, buffer);
/*      */   }
/*      */ 
/*      */   public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, SafeCloningRepository safeToReuse, boolean checkSerializable)
/*      */   {
/*  124 */     this();
/*  125 */     this.cache = new ObjectsCache(substitution, loader, safeToReuse, checkSerializable, null);
/*      */   }
/*      */ 
/*      */   public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, SafeCloningRepository safeToReuse, boolean checkSerializable, StringUtilBuffer buffer)
/*      */   {
/*  130 */     this();
/*  131 */     this.cache = new ObjectsCache(substitution, loader, safeToReuse, checkSerializable, buffer);
/*      */   }
/*      */ 
/*      */   public DataContainer(ObjectsCache cache)
/*      */   {
/*  137 */     this.cache = cache;
/*      */   }
/*      */ 
/*      */   public int getSize()
/*      */   {
/*  142 */     return this.content.size();
/*      */   }
/*      */ 
/*      */   public ObjectInput getInput()
/*      */   {
/*  148 */     return new DataContainerInput();
/*      */   }
/*      */ 
/*      */   public ObjectOutput getOutput()
/*      */   {
/*  153 */     if (this.currentOutput == null)
/*      */     {
/*  155 */       this.currentOutput = new DataContainerOutput();
/*      */     }
/*  157 */     return this.currentOutput;
/*      */   }
/*      */ 
/*      */   public ObjectOutput getDirectOutput(DataOutputStream dataOut)
/*      */   {
/*  162 */     return new DataContainerDirectOutput(dataOut);
/*      */   }
/*      */ 
/*      */   public ObjectInput getDirectInput(DataInputStream dataInput)
/*      */   {
/*  167 */     return new DataContainerDirectInput(dataInput);
/*      */   }
/*      */ 
/*      */   public void flush() throws IOException
/*      */   {
/*  172 */     if (this.currentOutput != null)
/*      */     {
/*  174 */       this.currentOutput.flushByteArray();
/*      */     }
/*      */   }
/*      */ 
/*      */   public ObjectsCache getCache()
/*      */   {
/* 1137 */     return this.cache;
/*      */   }
/*      */ 
/*      */   public void saveData(DataOutput output)
/*      */     throws IOException
/*      */   {
/* 1144 */     flush();
/* 1145 */     output.writeInt(getControlStreaming().length);
/* 1146 */     output.write(getControlStreaming());
/* 1147 */     writeMyself(output);
/*      */ 
/* 1153 */     output.write(Externalizable.closeSign);
/*      */   }
/*      */ 
/*      */   private void writeInteger(DataOutput output, Object obj) throws IOException
/*      */   {
/* 1158 */     if ((obj instanceof IntegerContainer))
/*      */     {
/* 1160 */       output.writeByte(6);
/* 1161 */       output.writeInt(((IntegerContainer)obj).getValue());
/*      */     }
/*      */     else {
/* 1164 */       output.writeByte(26);
/* 1165 */       output.writeInt(((Integer)obj).intValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeDouble(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1175 */     if ((obj instanceof DoubleContainer))
/*      */     {
/* 1177 */       output.writeByte(5);
/* 1178 */       output.writeDouble(((DoubleContainer)obj).getValue());
/*      */     }
/*      */     else
/*      */     {
/* 1182 */       output.writeByte(25);
/* 1183 */       output.writeDouble(((Double)obj).doubleValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void saveString(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1191 */     output.writeByte(4);
/* 1192 */     StringUtil.saveString(output, (String)obj, this.cache.getStringBuffer());
/*      */   }
/*      */ 
/*      */   public void loadData(DataInput input)
/*      */     throws IOException
/*      */   {
/* 1199 */     int size = input.readInt();
/* 1200 */     byte[] byteControl = new byte[size];
/* 1201 */     input.readFully(byteControl);
/* 1202 */     setControlStreaming(byteControl);
/*      */ 
/* 1205 */     readMyself(input);
/*      */   }
/*      */ 
/*      */   private boolean compareBuffer(byte[] buffer1, byte[] buffer2)
/*      */   {
/* 1212 */     for (int i = 0; i < buffer1.length; i++)
/*      */     {
/* 1214 */       if (buffer1[i] != buffer2[i])
/*      */       {
/* 1216 */         return false;
/*      */       }
/*      */     }
/* 1219 */     return true;
/*      */   }
/*      */ 
/*      */   public void writeMyself(DataOutput output)
/*      */     throws IOException
/*      */   {
/* 1228 */     if ((this.currentOutput != null) && (this.currentOutput.outByte != null))
/*      */     {
/* 1230 */       this.currentOutput.flushByteArray();
/*      */     }
/*      */ 
/* 1233 */     output.writeInt(this.content.size());
/* 1234 */     Iterator iter = this.content.iterator();
/* 1235 */     while (iter.hasNext())
/*      */     {
/* 1237 */       Object obj = iter.next();
/* 1238 */       if (obj == null)
/*      */       {
/* 1240 */         output.writeByte(99);
/*      */       }
/* 1242 */       else if ((obj instanceof String))
/*      */       {
/* 1244 */         saveString(output, obj);
/*      */       }
/* 1246 */       else if (((obj instanceof ByteContainer)) || ((obj instanceof Byte)))
/*      */       {
/* 1249 */         writeByte(output, obj);
/*      */       }
/* 1251 */       else if (((obj instanceof CharacterContainer)) || ((obj instanceof Character)))
/*      */       {
/* 1253 */         writeCharacter(output, obj);
/*      */       }
/* 1255 */       else if (((obj instanceof ShortContainer)) || ((obj instanceof Short)))
/*      */       {
/* 1257 */         writeShort(output, obj);
/*      */       }
/* 1259 */       else if (((obj instanceof IntegerContainer)) || ((obj instanceof Integer)))
/*      */       {
/* 1261 */         writeInteger(output, obj);
/*      */       }
/* 1263 */       else if (((obj instanceof LongContainer)) || ((obj instanceof Long)))
/*      */       {
/* 1265 */         writeLong(output, obj);
/*      */       }
/* 1267 */       else if (((obj instanceof DoubleContainer)) || ((obj instanceof Double)))
/*      */       {
/* 1269 */         writeDouble(output, obj);
/*      */       }
/* 1271 */       else if (((obj instanceof FloatContainer)) || ((obj instanceof Float)))
/*      */       {
/* 1273 */         writeFloat(output, obj);
/*      */       }
/* 1275 */       else if (((obj instanceof BooleanContainer)) || ((obj instanceof Boolean)))
/*      */       {
/* 1277 */         writeBoolean(output, obj);
/*      */       }
/* 1279 */       else if ((obj instanceof byte[]))
/*      */       {
/* 1281 */         writeByteArray(output, obj);
/*      */       }
/*      */       else
/* 1284 */         throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeFloat(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1295 */     if ((obj instanceof FloatContainer))
/*      */     {
/* 1297 */       output.writeByte(10);
/* 1298 */       output.writeFloat(((FloatContainer)obj).getValue());
/*      */     }
/*      */     else
/*      */     {
/* 1302 */       output.writeByte(30);
/* 1303 */       output.writeFloat(((Float)obj).floatValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeByteArray(DataOutput output, Object obj) throws IOException
/*      */   {
/* 1309 */     output.writeByte(13);
/* 1310 */     output.writeInt(((byte[])(byte[])obj).length);
/* 1311 */     output.write((byte[])(byte[])obj);
/*      */   }
/*      */ 
/*      */   private void writeBoolean(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1320 */     if ((obj instanceof BooleanContainer))
/*      */     {
/* 1322 */       output.writeByte(12);
/* 1323 */       output.writeBoolean(((BooleanContainer)obj).getValue());
/*      */     }
/*      */     else
/*      */     {
/* 1327 */       output.writeByte(32);
/* 1328 */       output.writeBoolean(((Boolean)obj).booleanValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeLong(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1338 */     if ((obj instanceof LongContainer))
/*      */     {
/* 1340 */       output.writeByte(7);
/* 1341 */       output.writeLong(((LongContainer)obj).getValue());
/*      */     }
/*      */     else
/*      */     {
/* 1345 */       output.writeByte(27);
/* 1346 */       output.writeLong(((Long)obj).longValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeShort(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1356 */     if ((obj instanceof ShortContainer))
/*      */     {
/* 1358 */       output.writeByte(8);
/* 1359 */       output.writeShort(((ShortContainer)obj).getValue());
/*      */     }
/*      */     else
/*      */     {
/* 1363 */       output.writeByte(28);
/* 1364 */       output.writeShort(((Short)obj).shortValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeCharacter(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1374 */     if ((obj instanceof Character))
/*      */     {
/* 1376 */       output.writeByte(31);
/* 1377 */       output.writeChar(((Character)obj).charValue());
/*      */     }
/*      */     else
/*      */     {
/* 1381 */       output.writeByte(11);
/* 1382 */       output.writeChar(((CharacterContainer)obj).getValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeByte(DataOutput output, Object obj)
/*      */     throws IOException
/*      */   {
/* 1393 */     if ((obj instanceof ByteContainer))
/*      */     {
/* 1395 */       output.writeByte(9);
/* 1396 */       output.writeByte(((ByteContainer)obj).getValue());
/*      */     }
/*      */     else
/*      */     {
/* 1400 */       output.writeByte(29);
/* 1401 */       output.writeByte(((Byte)obj).byteValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void readMyself(DataInput input)
/*      */     throws IOException
/*      */   {
/* 1410 */     int size = input.readInt();
/*      */ 
/* 1412 */     this.content.clear();
/*      */ 
/* 1414 */     for (int i = 0; i < size; i++)
/*      */     {
/* 1416 */       byte type = input.readByte();
/*      */ 
/* 1418 */       switch (type)
/*      */       {
/*      */       case 99:
/* 1421 */         this.content.add(null); break;
/*      */       case 4:
/* 1423 */         this.content.add(StringUtil.readString(input, this.cache.getStringBuffer())); break;
/*      */       case 9:
/* 1425 */         this.content.add(new ByteContainer(input.readByte())); break;
/*      */       case 29:
/* 1427 */         this.content.add(new Byte(input.readByte())); break;
/*      */       case 8:
/* 1429 */         this.content.add(new ShortContainer(input.readShort())); break;
/*      */       case 28:
/* 1431 */         this.content.add(new Short(input.readShort())); break;
/*      */       case 6:
/* 1433 */         this.content.add(new IntegerContainer(input.readInt())); break;
/*      */       case 26:
/* 1435 */         this.content.add(new Integer(input.readInt())); break;
/*      */       case 7:
/* 1437 */         this.content.add(new LongContainer(input.readLong())); break;
/*      */       case 27:
/* 1439 */         this.content.add(new Long(input.readLong())); break;
/*      */       case 10:
/* 1441 */         this.content.add(new FloatContainer(input.readFloat())); break;
/*      */       case 30:
/* 1443 */         this.content.add(new Float(input.readFloat())); break;
/*      */       case 5:
/* 1445 */         this.content.add(new DoubleContainer(input.readDouble())); break;
/*      */       case 25:
/* 1447 */         this.content.add(new Double(input.readDouble())); break;
/*      */       case 11:
/* 1449 */         this.content.add(new CharacterContainer(input.readChar())); break;
/*      */       case 31:
/* 1451 */         this.content.add(new Character(input.readChar())); break;
/*      */       case 12:
/* 1453 */         this.content.add(BooleanContainer.valueOf(input.readBoolean())); break;
/*      */       case 32:
/* 1455 */         this.content.add(Boolean.valueOf(input.readBoolean())); break;
/*      */       case 13:
/* 1457 */         int sizebArray = input.readInt();
/* 1458 */         byte[] barray = new byte[sizebArray];
/* 1459 */         input.readFully(barray);
/* 1460 */         this.content.add(barray);
/* 1461 */         break;
/*      */       default:
/* 1463 */         throw new SerializationException("I don't know how to read type " + type + " yet");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void writeExternal(ObjectOutput out) throws IOException
/*      */   {
/* 1470 */     saveData(out);
/*      */   }
/*      */ 
/*      */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
/* 1474 */     loadData(in);
/*      */   }
/*      */ 
/*      */   public byte[] getControlStreaming() {
/* 1478 */     if (this.controlStreaming == null)
/*      */     {
/* 1480 */       this.controlStreaming = new byte[0];
/*      */     }
/* 1482 */     return this.controlStreaming;
/*      */   }
/*      */ 
/*      */   public void setControlStreaming(byte[] controlStreaming) {
/* 1486 */     this.controlStreaming = controlStreaming;
/*      */   }
/*      */ 
/*      */   public ClassResolver getClassResolver() {
/* 1490 */     return this.cache.getClassResolver();
/*      */   }
/*      */ 
/*      */   public void setClassResolver(ClassResolver resolver) {
/* 1494 */     this.cache.setClassResolver(resolver);
/*      */   }
/*      */ 
/*      */   public StringUtilBuffer getStringBuffer() {
/* 1498 */     return this.cache.getStringBuffer();
/*      */   }
/*      */ 
/*      */   public void setStringBuffer(StringUtilBuffer stringBuffer) {
/* 1502 */     this.cache.setStringBuffer(stringBuffer);
/*      */   }
/*      */ 
/*      */   class DataContainerInput
/*      */     implements ObjectsCache.JBossSeralizationInputInterface
/*      */   {
/*  810 */     int position = -1;
/*  811 */     Object currentObject = null;
/*      */     ByteArrayInputStream byteStreamInput;
/*      */ 
/*      */     public DataContainerInput()
/*      */     {
/*  816 */       this.byteStreamInput = new ByteArrayInputStream(DataContainer.this.getControlStreaming());
/*      */     }
/*      */ 
/*      */     public void reset()
/*      */     {
/*  821 */       this.position = -1;
/*  822 */       this.byteStreamInput = null;
/*      */     }
/*      */ 
/*      */     boolean moveNext() throws EOFException
/*      */     {
/*  827 */       this.position += 1;
/*      */ 
/*  829 */       if (this.position >= DataContainer.this.content.size())
/*      */       {
/*  831 */         throw new EOFException("Unexpected end of repository");
/*      */       }
/*      */ 
/*  834 */       this.currentObject = DataContainer.this.content.get(this.position);
/*      */ 
/*  836 */       return this.position < DataContainer.this.content.size();
/*      */     }
/*      */ 
/*      */     public Object readObject()
/*      */       throws ClassNotFoundException, IOException
/*      */     {
/*  844 */       DataContainer.this.cache.setInput(this);
/*  845 */       return ObjectDescriptorFactory.objectFromDescription(DataContainer.this.cache, this);
/*      */     }
/*      */ 
/*      */     public int readObjectReference() throws IOException
/*      */     {
/*  850 */       moveNext();
/*  851 */       return ((IntegerContainer)this.currentObject).getValue();
/*      */     }
/*      */ 
/*      */     public byte readByteDirectly() throws IOException {
/*  855 */       return readByte();
/*      */     }
/*      */ 
/*      */     public int read()
/*      */       throws IOException
/*      */     {
/*  878 */       return this.byteStreamInput.read();
/*      */     }
/*      */ 
/*      */     public int read(byte[] b)
/*      */       throws IOException
/*      */     {
/*  887 */       return this.byteStreamInput.read(b);
/*      */     }
/*      */ 
/*      */     public int read(byte[] b, int off, int len)
/*      */       throws IOException
/*      */     {
/*  896 */       return this.byteStreamInput.read(b, off, len);
/*      */     }
/*      */ 
/*      */     public long skip(long n)
/*      */       throws IOException
/*      */     {
/*  905 */       return this.byteStreamInput.skip(n);
/*      */     }
/*      */ 
/*      */     public int available()
/*      */       throws IOException
/*      */     {
/*  914 */       return this.byteStreamInput.available();
/*      */     }
/*      */ 
/*      */     public void close()
/*      */       throws IOException
/*      */     {
/*      */     }
/*      */ 
/*      */     public void readFully(byte[] b)
/*      */       throws IOException
/*      */     {
/*  930 */       this.byteStreamInput.read(b);
/*      */     }
/*      */ 
/*      */     public void readFully(byte[] b, int off, int len)
/*      */       throws IOException
/*      */     {
/*  939 */       this.byteStreamInput.read(b, off, len);
/*      */     }
/*      */ 
/*      */     public int skipBytes(int n)
/*      */       throws IOException
/*      */     {
/*  949 */       return (int)this.byteStreamInput.skip(n);
/*      */     }
/*      */ 
/*      */     public boolean readBoolean()
/*      */       throws IOException
/*      */     {
/*  957 */       moveNext();
/*      */       try
/*      */       {
/*  960 */         return ((BooleanContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/*  964 */       throw new SerializationException("Excepted to be boolean", e);
/*      */     }
/*      */ 
/*      */     public byte readByte()
/*      */       throws IOException
/*      */     {
/*  975 */       return (byte)this.byteStreamInput.read();
/*      */     }
/*      */ 
/*      */     public int readUnsignedByte()
/*      */       throws IOException
/*      */     {
/*  985 */       return this.byteStreamInput.read();
/*      */     }
/*      */ 
/*      */     public short readShort()
/*      */       throws IOException
/*      */     {
/*  993 */       moveNext();
/*      */       try
/*      */       {
/*  996 */         return ((ShortContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1000 */       throw new SerializationException("Excepted to be short", e);
/*      */     }
/*      */ 
/*      */     public int readUnsignedShort()
/*      */       throws IOException
/*      */     {
/* 1009 */       moveNext();
/*      */       try
/*      */       {
/* 1012 */         return ((ShortContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1016 */       throw new SerializationException("Excepted to be short", e);
/*      */     }
/*      */ 
/*      */     public char readChar()
/*      */       throws IOException
/*      */     {
/* 1025 */       moveNext();
/*      */       try
/*      */       {
/* 1028 */         return ((CharacterContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1032 */       throw new SerializationException("Excepted to be char", e);
/*      */     }
/*      */ 
/*      */     public int readInt()
/*      */       throws IOException
/*      */     {
/* 1041 */       moveNext();
/*      */       try
/*      */       {
/* 1044 */         return ((IntegerContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1048 */       throw new SerializationException("Excepted to be int", e);
/*      */     }
/*      */ 
/*      */     public long readLong()
/*      */       throws IOException
/*      */     {
/* 1057 */       moveNext();
/*      */       try
/*      */       {
/* 1060 */         return ((LongContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1064 */       throw new SerializationException("Excepted to be long", e);
/*      */     }
/*      */ 
/*      */     public float readFloat()
/*      */       throws IOException
/*      */     {
/* 1073 */       moveNext();
/*      */       try
/*      */       {
/* 1076 */         return ((FloatContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1080 */       throw new SerializationException("Excepted to be float", e);
/*      */     }
/*      */ 
/*      */     public double readDouble()
/*      */       throws IOException
/*      */     {
/* 1089 */       moveNext();
/*      */       try
/*      */       {
/* 1092 */         return ((DoubleContainer)this.currentObject).getValue();
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1096 */       throw new SerializationException("Excepted to be double", e);
/*      */     }
/*      */ 
/*      */     public String readLine()
/*      */       throws IOException
/*      */     {
/* 1105 */       return readLine();
/*      */     }
/*      */ 
/*      */     public String readUTF()
/*      */       throws IOException
/*      */     {
/* 1113 */       moveNext();
/*      */       try
/*      */       {
/* 1116 */         return (String)this.currentObject;
/*      */       }
/*      */       catch (ClassCastException e) {
/*      */       }
/* 1120 */       throw new SerializationException("Excepted to be String", e);
/*      */     }
/*      */ 
/*      */     public Object readImmutable(byte byteDescription, ObjectsCache cache)
/*      */       throws IOException
/*      */     {
/* 1126 */       moveNext();
/* 1127 */       return this.currentObject;
/*      */     }
/*      */   }
/*      */ 
/*      */   class DataContainerDirectInput
/*      */     implements ObjectsCache.JBossSeralizationInputInterface
/*      */   {
/*      */     DataInputStream dataInp;
/*      */ 
/*      */     public DataContainerDirectInput(DataInputStream dataInp)
/*      */     {
/*  630 */       this.dataInp = dataInp;
/*      */     }
/*      */ 
/*      */     public int readObjectReference() throws IOException {
/*  634 */       return readInt();
/*      */     }
/*      */ 
/*      */     public byte readByteDirectly() throws IOException {
/*  638 */       return (byte)read();
/*      */     }
/*      */ 
/*      */     public Object readObject() throws ClassNotFoundException, IOException {
/*  642 */       DataContainer.this.cache.setInput(this);
/*  643 */       return ObjectDescriptorFactory.objectFromDescription(DataContainer.this.cache, this);
/*      */     }
/*      */ 
/*      */     public int read()
/*      */       throws IOException
/*      */     {
/*  655 */       return this.dataInp.read();
/*      */     }
/*      */ 
/*      */     public long skip(long n)
/*      */       throws IOException
/*      */     {
/*  666 */       return this.dataInp.skip(n);
/*      */     }
/*      */ 
/*      */     public int available()
/*      */       throws IOException
/*      */     {
/*  677 */       return this.dataInp.available();
/*      */     }
/*      */ 
/*      */     public void close()
/*      */       throws IOException
/*      */     {
/*  688 */       this.dataInp.close();
/*      */     }
/*      */ 
/*      */     public int read(byte[] b) throws IOException {
/*  692 */       return this.dataInp.read(b);
/*      */     }
/*      */ 
/*      */     public int read(byte[] b, int off, int len) throws IOException {
/*  696 */       return this.dataInp.read(b, off, len);
/*      */     }
/*      */ 
/*      */     public void readFully(byte[] b) throws IOException {
/*  700 */       this.dataInp.readFully(b);
/*      */     }
/*      */ 
/*      */     public void readFully(byte[] b, int off, int len) throws IOException {
/*  704 */       this.dataInp.readFully(b, off, len);
/*      */     }
/*      */ 
/*      */     public int skipBytes(int n) throws IOException {
/*  708 */       return this.dataInp.skipBytes(n);
/*      */     }
/*      */ 
/*      */     public boolean readBoolean() throws IOException {
/*  712 */       return this.dataInp.readBoolean();
/*      */     }
/*      */ 
/*      */     public byte readByte() throws IOException {
/*  716 */       return this.dataInp.readByte();
/*      */     }
/*      */ 
/*      */     public int readUnsignedByte() throws IOException {
/*  720 */       return this.dataInp.readUnsignedByte();
/*      */     }
/*      */ 
/*      */     public short readShort() throws IOException {
/*  724 */       return this.dataInp.readShort();
/*      */     }
/*      */ 
/*      */     public int readUnsignedShort() throws IOException {
/*  728 */       return this.dataInp.readUnsignedShort();
/*      */     }
/*      */ 
/*      */     public char readChar() throws IOException {
/*  732 */       return this.dataInp.readChar();
/*      */     }
/*      */ 
/*      */     public int readInt() throws IOException {
/*  736 */       return this.dataInp.readInt();
/*      */     }
/*      */ 
/*      */     public long readLong() throws IOException {
/*  740 */       return this.dataInp.readLong();
/*      */     }
/*      */ 
/*      */     public float readFloat() throws IOException {
/*  744 */       return this.dataInp.readFloat();
/*      */     }
/*      */ 
/*      */     public double readDouble() throws IOException {
/*  748 */       return this.dataInp.readDouble();
/*      */     }
/*      */ 
/*      */     public String readLine() throws IOException {
/*  752 */       return this.dataInp.readLine();
/*      */     }
/*      */ 
/*      */     public String readUTF() throws IOException
/*      */     {
/*  757 */       return StringUtil.readString(this.dataInp, DataContainer.this.cache.getStringBuffer());
/*      */     }
/*      */ 
/*      */     public String readUTF(DataInput in) throws IOException
/*      */     {
/*  762 */       return StringUtil.readString(in, DataContainer.this.cache.getStringBuffer());
/*      */     }
/*      */ 
/*      */     public Object readImmutable(byte byteDescription, ObjectsCache cache) throws IOException
/*      */     {
/*  767 */       Object retObject = null;
/*  768 */       int reference = readObjectReference();
/*  769 */       switch (byteDescription)
/*      */       {
/*      */       case 40:
/*  772 */         retObject = cache.findObjectInCacheRead(reference);
/*  773 */         if (retObject != null)
/*      */           break;
/*  775 */         throw new IOException("reference " + reference + " not found no readImmutable");
/*      */       case 4:
/*  779 */         retObject = StringUtil.readString(this, cache.getStringBuffer()); break;
/*      */       case 9:
/*  781 */         retObject = new Byte(readByte()); break;
/*      */       case 11:
/*  783 */         retObject = new Character(readChar()); break;
/*      */       case 8:
/*  785 */         retObject = new Short(readShort()); break;
/*      */       case 6:
/*  787 */         retObject = new Integer(readInt()); break;
/*      */       case 7:
/*  789 */         retObject = new Long(readLong()); break;
/*      */       case 5:
/*  791 */         retObject = new Double(readDouble()); break;
/*      */       case 10:
/*  793 */         retObject = new Float(readFloat()); break;
/*      */       case 12:
/*  795 */         retObject = new Boolean(readBoolean());
/*      */       case 13:
/*      */       case 14:
/*      */       case 15:
/*      */       case 16:
/*      */       case 17:
/*      */       case 18:
/*      */       case 19:
/*      */       case 20:
/*      */       case 21:
/*      */       case 22:
/*      */       case 23:
/*      */       case 24:
/*      */       case 25:
/*      */       case 26:
/*      */       case 27:
/*      */       case 28:
/*      */       case 29:
/*      */       case 30:
/*      */       case 31:
/*      */       case 32:
/*      */       case 33:
/*      */       case 34:
/*      */       case 35:
/*      */       case 36:
/*      */       case 37:
/*      */       case 38:
/*  798 */       case 39: } if (byteDescription != 40)
/*      */       {
/*  800 */         cache.putObjectInCacheRead(reference, retObject);
/*      */       }
/*      */ 
/*  803 */       return retObject;
/*      */     }
/*      */   }
/*      */ 
/*      */   class DataContainerOutput
/*      */     implements ObjectsCache.JBossSeralizationOutputInterface
/*      */   {
/*  358 */     ByteArrayOutputStream outByte = new ByteArrayOutputStream();
/*      */ 
/*      */     DataContainerOutput() {
/*      */     }
/*      */     private void flushByteArray() {
/*  363 */       if (this.outByte != null)
/*      */       {
/*  365 */         byte[] controlStreaming = this.outByte.toByteArray();
/*  366 */         DataContainer.this.setControlStreaming(controlStreaming);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void writeObject(Object obj)
/*      */       throws IOException
/*      */     {
/*  376 */       if (obj == null)
/*      */       {
/*  378 */         writeByte(99);
/*      */       }
/*      */       else
/*      */       {
/*  382 */         if (ClassMetamodelFactory.isImmutable(obj.getClass()))
/*      */         {
/*  384 */           if (DataContainer.this.cache.getSubstitution() != null)
/*      */           {
/*  386 */             obj = DataContainer.this.cache.getSubstitution().replaceObject(obj);
/*      */           }
/*      */         }
/*  389 */         DataContainer.this.cache.setOutput(this);
/*  390 */         ObjectDescriptorFactory.describeObject(DataContainer.this.cache, obj);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void addObjectReference(int reference) throws IOException
/*      */     {
/*  396 */       writeInt(reference);
/*      */     }
/*      */ 
/*      */     public void saveImmutable(ObjectsCache cache, Object obj) throws IOException {
/*  400 */       if ((obj instanceof String))
/*      */       {
/*  402 */         writeByte(4);
/*  403 */         DataContainer.this.content.add(obj);
/*      */       }
/*  405 */       else if ((obj instanceof Byte))
/*      */       {
/*  407 */         writeByte(9);
/*  408 */         DataContainer.this.content.add(obj);
/*      */       }
/*  410 */       else if ((obj instanceof Character))
/*      */       {
/*  412 */         writeByte(11);
/*  413 */         DataContainer.this.content.add(obj);
/*      */       }
/*  415 */       else if ((obj instanceof Short))
/*      */       {
/*  417 */         writeByte(8);
/*  418 */         DataContainer.this.content.add(obj);
/*      */       }
/*  420 */       else if ((obj instanceof Integer))
/*      */       {
/*  422 */         writeByte(6);
/*  423 */         DataContainer.this.content.add(obj);
/*      */       }
/*  425 */       else if ((obj instanceof Long))
/*      */       {
/*  427 */         writeByte(7);
/*  428 */         DataContainer.this.content.add(obj);
/*      */       }
/*  430 */       else if ((obj instanceof Double))
/*      */       {
/*  432 */         writeByte(5);
/*  433 */         DataContainer.this.content.add(obj);
/*      */       }
/*  435 */       else if ((obj instanceof Float))
/*      */       {
/*  437 */         writeByte(10);
/*  438 */         DataContainer.this.content.add(obj);
/*      */       }
/*  440 */       else if (((obj instanceof BooleanContainer)) || ((obj instanceof Boolean)))
/*      */       {
/*  442 */         writeByte(12);
/*  443 */         DataContainer.this.content.add(obj);
/*      */       }
/*      */       else {
/*  446 */         throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
/*      */       }
/*      */     }
/*      */ 
/*      */     public void writeByteDirectly(byte parameter)
/*      */       throws IOException
/*      */     {
/*  453 */       writeByte(parameter);
/*      */     }
/*      */ 
/*      */     public void openObjectDefinition()
/*      */       throws IOException
/*      */     {
/*      */     }
/*      */ 
/*      */     public void closeObjectDefinition()
/*      */       throws IOException
/*      */     {
/*      */     }
/*      */ 
/*      */     public void write(int b)
/*      */       throws IOException
/*      */     {
/*  470 */       this.outByte.write(b);
/*      */     }
/*      */ 
/*      */     public void write(byte[] b)
/*      */       throws IOException
/*      */     {
/*  478 */       this.outByte.write(b);
/*      */     }
/*      */ 
/*      */     public void write(byte[] b, int off, int len)
/*      */       throws IOException
/*      */     {
/*  486 */       this.outByte.write(b, off, len);
/*      */     }
/*      */ 
/*      */     public void flush()
/*      */       throws IOException
/*      */     {
/*  495 */       flushByteArray();
/*      */     }
/*      */ 
/*      */     public void close()
/*      */       throws IOException
/*      */     {
/*  503 */       flush();
/*      */     }
/*      */ 
/*      */     public void writeBoolean(boolean v)
/*      */       throws IOException
/*      */     {
/*  512 */       DataContainer.this.content.add(BooleanContainer.valueOf(v));
/*      */     }
/*      */ 
/*      */     public void writeByte(int v)
/*      */       throws IOException
/*      */     {
/*  521 */       this.outByte.write(v);
/*      */     }
/*      */ 
/*      */     public void writeShort(int v)
/*      */       throws IOException
/*      */     {
/*  530 */       DataContainer.this.content.add(new ShortContainer((short)v));
/*      */     }
/*      */ 
/*      */     public void writeChar(int v)
/*      */       throws IOException
/*      */     {
/*  539 */       DataContainer.this.content.add(new CharacterContainer((char)v));
/*      */     }
/*      */ 
/*      */     public void writeInt(int v)
/*      */       throws IOException
/*      */     {
/*  549 */       DataContainer.this.content.add(new IntegerContainer(v));
/*      */     }
/*      */ 
/*      */     public void writeLong(long v)
/*      */       throws IOException
/*      */     {
/*  559 */       DataContainer.this.content.add(new LongContainer(v));
/*      */     }
/*      */ 
/*      */     public void writeFloat(float v)
/*      */       throws IOException
/*      */     {
/*  569 */       DataContainer.this.content.add(new FloatContainer(v));
/*      */     }
/*      */ 
/*      */     public void writeDouble(double v)
/*      */       throws IOException
/*      */     {
/*  579 */       DataContainer.this.content.add(new DoubleContainer(v));
/*      */     }
/*      */ 
/*      */     public void writeBytes(String s)
/*      */       throws IOException
/*      */     {
/*  589 */       char[] chars = s.toCharArray();
/*  590 */       for (int i = 0; i < chars.length; i++)
/*      */       {
/*  592 */         write(chars[i]);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void writeChars(String s)
/*      */       throws IOException
/*      */     {
/*  602 */       char[] chars = s.toCharArray();
/*  603 */       for (int i = 0; i < chars.length; i++)
/*      */       {
/*  605 */         writeChar(chars[i]);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void writeUTF(String str)
/*      */       throws IOException
/*      */     {
/*  615 */       DataContainer.this.content.add(str);
/*      */     }
/*      */ 
/*      */     public boolean isCheckSerializableClass() {
/*  619 */       return DataContainer.this.cache.isCheckSerializableClass();
/*      */     }
/*      */   }
/*      */ 
/*      */   class DataContainerDirectOutput
/*      */     implements ObjectsCache.JBossSeralizationOutputInterface
/*      */   {
/*      */     DataOutputStream dataOut;
/*      */ 
/*      */     public void addObjectReference(int reference)
/*      */       throws IOException
/*      */     {
/*  183 */       writeInt(reference);
/*      */     }
/*      */ 
/*      */     public void openObjectDefinition() throws IOException {
/*      */     }
/*      */ 
/*      */     public void closeObjectDefinition() throws IOException {
/*      */     }
/*      */ 
/*      */     public void writeByteDirectly(byte parameter) throws IOException {
/*  193 */       write(parameter);
/*      */     }
/*      */ 
/*      */     public boolean isCheckSerializableClass() {
/*  197 */       return DataContainer.this.getCache().isCheckSerializableClass();
/*      */     }
/*      */ 
/*      */     public void writeObject(Object obj) throws IOException {
/*  201 */       DataContainer.this.cache.setOutput(this);
/*  202 */       if (DataContainer.this.cache.getSubstitution() != null)
/*      */       {
/*  204 */         obj = DataContainer.this.cache.getSubstitution().replaceObject(obj);
/*      */       }
/*  206 */       ObjectDescriptorFactory.describeObject(DataContainer.this.cache, obj);
/*      */     }
/*      */ 
/*      */     public void write(byte[] b) throws IOException {
/*  210 */       this.dataOut.write(b);
/*      */     }
/*      */ 
/*      */     public void close() throws IOException {
/*  214 */       this.dataOut.close();
/*      */     }
/*      */ 
/*      */     public DataContainerDirectOutput(DataOutputStream dataOut) {
/*  218 */       this.dataOut = dataOut;
/*      */     }
/*      */ 
/*      */     public void write(int b) throws IOException {
/*  222 */       this.dataOut.write(b);
/*      */     }
/*      */ 
/*      */     public void write(byte[] b, int off, int len) throws IOException {
/*  226 */       this.dataOut.write(b, off, len);
/*      */     }
/*      */ 
/*      */     public void flush() throws IOException {
/*  230 */       this.dataOut.flush();
/*      */     }
/*      */ 
/*      */     public void writeBoolean(boolean v) throws IOException {
/*  234 */       this.dataOut.writeBoolean(v);
/*      */     }
/*      */ 
/*      */     public void writeByte(int v) throws IOException {
/*  238 */       this.dataOut.writeByte(v);
/*      */     }
/*      */ 
/*      */     public void writeShort(int v) throws IOException {
/*  242 */       this.dataOut.writeShort(v);
/*      */     }
/*      */ 
/*      */     public void writeChar(int v) throws IOException {
/*  246 */       this.dataOut.writeChar(v);
/*      */     }
/*      */ 
/*      */     public void writeInt(int v) throws IOException {
/*  250 */       this.dataOut.writeInt(v);
/*      */     }
/*      */ 
/*      */     public void writeLong(long v) throws IOException {
/*  254 */       this.dataOut.writeLong(v);
/*      */     }
/*      */ 
/*      */     public void writeFloat(float v) throws IOException {
/*  258 */       this.dataOut.writeFloat(v);
/*      */     }
/*      */ 
/*      */     public void writeDouble(double v) throws IOException {
/*  262 */       this.dataOut.writeDouble(v);
/*      */     }
/*      */ 
/*      */     public void writeBytes(String s) throws IOException {
/*  266 */       this.dataOut.writeBytes(s);
/*      */     }
/*      */ 
/*      */     public void writeChars(String s) throws IOException {
/*  270 */       this.dataOut.writeChars(s);
/*      */     }
/*      */ 
/*      */     public void writeUTF(String str) throws IOException {
/*  274 */       StringUtil.saveString(this.dataOut, str, DataContainer.this.cache.getStringBuffer());
/*      */     }
/*      */ 
/*      */     public int size() {
/*  278 */       return this.dataOut.size();
/*      */     }
/*      */ 
/*      */     public void saveImmutable(ObjectsCache cache, Object obj) throws IOException
/*      */     {
/*  283 */       int id = cache.findIdInCacheWrite(obj);
/*  284 */       if (id != 0)
/*      */       {
/*  286 */         writeByte(40);
/*  287 */         addObjectReference(id);
/*  288 */         return;
/*      */       }
/*  290 */       id = cache.putObjectInCacheWrite(obj);
/*  291 */       if ((obj instanceof String))
/*      */       {
/*  293 */         writeByte(4);
/*  294 */         addObjectReference(id);
/*  295 */         StringUtil.saveString(this, (String)obj, cache.getStringBuffer());
/*      */       }
/*  297 */       else if ((obj instanceof Byte))
/*      */       {
/*  299 */         writeByte(9);
/*  300 */         addObjectReference(id);
/*  301 */         writeByte(((Byte)obj).byteValue());
/*      */       }
/*  303 */       else if ((obj instanceof Character))
/*      */       {
/*  305 */         writeByte(11);
/*  306 */         addObjectReference(id);
/*  307 */         writeChar(((Character)obj).charValue());
/*      */       }
/*  309 */       else if ((obj instanceof Short))
/*      */       {
/*  311 */         writeByte(8);
/*  312 */         addObjectReference(id);
/*  313 */         writeShort(((Short)obj).shortValue());
/*      */       }
/*  315 */       else if ((obj instanceof Integer))
/*      */       {
/*  317 */         writeByte(6);
/*  318 */         addObjectReference(id);
/*  319 */         writeInt(((Integer)obj).intValue());
/*      */       }
/*  321 */       else if ((obj instanceof Long))
/*      */       {
/*  323 */         writeByte(7);
/*  324 */         addObjectReference(id);
/*  325 */         writeLong(((Long)obj).longValue());
/*      */       }
/*  327 */       else if ((obj instanceof Double))
/*      */       {
/*  329 */         writeByte(5);
/*  330 */         addObjectReference(id);
/*  331 */         writeDouble(((Double)obj).doubleValue());
/*      */       }
/*  333 */       else if ((obj instanceof Float))
/*      */       {
/*  335 */         writeByte(10);
/*  336 */         addObjectReference(id);
/*  337 */         writeFloat(((Float)obj).floatValue());
/*      */       }
/*  339 */       else if (((obj instanceof BooleanContainer)) || ((obj instanceof Boolean)))
/*      */       {
/*  341 */         writeByte(12);
/*  342 */         addObjectReference(id);
/*  343 */         writeBoolean(((Boolean)obj).booleanValue());
/*      */       }
/*      */       else {
/*  346 */         throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.objectmetamodel.DataContainer
 * JD-Core Version:    0.6.0
 */