/*    */ package org.jboss.serial.io;
/*    */ 
/*    */ import java.io.DataOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectOutput;
/*    */ import java.io.OutputStream;
/*    */ import org.jboss.serial.objectmetamodel.DataContainer;
/*    */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*    */ import org.jboss.serial.util.StringUtilBuffer;
/*    */ 
/*    */ public class JBossObjectOutputStreamSharedTree extends JBossObjectOutputStream
/*    */ {
/*    */   ObjectOutput objectOutput;
/*    */   DataContainer dataContainer;
/*    */ 
/*    */   public JBossObjectOutputStreamSharedTree(OutputStream output, boolean checkSerializableClass, StringUtilBuffer buffer)
/*    */     throws IOException
/*    */   {
/* 42 */     super(output, checkSerializableClass, buffer);
/*    */   }
/*    */ 
/*    */   public JBossObjectOutputStreamSharedTree(OutputStream output, boolean checkSerializableClass) throws IOException {
/* 46 */     super(output, checkSerializableClass);
/*    */   }
/*    */ 
/*    */   public JBossObjectOutputStreamSharedTree(OutputStream output, StringUtilBuffer buffer) throws IOException {
/* 50 */     super(output, buffer);
/*    */   }
/*    */ 
/*    */   public JBossObjectOutputStreamSharedTree(OutputStream output) throws IOException {
/* 54 */     super(output);
/*    */   }
/*    */ 
/*    */   protected void writeObjectOverride(Object obj) throws IOException {
/* 58 */     checkOutput();
/* 59 */     this.objectOutput.writeObject(obj);
/*    */   }
/*    */ 
/*    */   public void reset() throws IOException {
/* 63 */     checkOutput();
/* 64 */     this.objectOutput.writeByte(60);
/* 65 */     this.dataContainer.getCache().reset();
/*    */   }
/*    */ 
/*    */   private void checkOutput() throws IOException {
/* 69 */     if (this.objectOutput == null)
/*    */     {
/* 71 */       this.dataContainer = new DataContainer(null, getSubstitutionInterface(), this.checkSerializableClass, this.buffer);
/* 72 */       if ((this.output instanceof DataOutputStream))
/*    */       {
/* 74 */         this.dataOutput = ((DataOutputStream)this.output);
/*    */       }
/*    */       else
/*    */       {
/* 78 */         this.dataOutput = new DataOutputStream(this.output);
/*    */       }
/*    */ 
/* 81 */       this.objectOutput = this.dataContainer.getDirectOutput(this.dataOutput);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.io.JBossObjectOutputStreamSharedTree
 * JD-Core Version:    0.6.0
 */