/*    */ package org.jboss.serial.io;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectInput;
/*    */ import org.jboss.serial.objectmetamodel.DataContainer;
/*    */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*    */ import org.jboss.serial.util.StringUtilBuffer;
/*    */ 
/*    */ public class JBossObjectInputStreamSharedTree extends JBossObjectInputStream
/*    */ {
/* 36 */   ObjectInput input = null;
/* 37 */   DataContainer container = null;
/*    */ 
/* 39 */   public JBossObjectInputStreamSharedTree(InputStream is, ClassLoader loader, StringUtilBuffer buffer) throws IOException { super(is, loader, buffer); }
/*    */ 
/*    */   public JBossObjectInputStreamSharedTree(InputStream is, ClassLoader loader) throws IOException
/*    */   {
/* 43 */     super(is, loader);
/*    */   }
/*    */ 
/*    */   public JBossObjectInputStreamSharedTree(InputStream is, StringUtilBuffer buffer) throws IOException {
/* 47 */     super(is, buffer);
/*    */   }
/*    */ 
/*    */   public JBossObjectInputStreamSharedTree(InputStream is) throws IOException {
/* 51 */     super(is);
/*    */   }
/*    */ 
/*    */   public Object readObjectOverride() throws IOException, ClassNotFoundException {
/* 55 */     if (this.input == null)
/*    */     {
/* 57 */       this.container = new DataContainer(this.classLoader, false, this.buffer);
/* 58 */       this.container.setClassResolver(this.resolver);
/* 59 */       this.input = this.container.getDirectInput(this.dis);
/*    */     }
/* 61 */     return this.input.readObject();
/*    */   }
/*    */ 
/*    */   public ClassLoader getClassLoader() {
/* 65 */     return super.getClassLoader();
/*    */   }
/*    */ 
/*    */   public void setClassLoader(ClassLoader classLoader) {
/* 69 */     if (this.container != null)
/*    */     {
/* 71 */       this.container.getCache().setLoader(classLoader);
/*    */     }
/* 73 */     super.setClassLoader(classLoader);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.serial.io.JBossObjectInputStreamSharedTree
 * JD-Core Version:    0.6.0
 */