/*     */ package org.jboss.security.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Arrays;
/*     */ import java.util.WeakHashMap;
/*     */ import javassist.util.proxy.ProxyFactory;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.ssl.SSLContext;
/*     */ import javax.net.ssl.SSLServerSocket;
/*     */ import javax.net.ssl.SSLServerSocketFactory;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSessionContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ 
/*     */ public class DomainServerSocketFactory extends SSLServerSocketFactory
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(DomainServerSocketFactory.class);
/*     */ 
/*  56 */   private static WeakHashMap sessionMap = new WeakHashMap();
/*     */   private transient SecurityDomain securityDomain;
/*     */   private transient InetAddress bindAddress;
/*  60 */   private transient SSLContext sslCtx = null;
/*  61 */   private boolean wantsClientAuth = true;
/*  62 */   private boolean needsClientAuth = false;
/*     */   private String[] cipherSuites;
/*     */   private String[] protocols;
/*     */ 
/*     */   public static ServerSocketFactory getDefault()
/*     */   {
/*  71 */     DomainServerSocketFactory ssf = null;
/*     */     try
/*     */     {
/*  74 */       InitialContext iniCtx = new InitialContext();
/*  75 */       SecurityDomain sd = (SecurityDomain)iniCtx.lookup("java:/jaas/other");
/*  76 */       ssf = new DomainServerSocketFactory(sd);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  80 */       log.error("Failed to create default ServerSocketFactory", e);
/*     */     }
/*  82 */     return ssf;
/*     */   }
/*     */ 
/*     */   public static synchronized SSLSession getSSLSession(String sessionID)
/*     */   {
/*  87 */     SSLSession session = (SSLSession)sessionMap.get(sessionID);
/*  88 */     return session;
/*     */   }
/*     */ 
/*     */   static synchronized SSLSession putSSLSession(String sessionID, SSLSession session) {
/*  92 */     SSLSession prevSession = (SSLSession)sessionMap.put(sessionID, session);
/*  93 */     return prevSession;
/*     */   }
/*     */ 
/*     */   static synchronized SSLSession removeSSLSession(String sessionID) {
/*  97 */     SSLSession session = (SSLSession)sessionMap.remove(sessionID);
/*  98 */     return session;
/*     */   }
/*     */ 
/*     */   public DomainServerSocketFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DomainServerSocketFactory(SecurityDomain securityDomain)
/*     */     throws IOException
/*     */   {
/* 112 */     if (securityDomain == null)
/* 113 */       throw new IOException("The securityDomain may not be null");
/* 114 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/* 119 */     String address = null;
/* 120 */     if (this.bindAddress != null)
/* 121 */       address = this.bindAddress.getHostAddress();
/* 122 */     return address;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String host) throws UnknownHostException {
/* 126 */     this.bindAddress = InetAddress.getByName(host);
/*     */   }
/*     */ 
/*     */   public SecurityDomain getSecurityDomain()
/*     */   {
/* 131 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(SecurityDomain securityDomain) {
/* 135 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public boolean isWantsClientAuth()
/*     */   {
/* 140 */     return this.wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setWantsClientAuth(boolean wantsClientAuth) {
/* 144 */     this.wantsClientAuth = wantsClientAuth;
/*     */   }
/*     */ 
/*     */   public boolean isNeedsClientAuth()
/*     */   {
/* 149 */     return this.needsClientAuth;
/*     */   }
/*     */ 
/*     */   public void setNeedsClientAuth(boolean needsClientAuth) {
/* 153 */     this.needsClientAuth = needsClientAuth;
/*     */   }
/*     */ 
/*     */   public String[] getCipherSuites()
/*     */   {
/* 161 */     return this.cipherSuites;
/*     */   }
/*     */ 
/*     */   public void setCipherSuites(String[] cipherSuites)
/*     */   {
/* 168 */     this.cipherSuites = cipherSuites;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public String[] getCiperSuites()
/*     */   {
/* 178 */     return this.cipherSuites;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void setCiperSuites(String[] cipherSuites)
/*     */   {
/* 188 */     this.cipherSuites = cipherSuites;
/*     */   }
/*     */ 
/*     */   public String[] getProtocols()
/*     */   {
/* 193 */     return this.protocols;
/*     */   }
/*     */ 
/*     */   public void setProtocols(String[] protocols) {
/* 197 */     this.protocols = protocols;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/* 203 */     return createServerSocket(port, 50, this.bindAddress);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog) throws IOException
/*     */   {
/* 208 */     return createServerSocket(port, backlog, this.bindAddress);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress)
/*     */     throws IOException
/*     */   {
/* 225 */     initSSLContext();
/* 226 */     SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
/* 227 */     SSLServerSocket socket = (SSLServerSocket)factory.createServerSocket(port, backlog, ifAddress);
/* 228 */     SSLSessionContext ctx = this.sslCtx.getServerSessionContext();
/* 229 */     System.out.println(ctx);
/* 230 */     if (log.isTraceEnabled())
/*     */     {
/* 232 */       String[] supportedProtocols = socket.getSupportedProtocols();
/* 233 */       log.debug("Supported protocols: " + Arrays.asList(supportedProtocols));
/* 234 */       String[] supportedCipherSuites = socket.getSupportedCipherSuites();
/* 235 */       log.debug("Supported CipherSuites: " + Arrays.asList(supportedCipherSuites));
/*     */     }
/* 237 */     socket.setNeedClientAuth(this.needsClientAuth);
/* 238 */     socket.setWantClientAuth(this.wantsClientAuth);
/* 239 */     if (this.protocols != null)
/* 240 */       socket.setEnabledProtocols(this.protocols);
/* 241 */     if (this.cipherSuites != null) {
/* 242 */       socket.setEnabledCipherSuites(this.cipherSuites);
/*     */     }
/* 244 */     DomainServerSocket handler = new DomainServerSocket(socket);
/* 245 */     ProxyFactory pf = new ProxyFactory();
/* 246 */     pf.setHandler(handler);
/* 247 */     pf.setSuperclass(SSLServerSocket.class);
/* 248 */     Class[] sig = new Class[0];
/* 249 */     Object[] args = new Object[0];
/*     */ 
/* 251 */     SSLServerSocket proxy = null;
/*     */     try
/*     */     {
/* 254 */       proxy = (SSLServerSocket)pf.create(sig, args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 258 */       IOException ioe = new IOException("Failed to create SSLServerSocket proxy");
/* 259 */       ioe.initCause(e);
/* 260 */       throw ioe;
/*     */     }
/* 262 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String[] getDefaultCipherSuites()
/*     */   {
/* 267 */     String[] cipherSuites = new String[0];
/*     */     try
/*     */     {
/* 270 */       initSSLContext();
/* 271 */       SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
/* 272 */       cipherSuites = factory.getDefaultCipherSuites();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 276 */       log.error("Failed to get default SSLServerSocketFactory", e);
/*     */     }
/* 278 */     return cipherSuites;
/*     */   }
/*     */ 
/*     */   public String[] getSupportedCipherSuites()
/*     */   {
/* 283 */     String[] cipherSuites = new String[0];
/*     */     try
/*     */     {
/* 286 */       initSSLContext();
/* 287 */       SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
/* 288 */       cipherSuites = factory.getSupportedCipherSuites();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 292 */       log.error("Failed to get default SSLServerSocketFactory", e);
/*     */     }
/* 294 */     return cipherSuites;
/*     */   }
/*     */ 
/*     */   private void initSSLContext()
/*     */     throws IOException
/*     */   {
/* 302 */     if (this.sslCtx != null)
/* 303 */       return;
/* 304 */     this.sslCtx = Context.forDomain(this.securityDomain);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.ssl.DomainServerSocketFactory
 * JD-Core Version:    0.6.0
 */