/*     */ package org.jboss.security.plugins.mapping;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.MappingInfo;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ import org.jboss.security.mapping.MappingContext;
/*     */ import org.jboss.security.mapping.MappingManager;
/*     */ import org.jboss.security.mapping.MappingProvider;
/*     */ import org.jboss.security.mapping.config.MappingModuleEntry;
/*     */ import org.jboss.security.plugins.JBossSecurityContext;
/*     */ 
/*     */ public class JBossMappingManager
/*     */   implements MappingManager
/*     */ {
/*  50 */   protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
/*  51 */   protected boolean trace = log.isTraceEnabled();
/*     */   private String securityDomain;
/*     */ 
/*     */   public JBossMappingManager(String domain)
/*     */   {
/*  57 */     this.securityDomain = domain;
/*     */   }
/*     */ 
/*     */   public MappingContext getMappingContext(Class mappingType)
/*     */   {
/*  66 */     ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
/*     */ 
/*  68 */     if (aPolicy == null)
/*     */     {
/*  70 */       String defaultDomain = "other";
/*  71 */       if (this.trace) {
/*  72 */         log.trace("Application Policy not found for domain=" + this.securityDomain + ".Mapping framework will use the default domain:" + defaultDomain);
/*     */       }
/*  74 */       aPolicy = SecurityConfiguration.getApplicationPolicy(defaultDomain);
/*     */     }
/*  76 */     if (aPolicy == null) {
/*  77 */       throw new IllegalStateException("Application Policy is null for the security domain:" + this.securityDomain);
/*     */     }
/*  79 */     MappingInfo rmi = null;
/*  80 */     MappingContext mc = null;
/*  81 */     if (mappingType == Group.class)
/*     */     {
/*  83 */       rmi = aPolicy.getRoleMappingInfo();
/*     */     }
/*  85 */     else if (mappingType == Principal.class)
/*     */     {
/*  87 */       rmi = aPolicy.getPrincipalMappingInfo();
/*     */     }
/*     */ 
/*  90 */     if (rmi != null)
/*     */     {
/*  92 */       MappingModuleEntry[] mpe = rmi.getMappingModuleEntry();
/*  93 */       ArrayList al = new ArrayList();
/*     */ 
/*  95 */       for (int i = 0; i < mpe.length; i++)
/*     */       {
/*  97 */         MappingProvider mp = getMappingProvider(mpe[i]);
/*  98 */         if (mp != null)
/*  99 */           al.add(mp);
/*     */       }
/* 101 */       mc = new MappingContext(al);
/*     */     }
/*     */ 
/* 104 */     return mc;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 109 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   private MappingProvider getMappingProvider(MappingModuleEntry mme)
/*     */   {
/* 114 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 115 */     MappingProvider mp = null;
/*     */     try
/*     */     {
/* 118 */       Class cl = tcl.loadClass(mme.getMappingModuleName());
/* 119 */       mp = (MappingProvider)cl.newInstance();
/* 120 */       mp.init(mme.getOptions());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 124 */       if (this.trace)
/* 125 */         log.trace("Error in getting Mapping Provider", e);
/*     */     }
/* 127 */     return mp;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.mapping.JBossMappingManager
 * JD-Core Version:    0.6.0
 */