/*    */ package org.jboss.security.plugins.identitytrust;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.SecurityContext;
/*    */ import org.jboss.security.identitytrust.IdentityTrustContext;
/*    */ import org.jboss.security.identitytrust.IdentityTrustException;
/*    */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*    */ import org.jboss.security.identitytrust.IdentityTrustManager.TrustDecision;
/*    */ import org.jboss.security.identitytrust.JBossIdentityTrustContext;
/*    */ 
/*    */ public class JBossIdentityTrustManager
/*    */   implements IdentityTrustManager
/*    */ {
/* 41 */   protected static Logger log = Logger.getLogger(JBossIdentityTrustManager.class);
/* 42 */   private String securityDomain = null;
/* 43 */   private IdentityTrustContext identityTrustContext = null;
/*    */ 
/*    */   public JBossIdentityTrustManager(String securityDomain)
/*    */   {
/* 47 */     this.securityDomain = securityDomain;
/*    */   }
/*    */ 
/*    */   public void setIdentityTrustContext(IdentityTrustContext itc)
/*    */   {
/* 52 */     if (itc == null)
/* 53 */       throw new IllegalArgumentException("null Identity Trust Context");
/* 54 */     this.identityTrustContext = itc;
/*    */   }
/*    */ 
/*    */   public IdentityTrustManager.TrustDecision isTrusted(SecurityContext securityContext)
/*    */   {
/* 62 */     if (securityContext == null)
/* 63 */       throw new IllegalArgumentException("Security Context is null");
/* 64 */     if (this.identityTrustContext == null)
/* 65 */       this.identityTrustContext = new JBossIdentityTrustContext(this.securityDomain, securityContext);
/* 66 */     IdentityTrustManager.TrustDecision td = IdentityTrustManager.TrustDecision.NotApplicable;
/* 67 */     if (this.identityTrustContext == null) {
/* 68 */       throw new IllegalStateException("IdentityTrustContext is null");
/*    */     }
/*    */     try
/*    */     {
/* 72 */       td = this.identityTrustContext.isTrusted();
/*    */     }
/*    */     catch (IdentityTrustException e)
/*    */     {
/* 76 */       log.trace("Trust Exception:", e);
/*    */     }
/* 78 */     return td;
/*    */   }
/*    */ 
/*    */   public String getSecurityDomain()
/*    */   {
/* 83 */     return this.securityDomain;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager
 * JD-Core Version:    0.6.0
 */