/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.SecretKey;
/*     */ import javax.crypto.SecretKeyFactory;
/*     */ import javax.crypto.spec.PBEKeySpec;
/*     */ import javax.crypto.spec.PBEParameterSpec;
/*     */ import org.jboss.security.Base64Utils;
/*     */ 
/*     */ public class PBEUtils
/*     */ {
/*     */   public static byte[] encode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec)
/*     */     throws Exception
/*     */   {
/*  50 */     Cipher cipher = Cipher.getInstance(cipherAlgorithm);
/*  51 */     cipher.init(1, cipherKey, cipherSpec);
/*  52 */     byte[] encoding = cipher.doFinal(secret);
/*  53 */     return encoding;
/*     */   }
/*     */ 
/*     */   public static String encode64(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec)
/*     */     throws Exception
/*     */   {
/*  60 */     byte[] encoding = encode(secret, cipherAlgorithm, cipherKey, cipherSpec);
/*  61 */     String b64 = Base64Utils.tob64(encoding);
/*  62 */     return b64;
/*     */   }
/*     */ 
/*     */   public static byte[] decode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec)
/*     */     throws Exception
/*     */   {
/*  69 */     Cipher cipher = Cipher.getInstance(cipherAlgorithm);
/*  70 */     cipher.init(2, cipherKey, cipherSpec);
/*  71 */     byte[] decode = cipher.doFinal(secret);
/*  72 */     return decode;
/*     */   }
/*     */ 
/*     */   public static String decode64(String secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec)
/*     */     throws Exception
/*     */   {
/*  79 */     byte[] encoding = Base64Utils.fromb64(secret);
/*  80 */     byte[] decode = decode(encoding, cipherAlgorithm, cipherKey, cipherSpec);
/*  81 */     return new String(decode, "UTF-8");
/*     */   }
/*     */ 
/*     */   public static void main(String[] args) throws Exception
/*     */   {
/*  86 */     if (args.length != 4)
/*     */     {
/*  88 */       System.err.println("Ecrypt a password using the JaasSecurityDomain passwordUsage: PBEUtils salt count domain-password passwordsalt : the Salt attribute from the JaasSecurityDomaincount : the IterationCount attribute from the JaasSecurityDomaindomain-password : the plaintext password that maps to the KeyStorePass  attribute from the JaasSecurityDomainpassword : the plaintext password that should be encrypted with the  JaasSecurityDomain password");
/*     */     }
/*     */ 
/* 100 */     byte[] salt = args[0].substring(0, 8).getBytes();
/* 101 */     int count = Integer.parseInt(args[1]);
/* 102 */     char[] password = args[2].toCharArray();
/* 103 */     byte[] passwordToEncode = args[3].getBytes("UTF-8");
/* 104 */     PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
/* 105 */     PBEKeySpec keySpec = new PBEKeySpec(password);
/* 106 */     SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
/* 107 */     SecretKey cipherKey = factory.generateSecret(keySpec);
/* 108 */     String encodedPassword = encode64(passwordToEncode, "PBEwithMD5andDES", cipherKey, cipherSpec);
/*     */ 
/* 110 */     System.err.println("Encoded password: " + encodedPassword);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.PBEUtils
 * JD-Core Version:    0.6.0
 */