/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityIdentity;
/*     */ import org.jboss.security.SubjectInfo;
/*     */ 
/*     */ public class JBossSecurityContextUtil extends SecurityContextUtil
/*     */ {
/*     */   public JBossSecurityContextUtil(SecurityContext sc)
/*     */   {
/*  53 */     this.securityContext = sc;
/*     */   }
/*     */ 
/*     */   public <T> T get(String key)
/*     */   {
/*  59 */     validateSecurityContext();
/*  60 */     if ("RunAsIdentity".equals(key)) {
/*  61 */       return this.securityContext.getOutgoingRunAs();
/*     */     }
/*  63 */     return this.securityContext.getData().get(key);
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */   {
/*  69 */     Principal p = getUserPrincipal();
/*  70 */     return p != null ? p.getName() : null;
/*     */   }
/*     */ 
/*     */   public Principal getUserPrincipal()
/*     */   {
/*  76 */     validateSecurityContext();
/*  77 */     Principal p = null;
/*  78 */     SubjectInfo subjectInfo = this.securityContext.getSubjectInfo();
/*  79 */     if (subjectInfo != null)
/*     */     {
/*  81 */       p = subjectInfo.getAuthenticationPrincipal();
/*     */     }
/*  83 */     return p;
/*     */   }
/*     */ 
/*     */   public Object getCredential()
/*     */   {
/*  88 */     validateSecurityContext();
/*  89 */     Object cred = null;
/*  90 */     SubjectInfo subjectInfo = this.securityContext.getSubjectInfo();
/*  91 */     if (subjectInfo != null)
/*     */     {
/*  93 */       cred = subjectInfo.getAuthenticationCredential();
/*     */     }
/*  95 */     return cred;
/*     */   }
/*     */ 
/*     */   public Subject getSubject()
/*     */   {
/* 100 */     validateSecurityContext();
/* 101 */     Subject s = null;
/* 102 */     SubjectInfo subjectInfo = this.securityContext.getSubjectInfo();
/* 103 */     if (subjectInfo != null)
/*     */     {
/* 105 */       s = subjectInfo.getAuthenticatedSubject();
/*     */     }
/* 107 */     return s;
/*     */   }
/*     */ 
/*     */   public <T> void set(String key, T obj)
/*     */   {
/* 113 */     validateSecurityContext();
/* 114 */     if (key == null)
/* 115 */       throw new IllegalArgumentException("Key is null");
/* 116 */     if (obj != null)
/*     */     {
/* 118 */       if (("RunAsIdentity".equals(key)) && (!(obj instanceof RunAsIdentity)))
/* 119 */         throw new IllegalArgumentException("Not RunAsIdentity:" + obj);
/* 120 */       if (("Roles".equals(key)) && (!(obj instanceof Group)))
/* 121 */         throw new IllegalArgumentException("Not Group:" + obj);
/*     */     }
/* 123 */     if ("RunAsIdentity".equals(key))
/* 124 */       setRunAsIdentity((RunAsIdentity)obj);
/*     */     else
/* 126 */       this.securityContext.getData().put(key, obj);
/*     */   }
/*     */ 
/*     */   public <T> T remove(String key)
/*     */   {
/* 132 */     if (key == null)
/* 133 */       throw new IllegalArgumentException("Key is null");
/* 134 */     Map contextMap = this.securityContext.getData();
/* 135 */     if ("RunAsIdentity".equals(key))
/*     */     {
/* 137 */       RunAs runAs = this.securityContext.getOutgoingRunAs();
/*     */ 
/* 139 */       this.securityContext.setOutgoingRunAs((RunAs)contextMap.get("CallerRunAsIdentity"));
/*     */ 
/* 142 */       contextMap.remove("CallerRunAsIdentity");
/* 143 */       return runAs;
/*     */     }
/* 145 */     return contextMap.remove(key);
/*     */   }
/*     */ 
/*     */   public <T> void setRoles(T roles)
/*     */   {
/* 151 */     validateSecurityContext();
/* 152 */     this.securityContext.getData().put("Roles", roles);
/*     */   }
/*     */ 
/*     */   public void setSecurityIdentity(SecurityIdentity sidentity)
/*     */   {
/* 159 */     createSubjectInfo(sidentity.getPrincipal(), sidentity.getCredential(), sidentity.getSubject());
/*     */ 
/* 161 */     this.securityContext.setOutgoingRunAs(sidentity.getOutgoingRunAs());
/* 162 */     this.securityContext.setIncomingRunAs(sidentity.getIncomingRunAs());
/*     */   }
/*     */ 
/*     */   public SecurityIdentity getSecurityIdentity()
/*     */   {
/* 168 */     return new SecurityIdentity(this.securityContext.getSubjectInfo(), this.securityContext.getOutgoingRunAs(), this.securityContext.getIncomingRunAs());
/*     */   }
/*     */ 
/*     */   private void setRunAsIdentity(RunAsIdentity rai)
/*     */   {
/* 176 */     Map contextMap = this.securityContext.getData();
/*     */ 
/* 179 */     RunAs currentRA = this.securityContext.getOutgoingRunAs();
/* 180 */     contextMap.put("CallerRunAsIdentity", currentRA);
/*     */ 
/* 182 */     this.securityContext.setOutgoingRunAs(rai);
/*     */   }
/*     */ 
/*     */   public <T> T getRoles()
/*     */   {
/* 189 */     validateSecurityContext();
/* 190 */     return this.securityContext.getData().get("Roles");
/*     */   }
/*     */ 
/*     */   private void validateSecurityContext()
/*     */   {
/* 196 */     if (this.securityContext == null)
/* 197 */       throw new IllegalStateException("SecurityContext is null: set it on the util");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.JBossSecurityContextUtil
 * JD-Core Version:    0.6.0
 */