/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.authorization.AuthorizationException;
/*     */ import org.jboss.security.authorization.EntitlementHolder;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.identity.Identity;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.CachePolicy;
/*     */ 
/*     */ public class AuthorizationManagerService extends ServiceMBeanSupport
/*     */   implements AuthorizationManagerServiceMBean
/*     */ {
/*  64 */   private static Logger log = Logger.getLogger(AuthorizationManagerService.class);
/*  65 */   private static String authorizationMgrClassName = "org.jboss.security.plugins.JBossAuthorizationManager";
/*  66 */   private static Class<?> authorizationMgrClass = JBossAuthorizationManager.class;
/*     */ 
/*  68 */   private static Hashtable<String, AuthorizationManager> authorizationManagersMap = new Hashtable();
/*     */ 
/*  72 */   private static String callbackHandlerClassName = "org.jboss.security.auth.callback.SecurityAssociationHandler";
/*  73 */   private static Class<?> callbackHandlerClass = SecurityAssociationHandler.class;
/*     */ 
/*     */   public void setAuthorizationManagerClassName(String className)
/*     */     throws ClassNotFoundException, ClassCastException
/*     */   {
/*  81 */     authorizationMgrClassName = className;
/*  82 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  83 */     authorizationMgrClass = loader.loadClass(authorizationMgrClassName);
/*  84 */     if (!AuthorizationManager.class.isAssignableFrom(authorizationMgrClass))
/*  85 */       throw new ClassCastException(authorizationMgrClass + " does not implement " + AuthorizationManager.class);
/*     */   }
/*     */ 
/*     */   public void setCallbackHandlerClassName(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/*  94 */     callbackHandlerClassName = className;
/*  95 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  96 */     callbackHandlerClass = loader.loadClass(callbackHandlerClassName);
/*     */   }
/*     */ 
/*     */   public String getAuthorizationManagerClassName()
/*     */   {
/* 104 */     return authorizationMgrClassName;
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(String roleName)
/*     */   {
/* 112 */     String str = "Use getAuthorizationManager method and then call doesUserHaveRole";
/* 113 */     throw new IllegalStateException(str);
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Principal principal, Set<Principal> roles)
/*     */   {
/* 121 */     String str = "Use getAuthorizationManager method and then call doesUserHaveRole";
/* 122 */     throw new IllegalStateException(str);
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 128 */     super.startService();
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 133 */     super.stopService();
/*     */   }
/*     */ 
/*     */   public Set getUserRoles(Principal principal)
/*     */   {
/* 142 */     String str = "Use getAuthorizationManager method and then call getUserRoles";
/* 143 */     throw new IllegalStateException(str);
/*     */   }
/*     */ 
/*     */   public Principal getPrincipal(Principal principal)
/*     */   {
/* 151 */     String str = "Use getAuthorizationManager method and then call getPrincipal";
/* 152 */     throw new IllegalStateException(str);
/*     */   }
/*     */ 
/*     */   public AuthorizationManager getAuthorizationManager(String securityDomain)
/*     */   {
/* 160 */     AuthorizationManager amanager = (AuthorizationManager)authorizationManagersMap.get(securityDomain);
/* 161 */     if (amanager == null)
/*     */     {
/* 164 */       amanager = newAuthorizationManager(securityDomain);
/* 165 */       authorizationManagersMap.put(securityDomain, amanager);
/* 166 */       log.debug("Added " + securityDomain + ", " + amanager + " to map");
/*     */       try
/*     */       {
/* 171 */         Context ctx = new InitialContext();
/*     */ 
/* 173 */         SecurityDomainContext sdc = (SecurityDomainContext)ctx.lookup("java:jaas/security/domainContext");
/* 174 */         sdc.setAuthorizationManager(amanager);
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 178 */         if (log.isTraceEnabled())
/* 179 */           log.trace("Error in naming", e);
/* 180 */         log.error("Error in getAuthorizationManager", e);
/*     */       }
/*     */     }
/* 183 */     return amanager;
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */   {
/* 191 */     String str = "Use getAuthorizationManager method and then call authorize";
/* 192 */     throw new IllegalStateException(str);
/*     */   }
/*     */ 
/*     */   static AuthorizationManager newAuthorizationManager(String securityDomain)
/*     */   {
/* 204 */     AuthorizationManager securityMgr = null;
/*     */     try
/*     */     {
/* 208 */       Class[] parameterTypes = { String.class, CallbackHandler.class };
/* 209 */       Constructor ctor = authorizationMgrClass.getConstructor(parameterTypes);
/* 210 */       CallbackHandler handler = (CallbackHandler)callbackHandlerClass.newInstance();
/* 211 */       Object[] args = { securityDomain, handler };
/* 212 */       securityMgr = (AuthorizationManager)ctor.newInstance(args);
/* 213 */       log.debug("Created AuthorizationManager=" + securityMgr);
/*     */ 
/* 215 */       CachePolicy cachePolicy = JaasSecurityManagerService.lookupCachePolicy(securityDomain);
/* 216 */       log.debug("Found Cache Policy=" + cachePolicy);
/*     */ 
/* 218 */       setSecurityDomainCache(securityMgr, cachePolicy);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 222 */       String msg = "Failed to create authz mgr('" + securityDomain + "'), authorizationMgrClass=" + authorizationMgrClass;
/*     */ 
/* 224 */       log.error(msg, e2);
/*     */     }
/* 226 */     return securityMgr;
/*     */   }
/*     */ 
/*     */   private static void setSecurityDomainCache(AuthorizationManager securityMgr, CachePolicy cachePolicy)
/*     */   {
/*     */     try
/*     */     {
/* 239 */       Class[] setCachePolicyTypes = { CachePolicy.class };
/* 240 */       Method m = authorizationMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
/* 241 */       Object[] setCachePolicyArgs = { cachePolicy };
/* 242 */       m.invoke(securityMgr, setCachePolicyArgs);
/* 243 */       log.debug("setCachePolicy, c=" + setCachePolicyArgs[0]);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 247 */       if (log.isTraceEnabled())
/* 248 */         log.trace("optional setCachePolicy failed:" + e2.getLocalizedMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Group getTargetRoles(Principal targetPrincipal, Map<String, Object> contextMap)
/*     */   {
/* 254 */     throw new RuntimeException("Not implemented");
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 259 */     throw new RuntimeException("Call the method on the authorization manager");
/*     */   }
/*     */ 
/*     */   public EntitlementHolder<?> entitlements(Resource resource, Identity identity)
/*     */     throws AuthorizationException
/*     */   {
/* 265 */     throw new RuntimeException("Call the method on the authorization manager");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.AuthorizationManagerService
 * JD-Core Version:    0.6.0
 */