/*    */ package org.jboss.security.mapping.providers.principal;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.security.cert.X509Certificate;
/*    */ import java.util.Map;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.auth.certs.SubjectDNMapping;
/*    */ import org.jboss.security.mapping.MappingProvider;
/*    */ import org.jboss.security.mapping.MappingResult;
/*    */ 
/*    */ public class SubjectDNMapper
/*    */   implements MappingProvider<Principal>
/*    */ {
/* 48 */   private static final Logger log = Logger.getLogger(SubjectDNMapper.class);
/* 49 */   private Map options = null;
/*    */   private MappingResult<Principal> result;
/*    */ 
/*    */   public void init(Map opt)
/*    */   {
/* 54 */     this.options = opt;
/*    */   }
/*    */ 
/*    */   public void setMappingResult(MappingResult res)
/*    */   {
/* 59 */     this.result = res;
/*    */   }
/*    */ 
/*    */   public void performMapping(Map contextMap, Principal principal)
/*    */   {
/* 64 */     if (contextMap == null) {
/* 65 */       throw new IllegalArgumentException("ContextMap is null");
/*    */     }
/* 67 */     X509Certificate[] certs = (X509Certificate[])(X509Certificate[])contextMap.get("X509");
/* 68 */     if (certs != null)
/*    */     {
/* 70 */       SubjectDNMapping sdn = new SubjectDNMapping();
/* 71 */       principal = sdn.toPrinicipal(certs);
/* 72 */       if (log.isTraceEnabled()) {
/* 73 */         log.trace("Mapped to Principal:" + principal);
/*    */       }
/*    */     }
/* 76 */     this.result.setMappedObject(principal);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.principal.SubjectDNMapper
 * JD-Core Version:    0.6.0
 */