/*     */ package org.jboss.security.jce;
/*     */ 
/*     */ import java.security.Provider;
/*     */ import java.security.Security;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class JCEProviderService extends ServiceMBeanSupport
/*     */   implements JCEProviderServiceMBean
/*     */ {
/*  59 */   private ArrayList addedProviders = new ArrayList();
/*     */   private Element providers;
/*     */ 
/*     */   public void setJceProviders(Element element)
/*     */   {
/*  64 */     this.providers = element;
/*  65 */     if (getState() != 7)
/*     */     {
/*  67 */       synchronized (JCEProviderService.class)
/*     */       {
/*  69 */         removeProviders();
/*  70 */         loadProviders();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Element getJceProviders()
/*     */   {
/*  77 */     return this.providers;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/*  83 */     synchronized (JCEProviderService.class)
/*     */     {
/*  85 */       loadProviders();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */   {
/*  92 */     synchronized (JCEProviderService.class)
/*     */     {
/*  94 */       removeProviders();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void loadProviders()
/*     */   {
/* 100 */     int n = 0;
/* 101 */     if (this.providers != null)
/*     */     {
/* 103 */       this.addedProviders = new ArrayList();
/* 104 */       NodeList reqdProviders = this.providers.getElementsByTagName("provider");
/* 105 */       n = reqdProviders.getLength();
/*     */ 
/* 108 */       for (int i = 0; i < n; i++)
/*     */       {
/* 111 */         Node reqdProvider = reqdProviders.item(i);
/*     */ 
/* 115 */         int requestedPosition = 0;
/*     */ 
/* 117 */         if (1 == reqdProvider.getNodeType())
/*     */         {
/* 119 */           Element prov = (Element)reqdProvider;
/*     */           String providerClass;
/* 120 */           if (prov.hasAttribute("class"))
/*     */           {
/* 122 */             providerClass = prov.getAttribute("class");
/*     */           }
/*     */           else
/*     */           {
/* 126 */             this.log.warn("A provider element must, at the very least, have a class attribute: " + prov);
/* 127 */             continue;
/*     */           }
/*     */           Provider provider;
/*     */           try {
/* 132 */             provider = (Provider)Class.forName(providerClass).newInstance();
/*     */           }
/*     */           catch (InstantiationException e1)
/*     */           {
/* 136 */             this.log.warn("Unable to instantiate an instance of the JCE Provider class " + providerClass, e1);
/* 137 */             continue;
/*     */           }
/*     */           catch (IllegalAccessException e1)
/*     */           {
/* 141 */             this.log.warn("No permission to access the JCE Provider class " + providerClass, e1);
/* 142 */             continue;
/*     */           }
/*     */           catch (ClassNotFoundException e1)
/*     */           {
/* 146 */             this.log.warn("Could not find the JCE Provider class " + providerClass, e1);
/* 147 */             continue;
/*     */           }
/*     */           catch (ClassCastException e1)
/*     */           {
/*     */             String providerClass;
/* 151 */             this.log.warn("The Class " + providerClass + " is not a java.security.Provider");
/* 152 */             continue;
/*     */           }
/*     */ 
/* 155 */           String providerName = provider.getName();
/*     */ 
/* 157 */           if (prov.hasAttribute("position"))
/*     */           {
/*     */             try
/*     */             {
/* 161 */               requestedPosition = Integer.parseInt(prov.getAttribute("position"));
/*     */             }
/*     */             catch (NumberFormatException e)
/*     */             {
/* 165 */               this.log.warn("the position '" + prov.getAttribute("position") + "' is not a valid number. This provider has to go to the end of the line. " + prov);
/*     */             }
/*     */           }
/*     */           int pos;
/*     */           int pos;
/* 171 */           if (requestedPosition < 1)
/*     */           {
/* 173 */             pos = Security.addProvider(provider);
/*     */           }
/*     */           else
/*     */           {
/* 177 */             pos = Security.insertProviderAt(provider, requestedPosition);
/*     */           }
/*     */ 
/* 180 */           if (pos == -1)
/*     */           {
/* 182 */             int exPos = Arrays.asList(Security.getProviders()).indexOf(provider);
/* 183 */             this.log.info("The provider " + providerName + " already exists at position " + exPos);
/*     */           }
/* 185 */           else if ((requestedPosition >= 1) && (pos != requestedPosition))
/*     */           {
/* 187 */             this.log.info("The position " + requestedPosition + " was requested for Provider " + providerName + " but it was added at position " + pos);
/*     */ 
/* 189 */             this.addedProviders.add(providerName);
/*     */           }
/*     */           else
/*     */           {
/* 193 */             this.log.info("The Provider " + providerName + " was added at position " + pos);
/* 194 */             this.addedProviders.add(providerName);
/*     */           }
/*     */ 
/*     */         }
/* 199 */         else if (this.log.isDebugEnabled()) {
/* 200 */           this.log.debug("Ignoring node" + reqdProvider);
/*     */         }
/*     */       }
/*     */ 
/* 204 */       if (this.addedProviders.size() == 1)
/* 205 */         this.log.info(this.addedProviders.size() + " JCE Provider was actually loaded.");
/*     */       else {
/* 207 */         this.log.info(this.addedProviders.size() + " JCE Providers were actually loaded.");
/*     */       }
/*     */     }
/* 210 */     if (n < 1)
/* 211 */       this.log.info("No JCE Providers were requested.");
/*     */   }
/*     */ 
/*     */   private void removeProviders() {
/* 215 */     for (Iterator iter = this.addedProviders.iterator(); iter.hasNext(); )
/*     */     {
/* 217 */       String providerName = (String)iter.next();
/*     */       try
/*     */       {
/* 220 */         Security.removeProvider(providerName);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 224 */         this.log.warn("Failed to remove Provider " + providerName);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jce.JCEProviderService
 * JD-Core Version:    0.6.0
 */