/*    */ package org.jboss.security.integration.ejb;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.Principal;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.util.Map;
/*    */ import org.jboss.security.SecurityContext;
/*    */ import org.jboss.security.SecurityContextUtil;
/*    */ import org.jboss.security.plugins.SecurityContextAssociation;
/*    */ 
/*    */ public class SecurityActions
/*    */ {
/*    */   public static Principal getCallerPrincipal(SecurityContext securityContext)
/*    */   {
/* 44 */     return (Principal)AccessController.doPrivileged(new PrivilegedAction(securityContext)
/*    */     {
/*    */       public Object run()
/*    */       {
/* 49 */         Principal caller = null;
/*    */ 
/* 51 */         if (this.val$securityContext != null)
/*    */         {
/* 53 */           caller = this.val$securityContext.getIncomingRunAs();
/*    */ 
/* 55 */           if (caller == null)
/* 56 */             caller = this.val$securityContext.getUtil().getUserPrincipal();
/*    */         }
/* 58 */         return caller;
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   public static SecurityContext getSecurityContext() {
/* 65 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*    */     {
/*    */       public Object run()
/*    */       {
/* 70 */         return SecurityContextAssociation.getSecurityContext();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static Exception getContextException() {
/* 77 */     return (Exception)AccessController.doPrivileged(new PrivilegedAction() {
/*    */       static final String EX_KEY = "org.jboss.security.exception";
/*    */ 
/*    */       public Object run() {
/* 82 */         SecurityContext sc = SecurityActions.getSecurityContext();
/* 83 */         return sc.getData().get("org.jboss.security.exception");
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.ejb.SecurityActions
 * JD-Core Version:    0.6.0
 */