/*     */ package org.jboss.security.integration.ejb;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SubjectInfo;
/*     */ import org.jboss.security.identitytrust.IdentityTrustException;
/*     */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*     */ import org.jboss.security.identitytrust.IdentityTrustManager.TrustDecision;
/*     */ 
/*     */ public class EJBAuthenticationHelper extends SecurityHelper
/*     */ {
/*     */   public EJBAuthenticationHelper(SecurityContext sc)
/*     */   {
/*  47 */     super(sc);
/*     */   }
/*     */ 
/*     */   public boolean isTrusted() throws IdentityTrustException
/*     */   {
/*  52 */     IdentityTrustManager.TrustDecision td = IdentityTrustManager.TrustDecision.NotApplicable;
/*  53 */     IdentityTrustManager itm = this.securityContext.getIdentityTrustManager();
/*  54 */     if (itm != null)
/*     */     {
/*  56 */       td = itm.isTrusted(this.securityContext);
/*  57 */       if (td == IdentityTrustManager.TrustDecision.Deny)
/*  58 */         throw new IdentityTrustException("Caller denied by identity trust framework");
/*     */     }
/*  60 */     return td == IdentityTrustManager.TrustDecision.Permit;
/*     */   }
/*     */ 
/*     */   public boolean isValid(Subject subject, String methodName)
/*     */   {
/*  71 */     Principal p = this.securityContext.getUtil().getUserPrincipal();
/*  72 */     Object cred = this.securityContext.getUtil().getCredential();
/*     */ 
/*  74 */     Map cMap = getContextMap(p, methodName);
/*     */ 
/*  76 */     boolean auth = this.securityContext.getAuthenticationManager().isValid(p, cred, subject);
/*  77 */     if (!auth)
/*     */     {
/*  80 */       Exception ex = SecurityActions.getContextException();
/*  81 */       audit("Error", cMap, ex);
/*  82 */       if (ex == null)
/*     */       {
/*  84 */         audit("Failure", cMap, null);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  89 */       audit("Success", cMap, null);
/*     */     }
/*  91 */     return auth;
/*     */   }
/*     */ 
/*     */   public void pushSubjectContext(Subject subject)
/*     */   {
/* 100 */     this.securityContext.getSubjectInfo().setAuthenticatedSubject(subject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.ejb.EJBAuthenticationHelper
 * JD-Core Version:    0.6.0
 */