/*     */ package org.jboss.security.integration;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameClassPair;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.OperationNotSupportedException;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.security.plugins.SecurityDomainContext;
/*     */ 
/*     */ public class SecurityDomainObjectFactory
/*     */   implements InvocationHandler, ObjectFactory
/*     */ {
/*     */   private JNDIBasedSecurityManagement securityManagement;
/*     */ 
/*     */   public SecurityDomainObjectFactory()
/*     */   {
/*  55 */     this.securityManagement = new JNDIBasedSecurityManagement();
/*     */   }
/*     */ 
/*     */   public void setSecurityManagement(JNDIBasedSecurityManagement sm) {
/*  59 */     this.securityManagement = sm;
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment)
/*     */     throws Exception
/*     */   {
/*  70 */     ClassLoader loader = SecurityActions.getContextClassLoader();
/*  71 */     Class[] interfaces = { Context.class };
/*  72 */     Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, this);
/*  73 */     return ctx;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object obj, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  83 */     Context ctx = new InitialContext();
/*  84 */     NameParser parser = ctx.getNameParser("");
/*  85 */     String securityDomain = null;
/*  86 */     Name name = null;
/*     */ 
/*  89 */     String methodName = method.getName();
/*  90 */     if (methodName.equals("toString") == true) {
/*  91 */       return "java:/jaas Context proxy";
/*     */     }
/*  93 */     if (methodName.equals("list") == true) {
/*  94 */       return new DomainEnumeration(JNDIBasedSecurityManagement.securityMgrMap.keys(), JNDIBasedSecurityManagement.securityMgrMap);
/*     */     }
/*     */ 
/*  97 */     if ((methodName.equals("bind")) || (methodName.equals("rebind")))
/*     */     {
/*  99 */       if ((args[0] instanceof String))
/* 100 */         name = parser.parse((String)args[0]);
/*     */       else
/* 102 */         name = (Name)args[0];
/* 103 */       securityDomain = name.get(0);
/* 104 */       SecurityDomainContext val = (SecurityDomainContext)args[1];
/* 105 */       JNDIBasedSecurityManagement.securityMgrMap.put(securityDomain, val);
/* 106 */       return obj;
/*     */     }
/* 108 */     if (!methodName.equals("lookup"))
/* 109 */       throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
/* 110 */     if ((args[0] instanceof String))
/* 111 */       name = parser.parse((String)args[0]);
/*     */     else
/* 113 */       name = (Name)args[0];
/* 114 */     securityDomain = name.get(0);
/* 115 */     SecurityDomainContext securityDomainCtx = lookupSecurityDomain(securityDomain);
/*     */ 
/* 117 */     Object binding = securityDomainCtx.getSecurityManager();
/*     */ 
/* 119 */     if (name.size() == 2)
/*     */     {
/* 121 */       String request = name.get(1);
/* 122 */       binding = securityDomainCtx.lookup(request);
/*     */     }
/* 124 */     return binding;
/*     */   }
/*     */ 
/*     */   private SecurityDomainContext lookupSecurityDomain(String securityDomain)
/*     */     throws Exception
/*     */   {
/* 130 */     SecurityDomainContext sdc = (SecurityDomainContext)JNDIBasedSecurityManagement.securityMgrMap.get(securityDomain);
/* 131 */     if (sdc == null)
/*     */     {
/* 133 */       sdc = this.securityManagement.createSecurityDomainContext(securityDomain);
/* 134 */       JNDIBasedSecurityManagement.securityMgrMap.put(securityDomain, sdc);
/*     */     }
/* 136 */     return sdc;
/*     */   }
/*     */   class DomainEnumeration implements NamingEnumeration<NameClassPair> {
/*     */     Enumeration<String> domains;
/*     */     Map<String, SecurityDomainContext> ctxMap;
/*     */ 
/*     */     DomainEnumeration(Map<String, SecurityDomainContext> domains) {
/* 145 */       this.domains = domains;
/* 146 */       this.ctxMap = ctxMap;
/*     */     }
/*     */ 
/*     */     public void close()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean hasMoreElements() {
/* 154 */       return this.domains.hasMoreElements();
/*     */     }
/*     */ 
/*     */     public boolean hasMore() {
/* 158 */       return this.domains.hasMoreElements();
/*     */     }
/*     */ 
/*     */     public NameClassPair next() {
/* 162 */       String name = (String)this.domains.nextElement();
/* 163 */       Object value = this.ctxMap.get(name);
/* 164 */       String className = value.getClass().getName();
/* 165 */       NameClassPair pair = new NameClassPair(name, className);
/* 166 */       return pair;
/*     */     }
/*     */ 
/*     */     public NameClassPair nextElement() {
/* 170 */       return next();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.SecurityDomainObjectFactory
 * JD-Core Version:    0.6.0
 */