/*    */ package org.jboss.security.config;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import javax.security.auth.AuthPermission;
/*    */ 
/*    */ public abstract class BaseSecurityInfo<T>
/*    */ {
/* 40 */   public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
/* 41 */   public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
/*    */   protected String name;
/* 43 */   protected ArrayList<T> moduleEntries = new ArrayList();
/*    */ 
/*    */   public BaseSecurityInfo()
/*    */   {
/*    */   }
/*    */ 
/*    */   public BaseSecurityInfo(String name)
/*    */   {
/* 51 */     this.name = name;
/*    */   }
/*    */ 
/*    */   public void add(T ame)
/*    */   {
/* 56 */     this.moduleEntries.add(ame);
/*    */   }
/*    */ 
/*    */   public void add(List moduleEntries)
/*    */   {
/* 61 */     SecurityManager sm = System.getSecurityManager();
/* 62 */     if (sm != null)
/* 63 */       sm.checkPermission(SET_CONFIG_ENTRY_PERM);
/* 64 */     this.moduleEntries.addAll(moduleEntries);
/*    */   }
/*    */ 
/*    */   public List<T> getModuleEntries()
/*    */   {
/* 69 */     SecurityManager sm = System.getSecurityManager();
/* 70 */     if (sm != null)
/* 71 */       sm.checkPermission(GET_CONFIG_ENTRY_PERM);
/* 72 */     return this.moduleEntries;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 77 */     return this.name;
/*    */   }
/*    */ 
/*    */   public void setName(String name)
/*    */   {
/* 82 */     this.name = name;
/*    */   }
/*    */ 
/*    */   protected abstract BaseSecurityInfo<T> create(String paramString);
/*    */ 
/*    */   public BaseSecurityInfo<T> merge(BaseSecurityInfo<T> bi) {
/* 89 */     if (bi == null)
/* 90 */       return this;
/* 91 */     List al = bi.getModuleEntries();
/* 92 */     al.addAll(this.moduleEntries);
/* 93 */     BaseSecurityInfo mergedBAI = create(this.name);
/* 94 */     mergedBAI.add(al);
/* 95 */     return mergedBAI;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.config.BaseSecurityInfo
 * JD-Core Version:    0.6.0
 */