/*     */ package org.jboss.security.authorization.modules.web;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.Policy;
/*     */ import java.security.Principal;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.WebResourcePermission;
/*     */ import javax.security.jacc.WebRoleRefPermission;
/*     */ import javax.security.jacc.WebUserDataPermission;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
/*     */ import org.jboss.security.authorization.resources.WebResource;
/*     */ 
/*     */ public class WebJACCPolicyModuleDelegate extends AuthorizationModuleDelegate
/*     */ {
/*  60 */   private Policy policy = Policy.getPolicy();
/*     */   private AuthorizationManager authorizationManager;
/*  62 */   private HttpServletRequest request = null;
/*  63 */   private CodeSource webCS = null;
/*     */ 
/*  65 */   private String canonicalRequestURI = null;
/*     */ 
/*     */   public WebJACCPolicyModuleDelegate()
/*     */   {
/*  69 */     log = Logger.getLogger(WebJACCPolicyModuleDelegate.class);
/*  70 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */   {
/*  78 */     if (!(resource instanceof WebResource)) {
/*  79 */       throw new IllegalArgumentException("resource is not a WebResource");
/*     */     }
/*  81 */     WebResource webResource = (WebResource)resource;
/*     */ 
/*  84 */     Map map = resource.getMap();
/*  85 */     if (map == null) {
/*  86 */       throw new IllegalStateException("Map from the Resource is null");
/*     */     }
/*     */ 
/*  89 */     this.authorizationManager = ((AuthorizationManager)map.get("authorizationManager"));
/*  90 */     if (this.authorizationManager == null) {
/*  91 */       throw new IllegalStateException("Authorization Manager is null");
/*     */     }
/*     */ 
/*  94 */     this.request = ((HttpServletRequest)webResource.getServletRequest());
/*     */ 
/*  96 */     this.webCS = webResource.getCodeSource();
/*  97 */     this.canonicalRequestURI = webResource.getCanonicalRequestURI();
/*     */ 
/* 100 */     Subject callerSubject = webResource.getCallerSubject();
/*     */ 
/* 102 */     String roleName = (String)map.get("roleName");
/* 103 */     Principal principal = (Principal)map.get("hasRole.Principal");
/* 104 */     Set roles = (Set)map.get("principal.roles");
/* 105 */     String servletName = (String)map.get("servletName");
/* 106 */     Boolean resourceCheck = checkBooleanValue((Boolean)map.get("resourcePermissionCheck"));
/* 107 */     Boolean userDataCheck = checkBooleanValue((Boolean)map.get("userDataPermissionCheck"));
/* 108 */     Boolean roleRefCheck = checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
/*     */ 
/* 110 */     validatePermissionChecks(resourceCheck, userDataCheck, roleRefCheck);
/*     */ 
/* 112 */     boolean decision = false;
/*     */     try
/*     */     {
/* 116 */       if (resourceCheck.booleanValue()) {
/* 117 */         decision = hasResourcePermission(callerSubject);
/*     */       }
/* 119 */       else if (userDataCheck.booleanValue()) {
/* 120 */         decision = hasUserDataPermission();
/*     */       }
/* 122 */       else if (roleRefCheck.booleanValue()) {
/* 123 */         decision = hasRole(principal, roleName, roles, servletName);
/*     */       }
/* 125 */       else if (this.trace)
/* 126 */         log.trace("Check is not for resourcePerm, userDataPerm or roleRefPerm.");
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 130 */       if (this.trace)
/* 131 */         log.trace("IOException:", ioe);
/*     */     }
/* 133 */     return decision ? 1 : -1;
/*     */   }
/*     */ 
/*     */   public void setPolicyRegistrationManager(PolicyRegistration authzM)
/*     */   {
/* 141 */     this.policyRegistration = authzM;
/*     */   }
/*     */ 
/*     */   private boolean checkSecurityAssociation(Permission perm, Principal requestPrincpal, Subject caller)
/*     */   {
/* 161 */     Principal[] principals = null;
/*     */ 
/* 165 */     if (this.authorizationManager != null)
/*     */     {
/* 167 */       Set roleset = this.authorizationManager.getUserRoles(requestPrincpal);
/* 168 */       principals = new Principal[roleset.size()];
/* 169 */       roleset.toArray(principals);
/*     */     }
/*     */ 
/* 172 */     return checkSecurityAssociation(perm, principals);
/*     */   }
/*     */ 
/*     */   private boolean checkSecurityAssociation(Permission perm, Principal[] principals)
/*     */   {
/* 187 */     ProtectionDomain pd = new ProtectionDomain(this.webCS, null, null, principals);
/* 188 */     boolean allowed = this.policy.implies(pd, perm);
/* 189 */     if (this.trace)
/*     */     {
/* 191 */       String msg = (allowed ? "Allowed: " : "Denied: ") + perm;
/* 192 */       log.trace(msg);
/*     */     }
/* 194 */     return allowed;
/*     */   }
/*     */ 
/*     */   private Boolean checkBooleanValue(Boolean bool)
/*     */   {
/* 204 */     if (bool == null)
/* 205 */       return Boolean.FALSE;
/* 206 */     return bool;
/*     */   }
/*     */ 
/*     */   private boolean hasResourcePermission(Subject caller)
/*     */     throws IOException
/*     */   {
/* 223 */     Principal requestPrincipal = this.request.getUserPrincipal();
/* 224 */     WebResourcePermission perm = new WebResourcePermission(this.canonicalRequestURI, this.request.getMethod());
/*     */ 
/* 226 */     boolean allowed = checkSecurityAssociation(perm, requestPrincipal, caller);
/* 227 */     if (this.trace)
/* 228 */       log.trace("hasResourcePermission, perm=" + perm + ", allowed=" + allowed);
/* 229 */     return allowed;
/*     */   }
/*     */ 
/*     */   private boolean hasRole(Principal principal, String roleName, Set<Principal> roles, String servletName)
/*     */   {
/* 242 */     WebRoleRefPermission perm = new WebRoleRefPermission(servletName, roleName);
/* 243 */     Principal[] principals = { principal };
/* 244 */     if (roles != null)
/*     */     {
/* 246 */       principals = new Principal[roles.size()];
/* 247 */       roles.toArray(principals);
/*     */     }
/* 249 */     boolean allowed = checkSecurityAssociation(perm, principals);
/* 250 */     if (this.trace)
/* 251 */       log.trace("hasRole, perm=" + perm + ", allowed=" + allowed);
/* 252 */     return allowed;
/*     */   }
/*     */ 
/*     */   private boolean hasUserDataPermission()
/*     */     throws IOException
/*     */   {
/* 268 */     WebUserDataPermission perm = new WebUserDataPermission(this.canonicalRequestURI, this.request.getMethod());
/*     */ 
/* 270 */     if (this.trace)
/* 271 */       log.trace("hasUserDataPermission, p=" + perm);
/* 272 */     boolean ok = false;
/*     */     try
/*     */     {
/* 275 */       Principal[] principals = null;
/* 276 */       ok = checkSecurityAssociation(perm, principals);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 280 */       if (this.trace)
/* 281 */         log.trace("Failed to checkSecurityAssociation", e);
/*     */     }
/* 283 */     return ok;
/*     */   }
/*     */ 
/*     */   private void validatePermissionChecks(Boolean resourceCheck, Boolean userDataCheck, Boolean roleRefCheck)
/*     */   {
/* 296 */     if (this.trace) {
/* 297 */       log.trace("resourceCheck=" + resourceCheck + " : userDataCheck=" + userDataCheck + " : roleRefCheck=" + roleRefCheck);
/*     */     }
/* 299 */     if (((resourceCheck == Boolean.TRUE) && (userDataCheck == Boolean.TRUE) && (roleRefCheck == Boolean.TRUE)) || ((resourceCheck == Boolean.TRUE) && (userDataCheck == Boolean.TRUE)) || ((userDataCheck == Boolean.TRUE) && (roleRefCheck == Boolean.TRUE)))
/*     */     {
/* 302 */       throw new IllegalStateException("Permission checks must be different");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.web.WebJACCPolicyModuleDelegate
 * JD-Core Version:    0.6.0
 */