/*     */ package org.jboss.security.authorization.modules.ejb;
/*     */ 
/*     */ import com.sun.xacml.Policy;
/*     */ import com.sun.xacml.ctx.RequestCtx;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
/*     */ import org.jboss.security.authorization.resources.EJBResource;
/*     */ import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;
/*     */ 
/*     */ public class EJBXACMLPolicyModuleDelegate extends AuthorizationModuleDelegate
/*     */ {
/*  53 */   private String ejbName = null;
/*  54 */   private Method ejbMethod = null;
/*  55 */   private Principal principal = null;
/*     */ 
/*     */   public EJBXACMLPolicyModuleDelegate()
/*     */   {
/*  59 */     log = Logger.getLogger(getClass());
/*  60 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */   {
/*  68 */     if (!(resource instanceof EJBResource)) {
/*  69 */       throw new IllegalArgumentException("resource is not an EJBResource");
/*     */     }
/*  71 */     EJBResource ejbResource = (EJBResource)resource;
/*     */ 
/*  74 */     Map map = resource.getMap();
/*  75 */     if (map == null) {
/*  76 */       throw new IllegalStateException("Map from the Resource is null");
/*     */     }
/*  78 */     AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
/*  79 */     if (am == null)
/*  80 */       throw new IllegalStateException("Authorization Manager is null");
/*  81 */     if ((am instanceof PolicyRegistration)) {
/*  82 */       this.policyRegistration = ((PolicyRegistration)am);
/*     */     }
/*     */ 
/*  88 */     this.ejbName = ejbResource.getEjbName();
/*  89 */     this.ejbMethod = ejbResource.getEjbMethod();
/*  90 */     this.principal = ejbResource.getPrincipal();
/*     */ 
/*  92 */     Boolean roleRefCheck = checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
/*  93 */     if (roleRefCheck.booleanValue()) {
/*  94 */       throw new IllegalStateException("SECURIY-50:Role Ref checks not implemented");
/*     */     }
/*  96 */     return process(am);
/*     */   }
/*     */ 
/*     */   private int process(AuthorizationManager am)
/*     */   {
/* 108 */     int result = -1;
/* 109 */     EJBXACMLUtil util = new EJBXACMLUtil();
/*     */     try
/*     */     {
/* 112 */       RequestCtx requestCtx = util.createXACMLRequest(this.ejbName, this.ejbMethod.getName(), this.principal, am.getUserRoles(this.principal));
/*     */ 
/* 115 */       String contextID = PolicyContext.getContextID();
/* 116 */       if (contextID == null)
/* 117 */         throw new IllegalStateException("Context ID is null");
/* 118 */       Policy policy = (Policy)this.policyRegistration.getPolicy(contextID, null);
/* 119 */       if (policy == null)
/*     */       {
/* 121 */         if (this.trace)
/* 122 */           log.trace("Policy obtained is null for contextID:" + contextID);
/* 123 */         throw new IllegalStateException("Missing xacml policy for contextid:" + contextID);
/*     */       }
/* 125 */       result = JBossXACMLUtil.checkXACMLAuthorization(requestCtx, policy);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 129 */       if (this.trace)
/* 130 */         log.trace("Exception in processing:", e);
/* 131 */       result = -1;
/*     */     }
/* 133 */     return result;
/*     */   }
/*     */ 
/*     */   private Boolean checkBooleanValue(Boolean bool)
/*     */   {
/* 143 */     if (bool == null)
/* 144 */       return Boolean.FALSE;
/* 145 */     return bool;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.ejb.EJBXACMLPolicyModuleDelegate
 * JD-Core Version:    0.6.0
 */