/*     */ package org.jboss.security.authorization.config;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.audit.config.AuditProviderEntry;
/*     */ import org.jboss.security.auth.login.LoginConfigObjectModelFactory;
/*     */ import org.jboss.security.auth.login.ModuleOption;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.AuditInfo;
/*     */ import org.jboss.security.config.AuthorizationInfo;
/*     */ import org.jboss.security.config.ControlFlag;
/*     */ import org.jboss.security.config.IdentityTrustInfo;
/*     */ import org.jboss.security.config.MappingInfo;
/*     */ import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
/*     */ import org.jboss.security.mapping.config.MappingModuleEntry;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class SecurityConfigObjectModelFactory extends LoginConfigObjectModelFactory
/*     */ {
/*  52 */   private static Logger log = Logger.getLogger(SecurityConfigObjectModelFactory.class);
/*  53 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public Object newChild(ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/*  58 */     Object child = super.newChild(aPolicy, navigator, namespaceUri, localName, attrs);
/*     */ 
/*  60 */     if ((child == null) && ("authorization".equals(localName)))
/*     */     {
/*  62 */       child = new AuthorizationInfo(aPolicy.getName());
/*     */     }
/*  65 */     else if ((child == null) && ("rolemapping".equals(localName)))
/*     */     {
/*  67 */       MappingInfo mi = new MappingInfo();
/*  68 */       mi.setName(aPolicy.getName());
/*  69 */       child = mi;
/*     */     }
/*  72 */     else if ((child == null) && ("audit".equals(localName)))
/*     */     {
/*  74 */       AuditInfo ai = new AuditInfo(aPolicy.getName());
/*  75 */       child = ai;
/*     */     }
/*  78 */     else if ((child == null) && ("identity-trust".equals(localName)))
/*     */     {
/*  80 */       IdentityTrustInfo ai = new IdentityTrustInfo(aPolicy.getName());
/*  81 */       child = ai;
/*     */     }
/*  83 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(AuthorizationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/*  89 */     Object child = null;
/*  90 */     if (this.trace)
/*  91 */       log.trace("newChild.AuthorizationInfo, localName: " + localName);
/*  92 */     if ("policy-module".equals(localName))
/*     */     {
/*  94 */       String code = attrs.getValue("code");
/*  95 */       code = StringPropertyReplacer.replaceProperties(code.trim());
/*  96 */       String flag = attrs.getValue("flag");
/*  97 */       if (flag != null)
/*  98 */         flag = StringPropertyReplacer.replaceProperties(flag.trim());
/*  99 */       if (flag == null)
/* 100 */         flag = "REQUIRED";
/*     */       else
/* 102 */         flag = flag.toUpperCase();
/* 103 */       AuthorizationModuleEntry entry = new AuthorizationModuleEntry(code);
/* 104 */       if ("REQUIRED".equals(flag)) {
/* 105 */         entry.setControlFlag(ControlFlag.REQUIRED);
/*     */       }
/* 107 */       else if ("REQUISITE".equals(flag)) {
/* 108 */         entry.setControlFlag(ControlFlag.REQUISITE);
/*     */       }
/* 110 */       else if ("SUFFICIENT".equals(flag))
/* 111 */         entry.setControlFlag(ControlFlag.SUFFICIENT);
/*     */       else
/* 113 */         entry.setControlFlag(ControlFlag.OPTIONAL);
/* 114 */       child = entry;
/* 115 */       if (this.trace) {
/* 116 */         log.trace("newChild.AuthorizationInfo, policy-module code: " + code);
/*     */       }
/*     */     }
/* 119 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 125 */     Object child = null;
/* 126 */     if (this.trace)
/* 127 */       log.trace("newChild.AppConfigurationEntryHolder, localName: " + localName);
/* 128 */     if ("module-option".equals(localName))
/*     */     {
/* 130 */       String name = attrs.getValue("name");
/* 131 */       child = new ModuleOption(name);
/* 132 */       if (this.trace) {
/* 133 */         log.trace("newChild.AuthModuleEntry, module-option name: " + name);
/*     */       }
/*     */     }
/* 136 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationPolicy aPolicy, AuthorizationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 142 */     aPolicy.setAuthorizationInfo(authInfo);
/* 143 */     if (this.trace)
/* 144 */       log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuthorizationInfo authInfo, AuthorizationConfigEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 150 */     AuthorizationModuleEntry entry = entryInfo.getEntry();
/* 151 */     authInfo.add(entry);
/* 152 */     if (this.trace)
/* 153 */       log.trace("addChild.AuthorizationInfo, name: " + entry.getPolicyModuleName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuthorizationConfigEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 159 */     entryInfo.addOption(option);
/* 160 */     if (this.trace)
/* 161 */       log.trace("addChild.AuthorizationConfigEntryHolder, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuthorizationInfo authInfo, AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 167 */     authInfo.add(entry);
/*     */   }
/*     */ 
/*     */   public void addChild(AuthorizationModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 173 */     entry.add(option);
/* 174 */     if (this.trace)
/* 175 */       log.trace("addChild.AuthorizationModuleEntry, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public Object newChild(MappingInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 182 */     Object child = null;
/* 183 */     if (this.trace)
/* 184 */       log.trace("newChild.RoleMappingInfo, localName: " + localName);
/* 185 */     if ("mapping-module".equals(localName))
/*     */     {
/* 187 */       String code = attrs.getValue("code");
/* 188 */       code = StringPropertyReplacer.replaceProperties(code.trim());
/* 189 */       MappingModuleEntry entry = new MappingModuleEntry(code);
/* 190 */       child = entry;
/* 191 */       if (this.trace) {
/* 192 */         log.trace("newChild.RoleMappingInfo, mapping-module code: " + code);
/*     */       }
/*     */     }
/* 195 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 202 */     Object child = null;
/* 203 */     if (this.trace)
/* 204 */       log.trace("newChild.MappingModuleEntry, localName: " + localName);
/* 205 */     if ("module-option".equals(localName))
/*     */     {
/* 207 */       String name = attrs.getValue("name");
/* 208 */       child = new ModuleOption(name);
/* 209 */       if (this.trace) {
/* 210 */         log.trace("newChild.MappingModuleEntry, module-option name: " + name);
/*     */       }
/*     */     }
/* 213 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationPolicy aPolicy, MappingInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 219 */     aPolicy.setRoleMappingInfo(authInfo);
/* 220 */     if (this.trace)
/* 221 */       log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(MappingModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 227 */     entry.add(option);
/* 228 */     if (this.trace)
/* 229 */       log.trace("addChild.MappingModuleEntry, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(MappingInfo authInfo, MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 235 */     authInfo.add(entry);
/*     */   }
/*     */ 
/*     */   public Object newChild(AuditInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 242 */     Object child = null;
/* 243 */     if (this.trace)
/* 244 */       log.trace("newChild.AuditInfo, localName: " + localName);
/* 245 */     if ("provider-module".equals(localName))
/*     */     {
/* 247 */       String code = attrs.getValue("code");
/* 248 */       code = StringPropertyReplacer.replaceProperties(code.trim());
/* 249 */       AuditProviderEntry entry = new AuditProviderEntry(code);
/* 250 */       child = entry;
/* 251 */       if (this.trace) {
/* 252 */         log.trace("newChild.AuditInfo, provider-module code: " + code);
/*     */       }
/*     */     }
/* 255 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(AuditProviderEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 262 */     Object child = null;
/* 263 */     if (this.trace)
/* 264 */       log.trace("newChild.AuditProviderEntry, localName: " + localName);
/* 265 */     if ("module-option".equals(localName))
/*     */     {
/* 267 */       String name = attrs.getValue("name");
/* 268 */       child = new ModuleOption(name);
/* 269 */       if (this.trace) {
/* 270 */         log.trace("newChild.AuditProviderEntry, module-option name: " + name);
/*     */       }
/*     */     }
/* 273 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationPolicy aPolicy, AuditInfo auditInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 279 */     aPolicy.setAuditInfo(auditInfo);
/* 280 */     if (this.trace)
/* 281 */       log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuditProviderEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 287 */     entry.add(option);
/* 288 */     if (this.trace)
/* 289 */       log.trace("addChild.MappingModuleEntry, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuditInfo auditInfo, AuditProviderEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 295 */     auditInfo.add(entry);
/*     */   }
/*     */ 
/*     */   public Object newChild(IdentityTrustInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 302 */     Object child = null;
/* 303 */     if (this.trace)
/* 304 */       log.trace("newChild.IdentityTrustInfo, localName: " + localName);
/* 305 */     if ("trust-module".equals(localName))
/*     */     {
/* 307 */       String code = attrs.getValue("code");
/* 308 */       code = StringPropertyReplacer.replaceProperties(code.trim());
/*     */ 
/* 310 */       String flag = attrs.getValue("flag");
/* 311 */       if (flag != null)
/* 312 */         flag = StringPropertyReplacer.replaceProperties(flag.trim());
/* 313 */       if (flag == null)
/* 314 */         flag = "REQUIRED";
/*     */       else
/* 316 */         flag = flag.toUpperCase();
/* 317 */       IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(code);
/* 318 */       if ("REQUIRED".equals(flag)) {
/* 319 */         entry.setControlFlag(ControlFlag.REQUIRED);
/*     */       }
/* 321 */       else if ("REQUISITE".equals(flag)) {
/* 322 */         entry.setControlFlag(ControlFlag.REQUISITE);
/*     */       }
/* 324 */       else if ("SUFFICIENT".equals(flag))
/* 325 */         entry.setControlFlag(ControlFlag.SUFFICIENT);
/*     */       else {
/* 327 */         entry.setControlFlag(ControlFlag.OPTIONAL);
/*     */       }
/* 329 */       child = entry;
/* 330 */       if (this.trace) {
/* 331 */         log.trace("newChild.IdentityTrustInfo, trust-module code: " + code);
/*     */       }
/*     */     }
/* 334 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(IdentityTrustModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 341 */     Object child = null;
/* 342 */     if (this.trace)
/* 343 */       log.trace("newChild.trustProviderEntry, localName: " + localName);
/* 344 */     if ("module-option".equals(localName))
/*     */     {
/* 346 */       String name = attrs.getValue("name");
/* 347 */       child = new ModuleOption(name);
/* 348 */       if (this.trace) {
/* 349 */         log.trace("newChild.trustProviderEntry, module-option name: " + name);
/*     */       }
/*     */     }
/* 352 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationPolicy aPolicy, IdentityTrustInfo auditInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 358 */     aPolicy.setIdentityTrustInfo(auditInfo);
/* 359 */     if (this.trace)
/* 360 */       log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(IdentityTrustModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 366 */     entry.add(option);
/* 367 */     if (this.trace)
/* 368 */       log.trace("addChild.MappingModuleEntry, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(IdentityTrustInfo auditInfo, IdentityTrustModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 374 */     auditInfo.add(entry);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.config.SecurityConfigObjectModelFactory
 * JD-Core Version:    0.6.0
 */