/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.security.MessageDigest;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.acl.Group;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.login.FailedLoginException;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.crypto.digest.DigestCallback;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.Base64Encoder;
/*     */ import org.jboss.security.Base64Utils;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.plugins.TransactionManagerLocator;
/*     */ 
/*     */ public class Util
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(Util.class);
/*     */   public static final String BASE64_ENCODING = "BASE64";
/*     */   public static final String BASE16_ENCODING = "HEX";
/*     */   public static final String RFC2617_ENCODING = "RFC2617";
/*  75 */   private static char[] MD5_HEX = "0123456789abcdef".toCharArray();
/*     */ 
/*     */   static Group[] getRoleSets(String targetUser, Properties roles, char roleGroupSeperator, AbstractServerLoginModule aslm)
/*     */   {
/*  93 */     Logger log = aslm.log;
/*  94 */     boolean trace = log.isTraceEnabled();
/*  95 */     Enumeration users = roles.propertyNames();
/*  96 */     SimpleGroup rolesGroup = new SimpleGroup("Roles");
/*  97 */     ArrayList groups = new ArrayList();
/*  98 */     groups.add(rolesGroup);
/*  99 */     while ((users.hasMoreElements()) && (targetUser != null))
/*     */     {
/* 101 */       String user = (String)users.nextElement();
/* 102 */       String value = roles.getProperty(user);
/* 103 */       if (trace) {
/* 104 */         log.trace("Checking user: " + user + ", roles string: " + value);
/*     */       }
/*     */ 
/* 107 */       int index = user.indexOf(roleGroupSeperator, targetUser.length());
/* 108 */       boolean isRoleGroup = false;
/* 109 */       boolean userMatch = false;
/* 110 */       if ((index > 0) && (targetUser.regionMatches(0, user, 0, index) == true))
/* 111 */         isRoleGroup = true;
/*     */       else {
/* 113 */         userMatch = targetUser.equals(user);
/*     */       }
/*     */ 
/* 116 */       if (isRoleGroup == true)
/*     */       {
/* 118 */         String groupName = user.substring(index + 1);
/* 119 */         if (groupName.equals("Roles"))
/*     */         {
/* 121 */           if (trace)
/* 122 */             log.trace("Adding to Roles: " + value);
/* 123 */           parseGroupMembers(rolesGroup, value, aslm);
/*     */         }
/*     */         else
/*     */         {
/* 127 */           if (trace)
/* 128 */             log.trace("Adding to " + groupName + ": " + value);
/* 129 */           SimpleGroup group = new SimpleGroup(groupName);
/* 130 */           parseGroupMembers(group, value, aslm);
/* 131 */           groups.add(group);
/*     */         }
/*     */       }
/* 134 */       else if (userMatch == true)
/*     */       {
/* 136 */         if (trace) {
/* 137 */           log.trace("Adding to Roles: " + value);
/*     */         }
/* 139 */         parseGroupMembers(rolesGroup, value, aslm);
/*     */       }
/*     */     }
/* 142 */     Group[] roleSets = new Group[groups.size()];
/* 143 */     groups.toArray(roleSets);
/* 144 */     return roleSets;
/*     */   }
/*     */ 
/*     */   static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm)
/*     */     throws LoginException
/*     */   {
/* 156 */     return getRoleSets(username, dsJndiName, rolesQuery, aslm, false);
/*     */   }
/*     */ 
/*     */   static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm, boolean suspendResume)
/*     */     throws LoginException
/*     */   {
/* 168 */     Logger log = aslm.log;
/* 169 */     boolean trace = log.isTraceEnabled();
/* 170 */     Connection conn = null;
/* 171 */     HashMap setsMap = new HashMap();
/* 172 */     PreparedStatement ps = null;
/* 173 */     ResultSet rs = null;
/*     */ 
/* 175 */     TransactionManager tm = null;
/*     */ 
/* 177 */     if (suspendResume)
/*     */     {
/* 179 */       TransactionManagerLocator tml = new TransactionManagerLocator();
/*     */       try
/*     */       {
/* 182 */         tm = tml.getTM("java:/TransactionManager");
/*     */       }
/*     */       catch (NamingException e1)
/*     */       {
/* 186 */         throw new RuntimeException(e1);
/*     */       }
/* 188 */       if (tm == null)
/* 189 */         throw new IllegalStateException("Transaction Manager is null");
/*     */     }
/* 191 */     Transaction tx = null;
/* 192 */     if (suspendResume)
/*     */     {
/*     */       try
/*     */       {
/* 197 */         tx = tm.suspend();
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 201 */         throw new RuntimeException(e);
/*     */       }
/* 203 */       if (trace) {
/* 204 */         log.trace("suspendAnyTransaction");
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 209 */       InitialContext ctx = new InitialContext();
/* 210 */       DataSource ds = (DataSource)ctx.lookup(dsJndiName);
/* 211 */       conn = ds.getConnection();
/*     */ 
/* 213 */       if (trace)
/* 214 */         log.trace("Excuting query: " + rolesQuery + ", with username: " + username);
/* 215 */       ps = conn.prepareStatement(rolesQuery);
/*     */       try
/*     */       {
/* 218 */         ps.setString(1, username);
/*     */       }
/*     */       catch (ArrayIndexOutOfBoundsException ignore)
/*     */       {
/*     */       }
/*     */ 
/* 224 */       rs = ps.executeQuery();
/*     */       Group[] arrayOfGroup1;
/* 225 */       if (!rs.next())
/*     */       {
/* 227 */         if (trace)
/* 228 */           log.trace("No roles found");
/* 229 */         if (aslm.getUnauthenticatedIdentity() == null) {
/* 230 */           throw new FailedLoginException("No matching username found in Roles");
/*     */         }
/*     */ 
/* 234 */         Group[] roleSets = { new SimpleGroup("Roles") };
/* 235 */         arrayOfGroup1 = roleSets; jsr 250;
/*     */       }
/*     */ 
/*     */       do
/*     */       {
/* 240 */         String name = rs.getString(1);
/* 241 */         String groupName = rs.getString(2);
/* 242 */         if ((groupName == null) || (groupName.length() == 0))
/* 243 */           groupName = "Roles";
/* 244 */         Group group = (Group)setsMap.get(groupName);
/* 245 */         if (group == null)
/*     */         {
/* 247 */           group = new SimpleGroup(groupName);
/* 248 */           setsMap.put(groupName, group);
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 253 */           Principal p = aslm.createIdentity(name);
/* 254 */           if (trace)
/* 255 */             log.trace("Assign user to role " + name);
/* 256 */           group.addMember(p);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 260 */           log.debug("Failed to create principal: " + name, e);
/*     */         }
/*     */       }
/* 262 */       while (rs.next());
/*     */     }
/*     */     catch (NamingException ex)
/*     */     {
/* 266 */       LoginException le = new LoginException("Error looking up DataSource from: " + dsJndiName);
/* 267 */       le.initCause(ex);
/* 268 */       throw le;
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 272 */       LoginException le = new LoginException("Query failed");
/* 273 */       le.initCause(ex);
/* 274 */       throw le;
/*     */     }
/*     */     finally
/*     */     {
/* 278 */       if (rs != null)
/*     */       {
/*     */         try
/*     */         {
/* 282 */           rs.close();
/*     */         }
/*     */         catch (SQLException e) {
/*     */         }
/*     */       }
/* 287 */       if (ps != null)
/*     */       {
/*     */         try
/*     */         {
/* 291 */           ps.close();
/*     */         }
/*     */         catch (SQLException e) {
/*     */         }
/*     */       }
/* 296 */       if (conn != null)
/*     */       {
/*     */         try
/*     */         {
/* 300 */           conn.close();
/*     */         }
/*     */         catch (Exception ex) {
/*     */         }
/*     */       }
/* 305 */       if (suspendResume)
/*     */       {
/*     */         try
/*     */         {
/* 310 */           tm.resume(tx);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 314 */           throw new RuntimeException(e);
/*     */         }
/* 316 */         if (trace) {
/* 317 */           log.trace("resumeAnyTransaction");
/*     */         }
/*     */       }
/*     */     }
/* 321 */     Group[] roleSets = new Group[setsMap.size()];
/* 322 */     setsMap.values().toArray(roleSets);
/* 323 */     return roleSets;
/*     */   }
/*     */ 
/*     */   static Properties loadProperties(String defaultsName, String propertiesName, Logger log)
/*     */     throws IOException
/*     */   {
/* 345 */     Properties bundle = null;
/* 346 */     ClassLoader loader = SecurityActions.getContextClassloader();
/* 347 */     URL defaultUrl = null;
/* 348 */     URL url = null;
/*     */ 
/* 350 */     if ((loader instanceof URLClassLoader))
/*     */     {
/* 352 */       URLClassLoader ucl = (URLClassLoader)loader;
/* 353 */       defaultUrl = SecurityActions.findResource(ucl, defaultsName);
/* 354 */       url = SecurityActions.findResource(ucl, propertiesName);
/* 355 */       log.trace("findResource: " + url);
/*     */     }
/*     */ 
/* 358 */     if (defaultUrl == null)
/* 359 */       defaultUrl = loader.getResource(defaultsName);
/* 360 */     if (url == null)
/* 361 */       url = loader.getResource(propertiesName);
/* 362 */     if ((url == null) && (defaultUrl == null))
/*     */     {
/* 364 */       String msg = "No properties file: " + propertiesName + " or defaults: " + defaultsName + " found";
/*     */ 
/* 366 */       throw new IOException(msg);
/*     */     }
/*     */ 
/* 369 */     log.trace("Properties file=" + url + ", defaults=" + defaultUrl);
/* 370 */     Properties defaults = new Properties();
/* 371 */     if (defaultUrl != null)
/*     */     {
/*     */       try
/*     */       {
/* 375 */         InputStream is = defaultUrl.openStream();
/* 376 */         defaults.load(is);
/* 377 */         is.close();
/* 378 */         log.debug("Loaded defaults, users=" + defaults.keySet());
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 382 */         log.debug("Failed to load defaults", e);
/*     */       }
/*     */     }
/*     */ 
/* 386 */     bundle = new Properties(defaults);
/* 387 */     if (url != null)
/*     */     {
/* 389 */       InputStream is = null;
/*     */       try
/*     */       {
/* 392 */         is = SecurityActions.openStream(url);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 396 */         log.trace("Open stream error", e);
/* 397 */         throw new IOException(e.getLocalizedMessage());
/*     */       }
/* 399 */       if (is != null)
/*     */       {
/* 401 */         bundle.load(is);
/* 402 */         is.close();
/*     */       }
/*     */       else
/*     */       {
/* 406 */         throw new IOException("Properties file " + propertiesName + " not avilable");
/*     */       }
/* 408 */       log.debug("Loaded properties, users=" + bundle.keySet());
/*     */     }
/*     */ 
/* 411 */     return bundle;
/*     */   }
/*     */ 
/*     */   static Properties loadProperties(String propertiesName, Logger log)
/*     */     throws IOException
/*     */   {
/* 430 */     ClassLoader loader = SecurityActions.getContextClassloader();
/* 431 */     URL url = null;
/*     */ 
/* 433 */     if ((loader instanceof URLClassLoader))
/*     */     {
/* 435 */       URLClassLoader ucl = (URLClassLoader)loader;
/* 436 */       url = SecurityActions.findResource(ucl, propertiesName);
/* 437 */       log.trace("findResource: " + url);
/*     */     }
/* 439 */     if (url == null)
/* 440 */       url = loader.getResource(propertiesName);
/* 441 */     if (url == null)
/*     */     {
/* 443 */       url = new URL(propertiesName);
/*     */     }
/*     */ 
/* 446 */     log.trace("Properties file=" + url);
/*     */ 
/* 448 */     Properties bundle = new Properties();
/* 449 */     if (url != null)
/*     */     {
/* 451 */       InputStream is = null;
/*     */       try
/*     */       {
/* 454 */         is = SecurityActions.openStream(url);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 458 */         log.trace("open stream error:", e);
/* 459 */         throw new IOException(e.getLocalizedMessage());
/*     */       }
/* 461 */       if (is != null)
/*     */       {
/* 463 */         bundle.load(is);
/* 464 */         is.close();
/*     */       }
/*     */       else
/*     */       {
/* 468 */         throw new IOException("Properties file " + propertiesName + " not available");
/*     */       }
/* 470 */       log.debug("Loaded properties, users=" + bundle.keySet());
/*     */     }
/*     */ 
/* 473 */     return bundle;
/*     */   }
/*     */ 
/*     */   static void parseGroupMembers(Group group, String roles, AbstractServerLoginModule aslm)
/*     */   {
/* 489 */     StringTokenizer tokenizer = new StringTokenizer(roles, ",");
/* 490 */     while (tokenizer.hasMoreTokens())
/*     */     {
/* 492 */       String token = tokenizer.nextToken();
/*     */       try
/*     */       {
/* 495 */         Principal p = aslm.createIdentity(token);
/* 496 */         group.addMember(p);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 500 */         aslm.log.warn("Failed to create principal for: " + token, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password)
/*     */   {
/* 521 */     return createPasswordHash(hashAlgorithm, hashEncoding, hashCharset, username, password, null);
/*     */   }
/*     */ 
/*     */   public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password, DigestCallback callback)
/*     */   {
/* 544 */     String passwordHash = null;
/*     */     byte[] passBytes;
/*     */     try
/*     */     {
/*     */       byte[] passBytes;
/* 549 */       if (hashCharset == null)
/* 550 */         passBytes = password.getBytes();
/*     */       else
/* 552 */         passBytes = password.getBytes(hashCharset);
/*     */     }
/*     */     catch (UnsupportedEncodingException uee)
/*     */     {
/* 556 */       log.error("charset " + hashCharset + " not found. Using platform default.", uee);
/* 557 */       passBytes = password.getBytes();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 563 */       MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
/* 564 */       if (callback != null)
/* 565 */         callback.preDigest(md);
/* 566 */       md.update(passBytes);
/* 567 */       if (callback != null)
/* 568 */         callback.postDigest(md);
/* 569 */       byte[] hash = md.digest();
/* 570 */       if (hashEncoding.equalsIgnoreCase("BASE64"))
/*     */       {
/* 572 */         passwordHash = encodeBase64(hash);
/*     */       }
/* 574 */       else if (hashEncoding.equalsIgnoreCase("HEX"))
/*     */       {
/* 576 */         passwordHash = encodeBase16(hash);
/*     */       }
/* 578 */       else if (hashEncoding.equalsIgnoreCase("RFC2617"))
/*     */       {
/* 580 */         passwordHash = encodeRFC2617(hash);
/*     */       }
/*     */       else
/*     */       {
/* 584 */         log.error("Unsupported hash encoding format " + hashEncoding);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 589 */       log.error("Password hash calculation failed ", e);
/*     */     }
/* 591 */     return passwordHash;
/*     */   }
/*     */ 
/*     */   public static String encodeRFC2617(byte[] data)
/*     */   {
/* 614 */     char[] hash = new char[32];
/* 615 */     for (int i = 0; i < 16; i++)
/*     */     {
/* 617 */       int j = data[i] >> 4 & 0xF;
/* 618 */       hash[(i * 2)] = MD5_HEX[j];
/* 619 */       j = data[i] & 0xF;
/* 620 */       hash[(i * 2 + 1)] = MD5_HEX[j];
/*     */     }
/* 622 */     return new String(hash);
/*     */   }
/*     */ 
/*     */   public static String encodeBase16(byte[] bytes)
/*     */   {
/* 631 */     StringBuffer sb = new StringBuffer(bytes.length * 2);
/* 632 */     for (int i = 0; i < bytes.length; i++)
/*     */     {
/* 634 */       byte b = bytes[i];
/*     */ 
/* 636 */       char c = (char)(b >> 4 & 0xF);
/* 637 */       if (c > '\t')
/* 638 */         c = (char)(c - '\n' + 97);
/*     */       else
/* 640 */         c = (char)(c + '0');
/* 641 */       sb.append(c);
/*     */ 
/* 643 */       c = (char)(b & 0xF);
/* 644 */       if (c > '\t')
/* 645 */         c = (char)(c - '\n' + 97);
/*     */       else
/* 647 */         c = (char)(c + '0');
/* 648 */       sb.append(c);
/*     */     }
/* 650 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static String encodeBase64(byte[] bytes)
/*     */   {
/* 660 */     String base64 = null;
/*     */     try
/*     */     {
/* 663 */       base64 = Base64Encoder.encode(bytes);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 668 */     return base64;
/*     */   }
/*     */ 
/*     */   public static String tob64(byte[] buffer)
/*     */   {
/* 676 */     return Base64Utils.tob64(buffer);
/*     */   }
/*     */ 
/*     */   public static byte[] fromb64(String str) throws NumberFormatException
/*     */   {
/* 681 */     return Base64Utils.fromb64(str);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.Util
 * JD-Core Version:    0.6.0
 */