/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class UsersRolesLoginModule extends UsernamePasswordLoginModule
/*     */ {
/*  68 */   private String defaultUsersRsrcName = "defaultUsers.properties";
/*     */ 
/*  70 */   private String defaultRolesRsrcName = "defaultRoles.properties";
/*     */ 
/*  72 */   private String usersRsrcName = "users.properties";
/*     */ 
/*  74 */   private String rolesRsrcName = "roles.properties";
/*     */   private Properties users;
/*     */   private Properties roles;
/*  82 */   private char roleGroupSeperator = '.';
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/* 107 */     super.initialize(subject, callbackHandler, sharedState, options);
/*     */     try
/*     */     {
/* 111 */       String option = (String)options.get("usersProperties");
/* 112 */       if (option != null)
/* 113 */         this.usersRsrcName = option;
/* 114 */       option = (String)options.get("defaultUsersProperties");
/* 115 */       if (option != null)
/* 116 */         this.defaultUsersRsrcName = option;
/* 117 */       option = (String)options.get("rolesProperties");
/* 118 */       if (option != null)
/* 119 */         this.rolesRsrcName = option;
/* 120 */       option = (String)options.get("defaultRolesProperties");
/* 121 */       if (option != null)
/* 122 */         this.defaultRolesRsrcName = option;
/* 123 */       option = (String)options.get("roleGroupSeperator");
/* 124 */       if (option != null) {
/* 125 */         this.roleGroupSeperator = option.charAt(0);
/*     */       }
/* 127 */       this.users = createUsers(options);
/* 128 */       this.roles = createRoles(options);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 135 */       this.log.error("Failed to load users/passwords/role files", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 147 */     if (this.users == null)
/* 148 */       throw new LoginException("Missing users.properties file.");
/* 149 */     if (this.roles == null) {
/* 150 */       throw new LoginException("Missing roles.properties file.");
/*     */     }
/* 152 */     return super.login();
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 162 */     String targetUser = getUsername();
/* 163 */     Group[] roleSets = Util.getRoleSets(targetUser, this.roles, this.roleGroupSeperator, this);
/* 164 */     return roleSets;
/*     */   }
/*     */ 
/*     */   protected String getUsersPassword()
/*     */   {
/* 169 */     String username = getUsername();
/* 170 */     String password = null;
/* 171 */     if (username != null)
/* 172 */       password = this.users.getProperty(username, null);
/* 173 */     return password;
/*     */   }
/*     */ 
/*     */   protected void loadUsers()
/*     */     throws IOException
/*     */   {
/* 186 */     this.users = Util.loadProperties(this.defaultUsersRsrcName, this.usersRsrcName, this.log);
/*     */   }
/*     */ 
/*     */   protected Properties createUsers(Map options)
/*     */     throws IOException
/*     */   {
/* 200 */     loadUsers();
/* 201 */     return this.users;
/*     */   }
/*     */ 
/*     */   protected void loadRoles()
/*     */     throws IOException
/*     */   {
/* 212 */     this.roles = Util.loadProperties(this.defaultRolesRsrcName, this.rolesRsrcName, this.log);
/*     */   }
/*     */ 
/*     */   protected Properties createRoles(Map options)
/*     */     throws IOException
/*     */   {
/* 226 */     loadRoles();
/* 227 */     return this.roles;
/*     */   }
/*     */ 
/*     */   protected void parseGroupMembers(Group group, String roles)
/*     */   {
/* 241 */     Util.parseGroupMembers(group, roles, this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.UsersRolesLoginModule
 * JD-Core Version:    0.6.0
 */