/*    */ package org.jboss.security.auth.spi;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.security.acl.Group;
/*    */ import javax.security.auth.login.LoginException;
/*    */ import org.jboss.security.SimpleGroup;
/*    */ import org.jboss.security.SimplePrincipal;
/*    */ 
/*    */ public class SimpleServerLoginModule extends UsernamePasswordLoginModule
/*    */ {
/*    */   private SimplePrincipal user;
/*    */   private boolean guestOnly;
/*    */ 
/*    */   protected Principal getIdentity()
/*    */   {
/* 54 */     Principal principal = this.user;
/* 55 */     if (principal == null)
/* 56 */       principal = super.getIdentity();
/* 57 */     return principal;
/*    */   }
/*    */ 
/*    */   protected boolean validatePassword(String inputPassword, String expectedPassword)
/*    */   {
/* 62 */     boolean isValid = false;
/* 63 */     if (inputPassword == null)
/*    */     {
/* 65 */       this.guestOnly = true;
/* 66 */       isValid = true;
/* 67 */       this.user = new SimplePrincipal("guest");
/*    */     }
/*    */     else
/*    */     {
/* 71 */       isValid = inputPassword.equals(expectedPassword);
/*    */     }
/* 73 */     return isValid;
/*    */   }
/*    */ 
/*    */   protected Group[] getRoleSets() throws LoginException
/*    */   {
/* 78 */     Group[] roleSets = { new SimpleGroup("Roles") };
/* 79 */     if (!this.guestOnly)
/* 80 */       roleSets[0].addMember(new SimplePrincipal("user"));
/* 81 */     roleSets[0].addMember(new SimplePrincipal("guest"));
/* 82 */     return roleSets;
/*    */   }
/*    */ 
/*    */   protected String getUsersPassword() throws LoginException
/*    */   {
/* 87 */     return getUsername();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.SimpleServerLoginModule
 * JD-Core Version:    0.6.0
 */