/*    */ package org.jboss.security.auth.spi;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.URL;
/*    */ import java.net.URLClassLoader;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassloader()
/*    */   {
/* 45 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
/*    */     {
/*    */       public Object run()
/*    */       {
/* 49 */         return Thread.currentThread().getContextClassLoader();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static URL findResource(URLClassLoader cl, String name) {
/* 56 */     return (URL)AccessController.doPrivileged(new PrivilegedAction(cl, name)
/*    */     {
/*    */       public Object run()
/*    */       {
/* 60 */         return this.val$cl.findResource(this.val$name);
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static InputStream openStream(URL url) throws PrivilegedActionException {
/* 67 */     return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(url)
/*    */     {
/*    */       public Object run() throws IOException
/*    */       {
/* 71 */         return this.val$url.openStream();
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.SecurityActions
 * JD-Core Version:    0.6.0
 */