/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.auth.spi.LoginModule;
/*     */ 
/*     */ public class ProxyLoginModule
/*     */   implements LoginModule
/*     */ {
/*     */   private String moduleName;
/*     */   private LoginModule delegate;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/*  64 */     this.moduleName = ((String)options.get("moduleName"));
/*  65 */     if (this.moduleName == null)
/*     */     {
/*  67 */       System.out.println("Required moduleName option not given");
/*  68 */       return;
/*     */     }
/*     */ 
/*  72 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/*  75 */       Class clazz = loader.loadClass(this.moduleName);
/*  76 */       this.delegate = ((LoginModule)clazz.newInstance());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  80 */       System.out.println("ProxyLoginModule failed to load: " + this.moduleName);
/*  81 */       t.printStackTrace();
/*  82 */       return;
/*     */     }
/*     */ 
/*  85 */     this.delegate.initialize(subject, callbackHandler, sharedState, options);
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/*  95 */     if (this.moduleName == null)
/*  96 */       throw new LoginException("Required moduleName option not given");
/*  97 */     if (this.delegate == null) {
/*  98 */       throw new LoginException("Failed to load LoginModule: " + this.moduleName);
/*     */     }
/* 100 */     return this.delegate.login();
/*     */   }
/*     */ 
/*     */   public boolean commit() throws LoginException
/*     */   {
/* 105 */     boolean ok = false;
/* 106 */     if (this.delegate != null)
/* 107 */       ok = this.delegate.commit();
/* 108 */     return ok;
/*     */   }
/*     */ 
/*     */   public boolean abort() throws LoginException
/*     */   {
/* 113 */     boolean ok = true;
/* 114 */     if (this.delegate != null)
/* 115 */       ok = this.delegate.abort();
/* 116 */     return ok;
/*     */   }
/*     */ 
/*     */   public boolean logout() throws LoginException
/*     */   {
/* 121 */     boolean ok = true;
/* 122 */     if (this.delegate != null)
/* 123 */       ok = this.delegate.logout();
/* 124 */     return ok;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.ProxyLoginModule
 * JD-Core Version:    0.6.0
 */