/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.directory.Attribute;
/*     */ import javax.naming.directory.Attributes;
/*     */ import javax.naming.directory.SearchControls;
/*     */ import javax.naming.directory.SearchResult;
/*     */ import javax.naming.ldap.InitialLdapContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ 
/*     */ public class LdapExtLoginModule extends UsernamePasswordLoginModule
/*     */ {
/*     */   private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
/*     */   private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
/*     */   private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
/*     */   private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
/*     */   private static final String BIND_DN = "bindDN";
/*     */   private static final String BIND_CREDENTIAL = "bindCredential";
/*     */   private static final String BASE_CTX_DN = "baseCtxDN";
/*     */   private static final String BASE_FILTER_OPT = "baseFilter";
/*     */   private static final String ROLE_FILTER_OPT = "roleFilter";
/*     */   private static final String ROLE_RECURSION = "roleRecursion";
/*     */   private static final String DEFAULT_ROLE = "defaultRole";
/*     */   private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
/*     */   private static final String SEARCH_SCOPE_OPT = "searchScope";
/*     */   private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
/*     */   protected String bindDN;
/*     */   protected String bindCredential;
/*     */   protected String baseDN;
/*     */   protected String baseFilter;
/*     */   protected String rolesCtxDN;
/*     */   protected String roleFilter;
/*     */   protected String roleAttributeID;
/*     */   protected String roleNameAttributeID;
/*     */   protected boolean roleAttributeIsDN;
/* 164 */   protected int recursion = 0;
/* 165 */   protected int searchTimeLimit = 10000;
/* 166 */   protected int searchScope = 2;
/*     */   protected boolean trace;
/* 173 */   private transient SimpleGroup userRoles = new SimpleGroup("Roles");
/*     */ 
/*     */   protected String getUsersPassword()
/*     */     throws LoginException
/*     */   {
/* 182 */     return "";
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 195 */     Group[] roleSets = { this.userRoles };
/* 196 */     return roleSets;
/*     */   }
/*     */ 
/*     */   protected boolean validatePassword(String inputPassword, String expectedPassword)
/*     */   {
/* 207 */     boolean isValid = false;
/* 208 */     if (inputPassword != null)
/*     */     {
/* 211 */       if (inputPassword.length() == 0)
/*     */       {
/* 214 */         boolean allowEmptyPasswords = true;
/* 215 */         String flag = (String)this.options.get("allowEmptyPasswords");
/* 216 */         if (flag != null)
/* 217 */           allowEmptyPasswords = Boolean.valueOf(flag).booleanValue();
/* 218 */         if (!allowEmptyPasswords)
/*     */         {
/* 220 */           this.log.trace("Rejecting empty password due to allowEmptyPasswords");
/* 221 */           return false;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 228 */         String username = getUsername();
/* 229 */         isValid = createLdapInitContext(username, inputPassword);
/* 230 */         defaultRole();
/* 231 */         isValid = true;
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 235 */         super.setValidateError(e);
/*     */       }
/*     */     }
/* 238 */     return isValid;
/*     */   }
/*     */ 
/*     */   private void defaultRole()
/*     */   {
/*     */     try
/*     */     {
/* 248 */       String defaultRole = (String)this.options.get("defaultRole");
/* 249 */       if ((defaultRole == null) || (defaultRole.equals("")))
/*     */       {
/* 251 */         return;
/*     */       }
/* 253 */       Principal p = super.createIdentity(defaultRole);
/* 254 */       this.log.trace("Assign user to role " + defaultRole);
/* 255 */       this.userRoles.addMember(p);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 259 */       this.log.debug("could not add default role to user", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean createLdapInitContext(String username, Object credential)
/*     */     throws Exception
/*     */   {
/* 274 */     this.bindDN = ((String)this.options.get("bindDN"));
/* 275 */     this.bindCredential = ((String)this.options.get("bindCredential"));
/* 276 */     String securityDomain = (String)this.options.get("jaasSecurityDomain");
/* 277 */     if (securityDomain != null)
/*     */     {
/* 279 */       ObjectName serviceName = new ObjectName(securityDomain);
/* 280 */       char[] tmp = DecodeAction.decode(this.bindCredential, serviceName);
/* 281 */       this.bindCredential = new String(tmp);
/*     */     }
/*     */ 
/* 284 */     this.baseDN = ((String)this.options.get("baseCtxDN"));
/* 285 */     this.baseFilter = ((String)this.options.get("baseFilter"));
/* 286 */     this.roleFilter = ((String)this.options.get("roleFilter"));
/* 287 */     this.roleAttributeID = ((String)this.options.get("roleAttributeID"));
/* 288 */     if (this.roleAttributeID == null) {
/* 289 */       this.roleAttributeID = "role";
/*     */     }
/* 291 */     String roleAttributeIsDNOption = (String)this.options.get("roleAttributeIsDN");
/* 292 */     this.roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption).booleanValue();
/* 293 */     this.roleNameAttributeID = ((String)this.options.get("roleNameAttributeID"));
/* 294 */     if (this.roleNameAttributeID == null)
/* 295 */       this.roleNameAttributeID = "name";
/* 296 */     this.rolesCtxDN = ((String)this.options.get("rolesCtxDN"));
/* 297 */     String strRecursion = (String)this.options.get("roleRecursion");
/*     */     try
/*     */     {
/* 300 */       this.recursion = Integer.parseInt(strRecursion);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 304 */       if (this.trace) {
/* 305 */         this.log.trace("Failed to parse: " + strRecursion + ", disabling recursion");
/*     */       }
/* 307 */       this.recursion = 0;
/*     */     }
/* 309 */     String timeLimit = (String)this.options.get("searchTimeLimit");
/* 310 */     if (timeLimit != null)
/*     */     {
/*     */       try
/*     */       {
/* 314 */         this.searchTimeLimit = Integer.parseInt(timeLimit);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 318 */         if (this.trace)
/* 319 */           this.log.trace("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + this.searchTimeLimit);
/*     */       }
/*     */     }
/* 322 */     String scope = (String)this.options.get("searchScope");
/* 323 */     if ("OBJECT_SCOPE".equalsIgnoreCase(scope))
/* 324 */       this.searchScope = 0;
/* 325 */     else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope))
/* 326 */       this.searchScope = 1;
/* 327 */     if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
/* 328 */       this.searchScope = 2;
/*     */     }
/*     */ 
/* 331 */     InitialLdapContext ctx = null;
/*     */     try
/*     */     {
/* 334 */       ctx = constructInitialLdapContext(this.bindDN, this.bindCredential);
/*     */ 
/* 336 */       String userDN = bindDNAuthentication(ctx, username, credential, this.baseDN, this.baseFilter);
/*     */ 
/* 339 */       SearchControls constraints = new SearchControls();
/* 340 */       constraints.setSearchScope(this.searchScope);
/* 341 */       constraints.setReturningAttributes(new String[0]);
/* 342 */       constraints.setTimeLimit(this.searchTimeLimit);
/* 343 */       rolesSearch(ctx, constraints, username, userDN, this.recursion, 0);
/*     */     }
/*     */     finally
/*     */     {
/* 347 */       if (ctx != null)
/* 348 */         ctx.close();
/*     */     }
/* 350 */     return true;
/*     */   }
/*     */ 
/*     */   protected String bindDNAuthentication(InitialLdapContext ctx, String user, Object credential, String baseDN, String filter)
/*     */     throws NamingException
/*     */   {
/* 366 */     SearchControls constraints = new SearchControls();
/* 367 */     constraints.setSearchScope(2);
/* 368 */     constraints.setReturningAttributes(new String[0]);
/* 369 */     constraints.setTimeLimit(this.searchTimeLimit);
/*     */ 
/* 371 */     NamingEnumeration results = null;
/*     */ 
/* 374 */     Object[] filterArgs = { user };
/* 375 */     results = ctx.search(baseDN, filter, filterArgs, constraints);
/* 376 */     if (!results.hasMore())
/*     */     {
/* 378 */       results.close();
/* 379 */       throw new NamingException("Search of baseDN(" + baseDN + ") found no matches");
/*     */     }
/*     */ 
/* 382 */     SearchResult sr = (SearchResult)results.next();
/* 383 */     String name = sr.getName();
/* 384 */     String userDN = null;
/* 385 */     if (sr.isRelative() == true)
/* 386 */       userDN = name + "," + baseDN;
/*     */     else {
/* 388 */       throw new NamingException("Can't follow referal for authentication: " + name);
/*     */     }
/* 390 */     results.close();
/* 391 */     results = null;
/*     */ 
/* 393 */     InitialLdapContext userCtx = constructInitialLdapContext(userDN, credential);
/* 394 */     userCtx.close();
/*     */ 
/* 396 */     return userDN;
/*     */   }
/*     */ 
/*     */   protected void rolesSearch(InitialLdapContext ctx, SearchControls constraints, String user, String userDN, int recursionMax, int nesting)
/*     */     throws NamingException
/*     */   {
/* 412 */     Object[] filterArgs = { user, userDN };
/* 413 */     NamingEnumeration results = ctx.search(this.rolesCtxDN, this.roleFilter, filterArgs, constraints);
/*     */     try
/*     */     {
/* 416 */       while (results.hasMore())
/*     */       {
/* 418 */         SearchResult sr = (SearchResult)results.next();
/* 419 */         String dn = canonicalize(sr.getName());
/* 420 */         if ((nesting == 0) && (this.roleAttributeIsDN) && (this.roleNameAttributeID != null))
/*     */         {
/* 423 */           String[] attrNames = { this.roleNameAttributeID };
/* 424 */           Attributes result2 = ctx.getAttributes(dn, attrNames);
/* 425 */           Attribute roles2 = result2.get(this.roleNameAttributeID);
/* 426 */           if (roles2 != null)
/*     */           {
/* 428 */             for (int m = 0; m < roles2.size(); m++)
/*     */             {
/* 430 */               String roleName = (String)roles2.get(m);
/* 431 */               addRole(roleName);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 437 */         String[] attrNames = { this.roleAttributeID };
/* 438 */         Attributes result = ctx.getAttributes(dn, attrNames);
/* 439 */         if ((result != null) && (result.size() > 0))
/*     */         {
/* 441 */           Attribute roles = result.get(this.roleAttributeID);
/* 442 */           for (int n = 0; n < roles.size(); n++)
/*     */           {
/* 444 */             String roleName = (String)roles.get(n);
/* 445 */             if (this.roleAttributeIsDN)
/*     */             {
/* 448 */               String roleDN = roleName;
/* 449 */               String[] returnAttribute = { this.roleNameAttributeID };
/* 450 */               this.log.trace("Using roleDN: " + roleDN);
/*     */               try
/*     */               {
/* 453 */                 Attributes result2 = ctx.getAttributes(roleDN, returnAttribute);
/* 454 */                 Attribute roles2 = result2.get(this.roleNameAttributeID);
/* 455 */                 if (roles2 != null)
/*     */                 {
/* 457 */                   for (int m = 0; m < roles2.size(); m++)
/*     */                   {
/* 459 */                     roleName = (String)roles2.get(m);
/* 460 */                     addRole(roleName);
/*     */                   }
/*     */                 }
/*     */               }
/*     */               catch (NamingException e)
/*     */               {
/* 466 */                 this.log.trace("Failed to query roleNameAttrName", e);
/*     */               }
/*     */ 
/*     */             }
/*     */             else
/*     */             {
/* 472 */               addRole(roleName);
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 477 */         if (nesting < recursionMax)
/*     */         {
/* 479 */           rolesSearch(ctx, constraints, user, dn, recursionMax, nesting + 1);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 486 */       if (results != null)
/* 487 */         results.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private InitialLdapContext constructInitialLdapContext(String dn, Object credential)
/*     */     throws NamingException
/*     */   {
/* 494 */     Properties env = new Properties();
/* 495 */     Iterator iter = this.options.entrySet().iterator();
/* 496 */     while (iter.hasNext())
/*     */     {
/* 498 */       Map.Entry entry = (Map.Entry)iter.next();
/* 499 */       env.put(entry.getKey(), entry.getValue());
/*     */     }
/*     */ 
/* 503 */     String factoryName = env.getProperty("java.naming.factory.initial");
/* 504 */     if (factoryName == null)
/*     */     {
/* 506 */       factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
/* 507 */       env.setProperty("java.naming.factory.initial", factoryName);
/*     */     }
/* 509 */     String authType = env.getProperty("java.naming.security.authentication");
/* 510 */     if (authType == null)
/* 511 */       env.setProperty("java.naming.security.authentication", "simple");
/* 512 */     String protocol = env.getProperty("java.naming.security.protocol");
/* 513 */     String providerURL = (String)this.options.get("java.naming.provider.url");
/* 514 */     if (providerURL == null) {
/* 515 */       providerURL = "ldap://localhost:" + ((protocol != null) && (protocol.equals("ssl")) ? "636" : "389");
/*     */     }
/* 517 */     env.setProperty("java.naming.provider.url", providerURL);
/*     */ 
/* 519 */     if (dn != null)
/* 520 */       env.setProperty("java.naming.security.principal", dn);
/* 521 */     if (credential != null)
/* 522 */       env.put("java.naming.security.credentials", credential);
/* 523 */     traceLdapEnv(env);
/* 524 */     return new InitialLdapContext(env, null);
/*     */   }
/*     */ 
/*     */   private void traceLdapEnv(Properties env)
/*     */   {
/* 529 */     if (this.trace)
/*     */     {
/* 531 */       Properties tmp = new Properties();
/* 532 */       tmp.putAll(env);
/* 533 */       tmp.setProperty("java.naming.security.credentials", "***");
/* 534 */       this.log.trace("Logging into LDAP server, env=" + tmp.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   private String canonicalize(String searchResult)
/*     */   {
/* 541 */     String result = searchResult;
/* 542 */     int len = searchResult.length();
/*     */ 
/* 544 */     if (searchResult.endsWith("\""))
/*     */     {
/* 546 */       result = searchResult.substring(0, len - 1) + "," + this.rolesCtxDN + "\"";
/*     */     }
/*     */     else
/*     */     {
/* 551 */       result = searchResult + "," + this.rolesCtxDN;
/*     */     }
/* 553 */     return result;
/*     */   }
/*     */ 
/*     */   private void addRole(String roleName)
/*     */   {
/* 558 */     if (roleName != null)
/*     */     {
/*     */       try
/*     */       {
/* 562 */         Principal p = super.createIdentity(roleName);
/* 563 */         this.log.trace("Assign user to role " + roleName);
/* 564 */         this.userRoles.addMember(p);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 568 */         this.log.debug("Failed to create principal: " + roleName, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.LdapExtLoginModule
 * JD-Core Version:    0.6.0
 */