/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class IdentityLoginModule extends AbstractServerLoginModule
/*     */ {
/*     */   private String principalName;
/*     */   private String roleNames;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  62 */     super.initialize(subject, handler, sharedState, options);
/*  63 */     this.principalName = ((String)options.get("principal"));
/*  64 */     if (this.principalName == null)
/*  65 */       this.principalName = "guest";
/*  66 */     this.roleNames = ((String)options.get("roles"));
/*     */   }
/*     */ 
/*     */   public boolean login() throws LoginException
/*     */   {
/*  71 */     if (super.login() == true) {
/*  72 */       return true;
/*     */     }
/*  74 */     Principal principal = new SimplePrincipal(this.principalName);
/*  75 */     this.subject.getPrincipals().add(principal);
/*     */ 
/*  77 */     this.sharedState.put("javax.security.auth.login.name", this.principalName);
/*  78 */     this.loginOk = true;
/*  79 */     return true;
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/*  84 */     Principal principal = new SimplePrincipal(this.principalName);
/*  85 */     return principal;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets() throws LoginException
/*     */   {
/*  90 */     SimpleGroup roles = new SimpleGroup("Roles");
/*  91 */     Group[] roleSets = { roles };
/*  92 */     if (this.roleNames != null)
/*     */     {
/*  94 */       StringTokenizer tokenizer = new StringTokenizer(this.roleNames, ",");
/*  95 */       while (tokenizer.hasMoreTokens())
/*     */       {
/*  97 */         String roleName = tokenizer.nextToken();
/*  98 */         roles.addMember(new SimplePrincipal(roleName));
/*     */       }
/*     */     }
/* 101 */     return roleSets;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.IdentityLoginModule
 * JD-Core Version:    0.6.0
 */