/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ 
/*     */ class DecodeAction
/*     */   implements PrivilegedExceptionAction
/*     */ {
/*  41 */   private static final RuntimePermission decodePermission = new RuntimePermission("org.jboss.security.auth.spi.DecodeAction.decode");
/*     */   String password;
/*     */   ObjectName serviceName;
/*     */ 
/*     */   DecodeAction(String password, ObjectName serviceName)
/*     */   {
/*  49 */     this.password = password;
/*  50 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public Object run()
/*     */     throws Exception
/*     */   {
/*  61 */     byte[] secret = decode64(this.password);
/*     */ 
/*  63 */     String secretPassword = new String(secret, "UTF-8");
/*  64 */     return secretPassword.toCharArray();
/*     */   }
/*     */ 
/*     */   private byte[] decode64(String secret)
/*     */     throws Exception
/*     */   {
/*  70 */     byte[] encoding = Util.fromb64(secret);
/*  71 */     byte[] decode = decode(encoding);
/*  72 */     return decode;
/*     */   }
/*     */ 
/*     */   private byte[] decode(byte[] secret)
/*     */     throws Exception
/*     */   {
/*  84 */     SecurityManager sm = System.getSecurityManager();
/*  85 */     if (sm != null) {
/*  86 */       sm.checkPermission(decodePermission);
/*     */     }
/*  88 */     Cipher cipher = Cipher.getInstance(SecurityConfiguration.getCipherAlgorithm());
/*  89 */     cipher.init(2, SecurityConfiguration.getCipherKey(), SecurityConfiguration.getCipherSpec());
/*     */ 
/*  91 */     byte[] decode = cipher.doFinal(secret);
/*  92 */     return decode;
/*     */   }
/*     */ 
/*     */   static char[] decode(String password, ObjectName serviceName)
/*     */     throws Exception
/*     */   {
/*  98 */     DecodeAction action = new DecodeAction(password, serviceName);
/*     */     try
/*     */     {
/* 101 */       char[] decode = (char[])(char[])AccessController.doPrivileged(action);
/* 102 */       return decode;
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/*     */     }
/* 106 */     throw e.getException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.DecodeAction
 * JD-Core Version:    0.6.0
 */