/*     */ package org.jboss.security.auth.message.config;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.config.AuthConfigProvider;
/*     */ import javax.security.auth.message.config.ClientAuthConfig;
/*     */ import javax.security.auth.message.config.ServerAuthConfig;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossAuthConfigProvider
/*     */   implements AuthConfigProvider
/*     */ {
/*  44 */   private static Logger log = Logger.getLogger(JBossAuthConfigProvider.class);
/*  45 */   private Map contextProperties = null;
/*  46 */   private String cbhProperty = "authconfigprovider.client.callbackhandler";
/*     */ 
/*     */   public JBossAuthConfigProvider(Map props)
/*     */   {
/*  55 */     this.contextProperties = props;
/*     */   }
/*     */ 
/*     */   public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler)
/*     */     throws AuthException
/*     */   {
/*  64 */     if (handler == null)
/*     */     {
/*     */       try
/*     */       {
/*  68 */         handler = instantiateCallbackHandler();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  72 */         log.error("Exception in instantiating callback handler:", e);
/*  73 */         throw new AuthException(e.getMessage());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  78 */     return new JBossClientAuthConfig(layer, appContext, handler, this.contextProperties);
/*     */   }
/*     */ 
/*     */   public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler)
/*     */     throws AuthException
/*     */   {
/*  88 */     if (handler == null)
/*     */     {
/*     */       try
/*     */       {
/*  92 */         handler = instantiateCallbackHandler();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  96 */         log.error("Exception in instantiating callback handler:", e);
/*  97 */         throw new AuthException(e.getMessage());
/*     */       }
/*     */     }
/* 100 */     return new JBossServerAuthConfig(layer, appContext, handler, this.contextProperties);
/*     */   }
/*     */ 
/*     */   public void refresh()
/*     */     throws AuthException, SecurityException
/*     */   {
/*     */   }
/*     */ 
/*     */   private CallbackHandler instantiateCallbackHandler()
/*     */     throws Exception
/*     */   {
/* 113 */     String cbhClass = System.getProperty(this.cbhProperty);
/* 114 */     if (cbhClass == null) {
/* 115 */       throw new IllegalStateException("CallbackHandler not defined by system property " + this.cbhProperty);
/*     */     }
/* 117 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 118 */     Class cls = cl.loadClass(cbhClass);
/*     */ 
/* 120 */     return (CallbackHandler)cls.newInstance();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.message.config.JBossAuthConfigProvider
 * JD-Core Version:    0.6.0
 */