/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.Serializable;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.AuthPermission;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.security.auth.login.Configuration;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.auth.spi.UsersObjectModelFactory;
/*     */ import org.jboss.security.authorization.config.SecurityConfigObjectModelFactory;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.ApplicationPolicyRegistration;
/*     */ import org.jboss.security.config.PolicyConfig;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ 
/*     */ public class XMLLoginConfigImpl extends Configuration
/*     */   implements Serializable, ApplicationPolicyRegistration
/*     */ {
/*     */   private static final long serialVersionUID = -8965860493224188277L;
/*     */   private static final String DEFAULT_APP_CONFIG_NAME = "other";
/*  76 */   private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshLoginConfiguration");
/*  77 */   private static Logger log = Logger.getLogger(XMLLoginConfigImpl.class);
/*     */ 
/*  81 */   PolicyConfig appConfigs = new PolicyConfig();
/*     */   protected URL loginConfigURL;
/*     */   protected Configuration parentConfig;
/*  87 */   private boolean validateDTD = true;
/*     */ 
/*     */   public void refresh()
/*     */   {
/*  92 */     SecurityManager sm = System.getSecurityManager();
/*  93 */     if (sm != null)
/*  94 */       sm.checkPermission(REFRESH_PERM);
/*  95 */     if (log.isTraceEnabled())
/*  96 */       log.trace("Begin refresh");
/*  97 */     this.appConfigs.clear();
/*  98 */     loadConfig();
/*  99 */     if (log.isTraceEnabled())
/* 100 */       log.trace("End refresh");
/*     */   }
/*     */ 
/*     */   public AppConfigurationEntry[] getAppConfigurationEntry(String appName)
/*     */   {
/* 105 */     if (log.isTraceEnabled()) {
/* 106 */       log.trace("Begin getAppConfigurationEntry(" + appName + "), size=" + this.appConfigs.size());
/*     */     }
/*     */ 
/* 109 */     if (this.appConfigs.size() == 0) {
/* 110 */       loadConfig();
/*     */     }
/* 112 */     AppConfigurationEntry[] entry = null;
/* 113 */     ApplicationPolicy aPolicy = getApplicationPolicy(appName);
/* 114 */     AuthenticationInfo authInfo = null;
/* 115 */     if (aPolicy != null)
/*     */     {
/* 117 */       BaseAuthenticationInfo bai = aPolicy.getAuthenticationInfo();
/* 118 */       if ((bai instanceof AuthenticationInfo)) {
/* 119 */         authInfo = (AuthenticationInfo)bai;
/*     */       }
/*     */     }
/* 122 */     if (authInfo == null)
/*     */     {
/* 124 */       if (log.isTraceEnabled())
/* 125 */         log.trace("getAppConfigurationEntry(" + appName + "), no entry in appConfigs, tyring parentCont: " + this.parentConfig);
/* 126 */       if (this.parentConfig != null)
/* 127 */         entry = this.parentConfig.getAppConfigurationEntry(appName);
/* 128 */       if (entry == null)
/*     */       {
/* 130 */         if (log.isTraceEnabled())
/* 131 */           log.trace("getAppConfigurationEntry(" + appName + "), no entry in parentConfig, trying: " + "other");
/*     */       }
/* 133 */       ApplicationPolicy defPolicy = this.appConfigs.get("other");
/* 134 */       authInfo = defPolicy != null ? (AuthenticationInfo)defPolicy.getAuthenticationInfo() : null;
/*     */     }
/*     */ 
/* 137 */     if (authInfo != null)
/*     */     {
/* 139 */       if (log.isTraceEnabled()) {
/* 140 */         log.trace("End getAppConfigurationEntry(" + appName + "), authInfo=" + authInfo);
/*     */       }
/* 142 */       AuthenticationInfo theAuthInfo = authInfo;
/* 143 */       PrivilegedAction action = new PrivilegedAction(theAuthInfo)
/*     */       {
/*     */         public Object run()
/*     */         {
/* 147 */           return this.val$theAuthInfo.copyAppConfigurationEntry();
/*     */         }
/*     */       };
/* 150 */       entry = (AppConfigurationEntry[])(AppConfigurationEntry[])AccessController.doPrivileged(action);
/*     */     }
/* 154 */     else if (log.isTraceEnabled()) {
/* 155 */       log.trace("End getAppConfigurationEntry(" + appName + "), failed to find entry");
/*     */     }
/*     */ 
/* 158 */     return entry;
/*     */   }
/*     */ 
/*     */   public URL getConfigURL()
/*     */   {
/* 167 */     return this.loginConfigURL;
/*     */   }
/*     */ 
/*     */   public void setConfigURL(URL loginConfigURL)
/*     */   {
/* 175 */     this.loginConfigURL = loginConfigURL;
/*     */   }
/*     */ 
/*     */   public void setConfigResource(String resourceName)
/*     */     throws IOException
/*     */   {
/* 181 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 182 */     this.loginConfigURL = tcl.getResource(resourceName);
/* 183 */     if (this.loginConfigURL == null)
/* 184 */       throw new IOException("Failed to find resource: " + resourceName);
/*     */   }
/*     */ 
/*     */   public void setParentConfig(Configuration parentConfig)
/*     */   {
/* 189 */     this.parentConfig = parentConfig;
/*     */   }
/*     */ 
/*     */   public boolean getValidateDTD()
/*     */   {
/* 196 */     return this.validateDTD;
/*     */   }
/*     */ 
/*     */   public void setValidateDTD(boolean flag)
/*     */   {
/* 203 */     this.validateDTD = flag;
/*     */   }
/*     */ 
/*     */   public void addApplicationPolicy(String appName, ApplicationPolicy aPolicy)
/*     */   {
/* 211 */     SecurityManager sm = System.getSecurityManager();
/* 212 */     if (sm != null)
/* 213 */       sm.checkPermission(REFRESH_PERM);
/* 214 */     this.appConfigs.add(aPolicy);
/* 215 */     handleJASPIDelegation(aPolicy);
/* 216 */     SecurityConfiguration.addApplicationPolicy(aPolicy);
/*     */   }
/*     */ 
/*     */   public void addAppConfig(String appName, AppConfigurationEntry[] entries)
/*     */   {
/* 223 */     SecurityManager sm = System.getSecurityManager();
/* 224 */     if (sm != null)
/* 225 */       sm.checkPermission(REFRESH_PERM);
/* 226 */     AuthenticationInfo authInfo = new AuthenticationInfo(appName);
/* 227 */     authInfo.setAppConfigurationEntry(entries);
/* 228 */     if (log.isTraceEnabled())
/* 229 */       log.trace("addAppConfig(" + appName + "), authInfo=" + authInfo);
/* 230 */     ApplicationPolicy aPolicy = new ApplicationPolicy(appName, authInfo);
/* 231 */     this.appConfigs.add(aPolicy);
/* 232 */     SecurityConfiguration.addApplicationPolicy(aPolicy);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void removeAppConfig(String appName)
/*     */   {
/* 242 */     SecurityManager sm = System.getSecurityManager();
/* 243 */     if (sm != null)
/* 244 */       sm.checkPermission(REFRESH_PERM);
/* 245 */     if (log.isTraceEnabled())
/* 246 */       log.trace("removeAppConfig, appName=" + appName);
/* 247 */     this.appConfigs.remove(appName);
/*     */   }
/*     */ 
/*     */   public ApplicationPolicy getApplicationPolicy(String domainName)
/*     */   {
/* 256 */     if ((this.appConfigs == null) || (this.appConfigs.size() == 0))
/* 257 */       loadConfig();
/* 258 */     ApplicationPolicy aPolicy = this.appConfigs.get(domainName);
/* 259 */     if (aPolicy != null)
/* 260 */       SecurityConfiguration.addApplicationPolicy(aPolicy);
/* 261 */     return aPolicy;
/*     */   }
/*     */ 
/*     */   public boolean removeApplicationPolicy(String appName)
/*     */   {
/* 270 */     SecurityManager sm = System.getSecurityManager();
/* 271 */     if (sm != null)
/* 272 */       sm.checkPermission(REFRESH_PERM);
/* 273 */     if (log.isTraceEnabled())
/* 274 */       log.trace("removeAppConfig, appName=" + appName);
/* 275 */     this.appConfigs.remove(appName);
/* 276 */     return true;
/*     */   }
/*     */ 
/*     */   public BaseAuthenticationInfo getAuthenticationInfo(String domainName)
/*     */   {
/* 288 */     ApplicationPolicy aPolicy = getApplicationPolicy(domainName);
/* 289 */     return aPolicy != null ? aPolicy.getAuthenticationInfo() : null;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void loadConfig()
/*     */   {
/* 303 */     String loginConfig = System.getProperty("java.security.auth.login.config");
/* 304 */     if (loginConfig == null) {
/* 305 */       loginConfig = "login-config.xml";
/*     */     }
/*     */ 
/* 308 */     if (this.loginConfigURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 313 */         this.loginConfigURL = new URL(loginConfig);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/*     */         try
/*     */         {
/* 320 */           setConfigResource(loginConfig);
/*     */         }
/*     */         catch (IOException ignore)
/*     */         {
/* 325 */           File configFile = new File(loginConfig);
/*     */           try
/*     */           {
/* 328 */             setConfigURL(configFile.toURL());
/*     */           }
/*     */           catch (MalformedURLException ignore2)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 337 */     if (this.loginConfigURL == null)
/*     */     {
/* 339 */       log.warn("Failed to find config: " + loginConfig);
/* 340 */       return;
/*     */     }
/*     */ 
/* 343 */     if (log.isTraceEnabled()) {
/* 344 */       log.trace("Begin loadConfig, loginConfigURL=" + this.loginConfigURL);
/*     */     }
/*     */     try
/*     */     {
/* 348 */       loadConfig(this.loginConfigURL);
/* 349 */       if (log.isTraceEnabled())
/* 350 */         log.trace("End loadConfig, loginConfigURL=" + this.loginConfigURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 354 */       log.warn("End loadConfig, failed to load config: " + this.loginConfigURL, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String[] loadConfig(URL config) throws Exception
/*     */   {
/* 360 */     SecurityManager sm = System.getSecurityManager();
/* 361 */     if (sm != null) {
/* 362 */       sm.checkPermission(REFRESH_PERM);
/*     */     }
/* 364 */     ArrayList configNames = new ArrayList();
/* 365 */     log.debug("Try loading config as XML, url=" + config);
/*     */     try
/*     */     {
/* 368 */       loadXMLConfig(config, configNames);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 372 */       log.debug("Failed to load config as XML", e);
/* 373 */       log.debug("Try loading config as Sun format, url=" + config);
/* 374 */       loadSunConfig(config, configNames);
/*     */     }
/* 376 */     String[] names = new String[configNames.size()];
/* 377 */     configNames.toArray(names);
/* 378 */     return names;
/*     */   }
/*     */ 
/*     */   private void handleJASPIDelegation(ApplicationPolicy aPolicy)
/*     */   {
/* 388 */     BaseAuthenticationInfo bai = aPolicy.getAuthenticationInfo();
/* 389 */     if ((bai instanceof JASPIAuthenticationInfo))
/*     */     {
/* 391 */       JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
/* 392 */       LoginModuleStackHolder[] lmsharr = jai.getLoginModuleStackHolder();
/* 393 */       for (LoginModuleStackHolder lmsh : lmsharr)
/*     */       {
/* 395 */         addAppConfig(lmsh.getName(), lmsh.getAppConfigurationEntry());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void loadSunConfig(URL sunConfig, ArrayList configNames)
/*     */     throws Exception
/*     */   {
/* 403 */     InputStream is = sunConfig.openStream();
/* 404 */     if (is == null) {
/* 405 */       throw new IOException("InputStream is null for: " + sunConfig);
/*     */     }
/* 407 */     InputStreamReader configFile = new InputStreamReader(is);
/* 408 */     boolean trace = log.isTraceEnabled();
/* 409 */     SunConfigParser.doParse(configFile, this, trace);
/*     */   }
/*     */ 
/*     */   private void loadXMLConfig(URL loginConfigURL, ArrayList configNames)
/*     */     throws IOException, JBossXBException
/*     */   {
/* 415 */     LoginConfigObjectModelFactory lcomf = new SecurityConfigObjectModelFactory();
/* 416 */     UsersObjectModelFactory uomf = new UsersObjectModelFactory();
/*     */ 
/* 418 */     InputStreamReader xmlReader = loadURL(loginConfigURL);
/* 419 */     Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/* 420 */     unmarshaller.mapFactoryToNamespace(uomf, "http://www.jboss.org/j2ee/schemas/XMLLoginModule");
/* 421 */     Object root = null;
/* 422 */     PolicyConfig config = (PolicyConfig)unmarshaller.unmarshal(xmlReader, lcomf, root);
/* 423 */     Set cnames = config.getConfigNames();
/* 424 */     configNames.addAll(cnames);
/* 425 */     this.appConfigs.copy(config);
/*     */ 
/* 427 */     for (String cname : cnames)
/*     */     {
/* 429 */       ApplicationPolicy ap = config.get(cname);
/* 430 */       SecurityConfiguration.addApplicationPolicy(ap);
/* 431 */       handleJASPIDelegation(ap);
/*     */     }
/*     */   }
/*     */ 
/*     */   private InputStreamReader loadURL(URL configURL)
/*     */     throws IOException
/*     */   {
/* 438 */     InputStream is = configURL.openStream();
/* 439 */     if (is == null)
/* 440 */       throw new IOException("Failed to obtain InputStream from url: " + configURL);
/* 441 */     InputStreamReader xmlReader = new InputStreamReader(is);
/* 442 */     return xmlReader;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.XMLLoginConfigImpl
 * JD-Core Version:    0.6.0
 */