/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.security.auth.container.config.AuthModuleEntry;
/*     */ 
/*     */ public class JASPIAuthenticationInfo extends BaseAuthenticationInfo
/*     */ {
/*  42 */   Map loginModuleStack = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   public JASPIAuthenticationInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JASPIAuthenticationInfo(String name)
/*     */   {
/*  51 */     super(name);
/*     */   }
/*     */ 
/*     */   public void add(LoginModuleStackHolder lmsHolder)
/*     */   {
/*  56 */     this.loginModuleStack.put(lmsHolder.getName(), lmsHolder);
/*     */   }
/*     */ 
/*     */   public void add(AuthModuleEntry ame)
/*     */   {
/*  61 */     this.moduleEntries.add(ame);
/*     */   }
/*     */ 
/*     */   public AuthModuleEntry[] getAuthModuleEntry()
/*     */   {
/*  66 */     AuthModuleEntry[] entries = new AuthModuleEntry[this.moduleEntries.size()];
/*  67 */     this.moduleEntries.toArray(entries);
/*  68 */     return entries;
/*     */   }
/*     */ 
/*     */   public LoginModuleStackHolder getLoginModuleStackHolder(String name)
/*     */   {
/*  73 */     LoginModuleStackHolder info = (LoginModuleStackHolder)this.loginModuleStack.get(name);
/*  74 */     return info;
/*     */   }
/*     */ 
/*     */   public LoginModuleStackHolder[] getLoginModuleStackHolder()
/*     */   {
/*  79 */     ArrayList alist = new ArrayList(this.loginModuleStack.values());
/*  80 */     LoginModuleStackHolder[] lmshArr = new LoginModuleStackHolder[alist.size()];
/*  81 */     alist.toArray(lmshArr);
/*  82 */     return lmshArr;
/*     */   }
/*     */ 
/*     */   public LoginModuleStackHolder removeLoginModuleStackHolder(String name)
/*     */   {
/*  88 */     LoginModuleStackHolder info = (LoginModuleStackHolder)this.loginModuleStack.remove(name);
/*  89 */     return info;
/*     */   }
/*     */ 
/*     */   public void copy(JASPIAuthenticationInfo pc)
/*     */   {
/*  94 */     this.loginModuleStack.putAll(pc.loginModuleStack);
/*  95 */     this.moduleEntries.addAll(pc.moduleEntries);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 100 */     StringBuffer buffer = new StringBuffer("AuthModuleEntry[]:\n");
/* 101 */     for (int i = 0; i < this.moduleEntries.size(); i++)
/*     */     {
/* 103 */       AuthModuleEntry entry = (AuthModuleEntry)this.moduleEntries.get(i);
/* 104 */       buffer.append("[" + i + "]");
/* 105 */       buffer.append("\nAuthModule Class: " + entry.getAuthModuleName());
/* 106 */       buffer.append("\nOptions:");
/* 107 */       Map options = entry.getOptions();
/* 108 */       Iterator iter = options.entrySet().iterator();
/* 109 */       while (iter.hasNext())
/*     */       {
/* 111 */         Map.Entry e = (Map.Entry)iter.next();
/* 112 */         buffer.append("name=" + e.getKey());
/* 113 */         buffer.append(", value=" + e.getValue());
/* 114 */         buffer.append("\n");
/*     */       }
/*     */     }
/* 117 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.JASPIAuthenticationInfo
 * JD-Core Version:    0.6.0
 */