/*    */ package org.jboss.security.auth.certs;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.security.cert.X509Certificate;
/*    */ import org.jboss.security.CertificatePrincipal;
/*    */ import org.jboss.security.SimplePrincipal;
/*    */ 
/*    */ public class SubjectCNMapping
/*    */   implements CertificatePrincipal
/*    */ {
/*    */   public Principal toPrinicipal(X509Certificate[] certs)
/*    */   {
/* 46 */     Principal cn = null;
/* 47 */     Principal subject = certs[0].getSubjectDN();
/*    */ 
/* 49 */     String dn = subject.getName().toLowerCase();
/* 50 */     int index = dn.indexOf("cn=");
/* 51 */     if (index >= 0)
/*    */     {
/* 53 */       int comma = dn.indexOf(',', index);
/* 54 */       if (comma < 0)
/* 55 */         comma = dn.length();
/* 56 */       String name = dn.substring(index + 3, comma);
/* 57 */       cn = new SimplePrincipal(name);
/*    */     }
/*    */     else
/*    */     {
/* 62 */       cn = subject;
/*    */     }
/* 64 */     return cn;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.certs.SubjectCNMapping
 * JD-Core Version:    0.6.0
 */