/*    */ package org.jboss.security.auth.callback;
/*    */ 
/*    */ import javax.security.auth.callback.Callback;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.auth.callback.NameCallback;
/*    */ import javax.security.auth.callback.PasswordCallback;
/*    */ import javax.security.auth.callback.UnsupportedCallbackException;
/*    */ 
/*    */ public class UsernamePasswordHandler
/*    */   implements CallbackHandler
/*    */ {
/*    */   private transient String username;
/*    */   private transient char[] password;
/*    */   private transient Object credential;
/*    */ 
/*    */   public UsernamePasswordHandler(String username, char[] password)
/*    */   {
/* 52 */     this.username = username;
/* 53 */     this.password = password;
/* 54 */     this.credential = password;
/*    */   }
/*    */ 
/*    */   public UsernamePasswordHandler(String username, Object credential)
/*    */   {
/* 59 */     this.username = username;
/* 60 */     this.credential = credential;
/*    */   }
/*    */ 
/*    */   public void handle(Callback[] callbacks)
/*    */     throws UnsupportedCallbackException
/*    */   {
/* 72 */     for (int i = 0; i < callbacks.length; i++)
/*    */     {
/* 74 */       Callback c = callbacks[i];
/* 75 */       if ((c instanceof NameCallback))
/*    */       {
/* 77 */         NameCallback nc = (NameCallback)c;
/* 78 */         nc.setName(this.username);
/*    */       }
/* 80 */       else if ((c instanceof PasswordCallback))
/*    */       {
/* 82 */         PasswordCallback pc = (PasswordCallback)c;
/* 83 */         if (this.password == null)
/*    */         {
/* 86 */           if (this.credential != null)
/*    */           {
/* 88 */             String tmp = this.credential.toString();
/* 89 */             this.password = tmp.toCharArray();
/*    */           }
/*    */         }
/* 92 */         pc.setPassword(this.password);
/*    */       }
/* 94 */       else if ((c instanceof ObjectCallback))
/*    */       {
/* 96 */         ObjectCallback oc = (ObjectCallback)c;
/* 97 */         oc.setCredential(this.credential);
/*    */       }
/*    */       else
/*    */       {
/* 101 */         throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.callback.UsernamePasswordHandler
 * JD-Core Version:    0.6.0
 */