/*     */ package org.jboss.security.auth.callback;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.callback.NameCallback;
/*     */ import javax.security.auth.callback.PasswordCallback;
/*     */ import javax.security.auth.callback.UnsupportedCallbackException;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ 
/*     */ public class SecurityAssociationHandler
/*     */   implements CallbackHandler, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient Principal principal;
/*     */   private transient Object credential;
/*     */ 
/*     */   public SecurityAssociationHandler()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SecurityAssociationHandler(Principal principal, Object credential)
/*     */   {
/*  62 */     this.principal = principal;
/*  63 */     this.credential = credential;
/*     */   }
/*     */ 
/*     */   public void setSecurityInfo(Principal principal, Object credential)
/*     */   {
/*  68 */     this.principal = principal;
/*  69 */     this.credential = credential;
/*     */   }
/*     */ 
/*     */   public void handle(Callback[] callbacks)
/*     */     throws UnsupportedCallbackException, IOException
/*     */   {
/*  88 */     for (int i = 0; i < callbacks.length; i++)
/*     */     {
/*  90 */       Callback c = callbacks[i];
/*  91 */       if ((c instanceof SecurityAssociationCallback))
/*     */       {
/*  93 */         SecurityAssociationCallback sac = (SecurityAssociationCallback)c;
/*  94 */         sac.setPrincipal(this.principal);
/*  95 */         sac.setCredential(this.credential);
/*     */       }
/*  97 */       else if ((c instanceof ObjectCallback))
/*     */       {
/*  99 */         ObjectCallback oc = (ObjectCallback)c;
/* 100 */         oc.setCredential(this.credential);
/*     */       }
/* 102 */       else if ((c instanceof NameCallback))
/*     */       {
/* 104 */         NameCallback nc = (NameCallback)c;
/* 105 */         if (this.principal != null)
/* 106 */           nc.setName(this.principal.getName());
/*     */       }
/* 108 */       else if ((c instanceof PasswordCallback))
/*     */       {
/* 110 */         PasswordCallback pc = (PasswordCallback)c;
/* 111 */         char[] password = getPassword();
/* 112 */         if (password != null) {
/* 113 */           pc.setPassword(password);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 120 */           CallbackHandler handler = SecurityActions.getContextCallbackHandler();
/* 121 */           if (handler != null)
/*     */           {
/* 123 */             Callback[] unknown = { c };
/* 124 */             handler.handle(unknown);
/* 125 */             return;
/*     */           }
/*     */         }
/*     */         catch (PolicyContextException e)
/*     */         {
/*     */         }
/* 131 */         throw new UnsupportedCallbackException(c, "Unrecognized Callback");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private char[] getPassword()
/*     */   {
/* 147 */     char[] password = null;
/* 148 */     if ((this.credential instanceof char[]))
/*     */     {
/* 150 */       password = (char[])(char[])this.credential;
/*     */     }
/* 152 */     else if ((this.credential instanceof String))
/*     */     {
/* 154 */       String s = (String)this.credential;
/* 155 */       password = s.toCharArray();
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 161 */         Class[] types = new Class[0];
/* 162 */         Method m = this.credential.getClass().getMethod("toCharArray", types);
/* 163 */         Object[] args = new Object[0];
/* 164 */         password = (char[])(char[])m.invoke(this.credential, args);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 168 */         if (this.credential != null)
/*     */         {
/* 170 */           String s = this.credential.toString();
/* 171 */           password = s.toCharArray();
/*     */         }
/*     */       }
/*     */     }
/* 175 */     return password;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.callback.SecurityAssociationHandler
 * JD-Core Version:    0.6.0
 */