/*     */ package org.jboss.security.audit;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ 
/*     */ public class AuditEvent
/*     */ {
/*  22 */   private String auditLevel = "Info";
/*     */ 
/*  24 */   private Map<String, Object> contextMap = new HashMap();
/*     */ 
/*  26 */   private Exception underlyingException = null;
/*     */ 
/*     */   public AuditEvent(String level)
/*     */   {
/*  30 */     this.auditLevel = level;
/*     */   }
/*     */ 
/*     */   public AuditEvent(String level, Map<String, Object> map)
/*     */   {
/*  35 */     this(level);
/*  36 */     this.contextMap = map;
/*     */   }
/*     */ 
/*     */   public AuditEvent(String level, Map<String, Object> map, Exception ex)
/*     */   {
/*  41 */     this(level, map);
/*  42 */     this.underlyingException = ex;
/*     */   }
/*     */ 
/*     */   public String getAuditLevel()
/*     */   {
/*  51 */     return this.auditLevel;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getContextMap()
/*     */   {
/*  60 */     return this.contextMap;
/*     */   }
/*     */ 
/*     */   public void setContextMap(Map<String, Object> cmap)
/*     */   {
/*  69 */     this.contextMap = cmap;
/*     */   }
/*     */ 
/*     */   public Exception getUnderlyingException()
/*     */   {
/*  78 */     return this.underlyingException;
/*     */   }
/*     */ 
/*     */   public void setUnderlyingException(Exception underlyingException)
/*     */   {
/*  87 */     this.underlyingException = underlyingException;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  92 */     StringBuilder sbu = new StringBuilder();
/*  93 */     sbu.append("[").append(this.auditLevel).append("]");
/*  94 */     sbu.append(dissectContextMap());
/*  95 */     return sbu.toString();
/*     */   }
/*     */ 
/*     */   private String dissectContextMap()
/*     */   {
/* 106 */     StringBuilder sbu = new StringBuilder();
/* 107 */     if (this.contextMap != null)
/*     */     {
/* 109 */       for (String key : this.contextMap.keySet())
/*     */       {
/* 111 */         sbu.append(key).append("=");
/* 112 */         Object obj = this.contextMap.get(key);
/* 113 */         if ((obj instanceof Object[]))
/*     */         {
/* 115 */           Object[] arr = (Object[])(Object[])obj;
/* 116 */           obj = Arrays.asList(arr);
/*     */         }
/*     */         Iterator i$;
/* 118 */         if ((obj instanceof Collection))
/*     */         {
/* 120 */           Collection coll = (Collection)obj;
/* 121 */           for (i$ = coll.iterator(); i$.hasNext(); ) { Object o = i$.next();
/*     */ 
/* 123 */             sbu.append(o).append(";"); }
/*     */         }
/*     */         else
/*     */         {
/* 127 */           sbu.append(obj).append(";");
/*     */         }
/*     */       }
/*     */     }
/* 130 */     return sbu.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.audit.AuditEvent
 * JD-Core Version:    0.6.0
 */