/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javax.security.auth.Subject;
/*     */ 
/*     */ public class SubjectSecurityProxy extends AbstractSecurityProxy
/*     */ {
/*     */   private SubjectSecurityManager subjectSecurityManager;
/*     */ 
/*     */   SubjectSecurityProxy(Object delegate)
/*     */   {
/*  54 */     super(delegate);
/*     */   }
/*     */ 
/*     */   public void init(Class beanHome, Class beanRemote, Object securityMgr)
/*     */     throws InstantiationException
/*     */   {
/*  60 */     init(beanHome, beanRemote, null, null, securityMgr);
/*     */   }
/*     */ 
/*     */   public void init(Class beanHome, Class beanRemote, Class beanLocalHome, Class beanLocal, Object securityMgr)
/*     */     throws InstantiationException
/*     */   {
/*  67 */     if (!(securityMgr instanceof SubjectSecurityManager))
/*     */     {
/*  69 */       String msg = "SubjectSecurityProxy requires a SubjectSecurityManager instance, securityMgr=" + securityMgr;
/*     */ 
/*  71 */       throw new InstantiationException(msg);
/*     */     }
/*  73 */     this.subjectSecurityManager = ((SubjectSecurityManager)securityMgr);
/*  74 */     super.init(beanHome, beanRemote, beanLocalHome, beanLocal, securityMgr);
/*     */   }
/*     */ 
/*     */   protected void invokeHomeOnDelegate(Method m, Object[] args, Object delegate)
/*     */     throws SecurityException
/*     */   {
/*  80 */     Subject subject = this.subjectSecurityManager.getActiveSubject();
/*  81 */     if (subject == null) {
/*  82 */       throw new SecurityException("No subject associated with secure proxy");
/*     */     }
/*     */     try
/*     */     {
/*  86 */       Subject.doAsPrivileged(subject, new PrivilegedExceptionAction(m, delegate, args)
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/*  90 */           this.val$m.invoke(this.val$delegate, this.val$args);
/*  91 */           return null;
/*     */         }
/*     */       }
/*     */       , null);
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/*  99 */       Throwable t = e.getException();
/* 100 */       if ((t instanceof InvocationTargetException))
/*     */       {
/* 102 */         t = ((InvocationTargetException)t).getTargetException();
/*     */       }
/* 104 */       else if ((t instanceof UndeclaredThrowableException))
/*     */       {
/* 106 */         t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
/*     */       }
/* 108 */       if ((t instanceof SecurityException))
/* 109 */         throw ((SecurityException)t);
/* 110 */       t.printStackTrace();
/* 111 */       throw new SecurityException("Unexpected error during security proxy execution:" + t.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void invokeOnDelegate(Method m, Object[] args, Object delegate)
/*     */     throws Exception
/*     */   {
/* 118 */     Subject subject = this.subjectSecurityManager.getActiveSubject();
/* 119 */     if (subject == null) {
/* 120 */       throw new SecurityException("No subject associated with secure proxy");
/*     */     }
/*     */     try
/*     */     {
/* 124 */       Subject.doAsPrivileged(subject, new PrivilegedExceptionAction(m, delegate, args)
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 128 */           this.val$m.invoke(this.val$delegate, this.val$args);
/* 129 */           return null;
/*     */         }
/*     */       }
/*     */       , null);
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/* 137 */       Throwable t = e.getException();
/* 138 */       if ((t instanceof InvocationTargetException))
/*     */       {
/* 141 */         InvocationTargetException ex = (InvocationTargetException)t;
/* 142 */         t = ex.getTargetException();
/* 143 */         throw ((Exception)t);
/*     */       }
/* 145 */       if ((t instanceof UndeclaredThrowableException))
/*     */       {
/* 147 */         t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
/*     */       }
/* 149 */       if ((t instanceof SecurityException))
/* 150 */         throw ((SecurityException)t);
/* 151 */       throw new SecurityException("Unexpected error during security proxy execution:" + t.getMessage());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SubjectSecurityProxy
 * JD-Core Version:    0.6.0
 */