/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class SimpleGroup extends SimplePrincipal
/*     */   implements Group, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = 6051859639378507247L;
/*     */   private HashMap members;
/*     */ 
/*     */   public SimpleGroup(String groupName)
/*     */   {
/*  48 */     super(groupName);
/*  49 */     this.members = new HashMap(3);
/*     */   }
/*     */ 
/*     */   public boolean addMember(Principal user)
/*     */   {
/*  59 */     boolean isMember = this.members.containsKey(user);
/*  60 */     if (!isMember)
/*  61 */       this.members.put(user, user);
/*  62 */     return !isMember;
/*     */   }
/*     */ 
/*     */   public boolean isMember(Principal member)
/*     */   {
/*  78 */     boolean isMember = this.members.containsKey(member);
/*  79 */     if (!isMember)
/*     */     {
/*  81 */       isMember = member instanceof AnybodyPrincipal;
/*  82 */       if (!isMember)
/*     */       {
/*  84 */         if ((member instanceof NobodyPrincipal))
/*  85 */           return false;
/*     */       }
/*     */     }
/*  88 */     if (!isMember)
/*     */     {
/*  90 */       Collection values = this.members.values();
/*  91 */       Iterator iter = values.iterator();
/*  92 */       while ((!isMember) && (iter.hasNext()))
/*     */       {
/*  94 */         Object next = iter.next();
/*  95 */         if ((next instanceof Cloneable))
/*     */         {
/*  97 */           Group group = (Cloneable)next;
/*  98 */           isMember = group.isMember(member);
/*     */         }
/*     */       }
/*     */     }
/* 102 */     return isMember;
/*     */   }
/*     */ 
/*     */   public Enumeration<Principal> members()
/*     */   {
/* 112 */     return Collections.enumeration(this.members.values());
/*     */   }
/*     */ 
/*     */   public boolean removeMember(Principal user)
/*     */   {
/* 122 */     Object prev = this.members.remove(user);
/* 123 */     return prev != null;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 128 */     StringBuffer tmp = new StringBuffer(getName());
/* 129 */     tmp.append("(members:");
/* 130 */     Iterator iter = this.members.keySet().iterator();
/* 131 */     while (iter.hasNext())
/*     */     {
/* 133 */       tmp.append(iter.next());
/* 134 */       tmp.append(',');
/*     */     }
/* 136 */     tmp.setCharAt(tmp.length() - 1, ')');
/* 137 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public synchronized Object clone() throws CloneNotSupportedException
/*     */   {
/* 142 */     SimpleGroup clone = (SimpleGroup)super.clone();
/* 143 */     if (clone != null)
/* 144 */       clone.members = ((HashMap)this.members.clone());
/* 145 */     return clone;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SimpleGroup
 * JD-Core Version:    0.6.0
 */