/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.security.Principal;
/*     */ import javax.security.auth.Subject;
/*     */ 
/*     */ public class SecurityContextFactory
/*     */ {
/*  39 */   private static String defaultFQN = "org.jboss.security.plugins.JBossSecurityContext";
/*     */ 
/*  41 */   private static String defaultUtilClass = "org.jboss.security.plugins.JBossSecurityContextUtil";
/*     */ 
/*     */   public static SecurityContext createSecurityContext(String securityDomain)
/*     */     throws Exception
/*     */   {
/*  51 */     return createSecurityContext(securityDomain, defaultFQN);
/*     */   }
/*     */ 
/*     */   public static SecurityContext createSecurityContext(String securityDomain, String fqnClass)
/*     */     throws Exception
/*     */   {
/*  64 */     if (securityDomain == null)
/*  65 */       throw new IllegalArgumentException("securityDomain is null");
/*  66 */     if (fqnClass == null)
/*  67 */       throw new IllegalArgumentException("fqnClass is null");
/*  68 */     Class clazz = getContextClass(fqnClass);
/*     */ 
/*  70 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class });
/*  71 */     return (SecurityContext)ctr.newInstance(new Object[] { securityDomain });
/*     */   }
/*     */ 
/*     */   public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain)
/*     */     throws Exception
/*     */   {
/*  87 */     SecurityContext jsc = createSecurityContext(securityDomain);
/*  88 */     jsc.getUtil().createSubjectInfo(p, cred, s);
/*  89 */     return jsc;
/*     */   }
/*     */ 
/*     */   public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain, String fqnClass)
/*     */     throws Exception
/*     */   {
/* 107 */     SecurityContext sc = createSecurityContext(securityDomain, fqnClass);
/* 108 */     sc.getUtil().createSubjectInfo(p, cred, s);
/* 109 */     return sc;
/*     */   }
/*     */ 
/*     */   public static SecurityContextUtil createUtil(SecurityContext sc)
/*     */     throws Exception
/*     */   {
/* 118 */     Class clazz = getContextClass(defaultUtilClass);
/*     */ 
/* 120 */     Constructor ctr = clazz.getConstructor(new Class[] { SecurityContext.class });
/* 121 */     return (SecurityContextUtil)ctr.newInstance(new Object[] { sc });
/*     */   }
/*     */ 
/*     */   public static SecurityContextUtil createUtil(SecurityContext sc, String utilFQN)
/*     */     throws Exception
/*     */   {
/* 132 */     Class clazz = getContextClass(utilFQN);
/*     */ 
/* 134 */     Constructor ctr = clazz.getConstructor(new Class[] { SecurityContext.class });
/* 135 */     return (SecurityContextUtil)ctr.newInstance(new Object[] { sc });
/*     */   }
/*     */ 
/*     */   private static Class<SecurityContext> getContextClass(String className)
/*     */     throws Exception
/*     */   {
/* 141 */     ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
/* 142 */     return tcl.loadClass(className);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityContextFactory
 * JD-Core Version:    0.6.0
 */