/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.LinkedList;
/*     */ 
/*     */ public class NestablePrincipal extends SimplePrincipal
/*     */   implements Group, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = 4628473920470890923L;
/*     */   private LinkedList<Principal> principalStack;
/*     */ 
/*     */   public NestablePrincipal(String name)
/*     */   {
/*  60 */     super(name);
/*  61 */     this.principalStack = new LinkedList();
/*     */   }
/*     */ 
/*     */   public Enumeration<Principal> members()
/*     */   {
/*  70 */     return new IndexEnumeration();
/*     */   }
/*     */ 
/*     */   public boolean removeMember(Principal user)
/*     */   {
/*  81 */     return this.principalStack.remove(user);
/*     */   }
/*     */ 
/*     */   public boolean addMember(Principal user)
/*     */   {
/*  90 */     this.principalStack.addFirst(user);
/*  91 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isMember(Principal member)
/*     */   {
/* 106 */     if (this.principalStack.size() == 0) {
/* 107 */       return false;
/*     */     }
/* 109 */     Object activePrincipal = this.principalStack.getFirst();
/* 110 */     return member.equals(activePrincipal);
/*     */   }
/*     */ 
/*     */   public synchronized Object clone() throws CloneNotSupportedException
/*     */   {
/* 115 */     NestablePrincipal clone = (NestablePrincipal)super.clone();
/* 116 */     if (clone != null)
/* 117 */       clone.principalStack = ((LinkedList)this.principalStack.clone());
/* 118 */     return clone;
/*     */   }
/*     */ 
/*     */   private class IndexEnumeration
/*     */     implements Enumeration
/*     */   {
/*     */     private boolean hasMoreElements;
/*     */ 
/*     */     IndexEnumeration()
/*     */     {
/* 129 */       this.hasMoreElements = (NestablePrincipal.this.principalStack.size() > 0);
/*     */     }
/*     */ 
/*     */     public boolean hasMoreElements() {
/* 133 */       return this.hasMoreElements;
/*     */     }
/*     */ 
/*     */     public Object nextElement() {
/* 137 */       Object next = NestablePrincipal.this.principalStack.getFirst();
/* 138 */       this.hasMoreElements = false;
/* 139 */       return next;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.NestablePrincipal
 * JD-Core Version:    0.6.0
 */