/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.LinkedList;
/*     */ 
/*     */ public class NestableGroup extends SimplePrincipal
/*     */   implements Group, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = 1752783303935807441L;
/*     */   private LinkedList<Principal> rolesStack;
/*     */ 
/*     */   public NestableGroup(String name)
/*     */   {
/*  59 */     super(name);
/*  60 */     this.rolesStack = new LinkedList();
/*     */   }
/*     */ 
/*     */   public Enumeration<Principal> members()
/*     */   {
/*  69 */     return new IndexEnumeration();
/*     */   }
/*     */ 
/*     */   public boolean removeMember(Principal user)
/*     */   {
/*  80 */     return this.rolesStack.remove(user);
/*     */   }
/*     */ 
/*     */   public boolean addMember(Principal group)
/*     */     throws IllegalArgumentException
/*     */   {
/*  92 */     if (!(group instanceof Cloneable)) {
/*  93 */       throw new IllegalArgumentException("The addMember argument must be a Group");
/*     */     }
/*  95 */     this.rolesStack.addFirst(group);
/*  96 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isMember(Principal member)
/*     */   {
/* 109 */     if (this.rolesStack.size() == 0)
/* 110 */       return false;
/* 111 */     Group activeGroup = (Cloneable)this.rolesStack.getFirst();
/* 112 */     boolean isMember = activeGroup.isMember(member);
/* 113 */     return isMember;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 118 */     StringBuffer tmp = new StringBuffer(getName());
/* 119 */     tmp.append("(members:");
/* 120 */     Enumeration iter = members();
/* 121 */     while (iter.hasMoreElements())
/*     */     {
/* 123 */       tmp.append(iter.nextElement());
/* 124 */       tmp.append(',');
/*     */     }
/* 126 */     tmp.setCharAt(tmp.length() - 1, ')');
/* 127 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public synchronized Object clone() throws CloneNotSupportedException
/*     */   {
/* 132 */     NestableGroup clone = (NestableGroup)super.clone();
/* 133 */     if (clone != null)
/* 134 */       clone.rolesStack = ((LinkedList)this.rolesStack.clone());
/* 135 */     return clone;
/*     */   }
/*     */ 
/*     */   private class IndexEnumeration
/*     */     implements Enumeration
/*     */   {
/*     */     private Enumeration iter;
/*     */ 
/*     */     IndexEnumeration()
/*     */     {
/*     */       Group grp;
/* 146 */       if (NestableGroup.this.rolesStack.size() > 0)
/*     */       {
/* 148 */         grp = (Group)NestableGroup.this.rolesStack.get(0);
/* 149 */         this.iter = grp.members();
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean hasMoreElements() {
/* 154 */       boolean hasMore = (this.iter != null) && (this.iter.hasMoreElements());
/* 155 */       return hasMore;
/*     */     }
/*     */ 
/*     */     public Object nextElement() {
/* 159 */       Object next = null;
/* 160 */       if (this.iter != null)
/* 161 */         next = this.iter.nextElement();
/* 162 */       return next;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.NestableGroup
 * JD-Core Version:    0.6.0
 */