package org.jboss.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.EntitlementHolder;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;

public abstract interface AuthorizationManager extends BaseSecurityManager
{
  public abstract int authorize(Resource paramResource)
    throws AuthorizationException;

  public abstract EntitlementHolder<?> entitlements(Resource paramResource, Identity paramIdentity)
    throws AuthorizationException;

  public abstract boolean doesUserHaveRole(Principal paramPrincipal, Set<Principal> paramSet);

  public abstract Set<Principal> getUserRoles(Principal paramPrincipal);

  public abstract Group getTargetRoles(Principal paramPrincipal, Map<String, Object> paramMap);
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.AuthorizationManager
 * JD-Core Version:    0.6.0
 */