/*    */ package org.jboss.resource.statistic.pool;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import java.util.Iterator;
/*    */ import org.jboss.resource.statistic.JBossStatistics;
/*    */ import org.jboss.resource.statistic.formatter.StatisticsFormatter;
/*    */ 
/*    */ public class JBossDefaultSubPoolStatisticFormatter
/*    */   implements StatisticsFormatter
/*    */ {
/*    */   private static final String POOL_SEPERATOR = "------------------------------------------------------";
/*    */ 
/*    */   public Object formatSubPoolStatistics(Collection subPoolStatistics)
/*    */   {
/* 44 */     StringBuffer statBuff = formatHeader(subPoolStatistics.size());
/*    */ 
/* 46 */     for (Iterator iter = subPoolStatistics.iterator(); iter.hasNext(); )
/*    */     {
/* 48 */       JBossSubPoolStatistics stat = (JBossSubPoolStatistics)iter.next();
/* 49 */       statBuff.append(stat);
/* 50 */       statBuff.append("\n");
/* 51 */       statBuff.append("------------------------------------------------------");
/* 52 */       statBuff.append("\n\n");
/*    */     }
/*    */ 
/* 56 */     return statBuff.toString();
/*    */   }
/*    */ 
/*    */   public Object formatSubPoolStatistics(ManagedConnectionPoolStatistics stats)
/*    */   {
/* 62 */     return formatSubPoolStatistics(stats.getSubPools());
/*    */   }
/*    */ 
/*    */   private static StringBuffer formatHeader(int count)
/*    */   {
/* 69 */     StringBuffer headerBuff = new StringBuffer();
/* 70 */     headerBuff.append("Sub Pool Statistics: \n");
/* 71 */     headerBuff.append("Sub Pool Count: " + count + "\n");
/* 72 */     headerBuff.append("------------------------------------------------------");
/* 73 */     headerBuff.append("\n\n");
/*    */ 
/* 75 */     return headerBuff;
/*    */   }
/*    */ 
/*    */   public Object formatStatistics(JBossStatistics stats)
/*    */   {
/* 82 */     if (!(stats instanceof ManagedConnectionPoolStatistics))
/*    */     {
/* 84 */       throw new IllegalArgumentException("Error: invalid statistics implementaiton for formatter.");
/*    */     }
/*    */ 
/* 88 */     ManagedConnectionPoolStatistics poolStats = (ManagedConnectionPoolStatistics)stats;
/* 89 */     return formatSubPoolStatistics(poolStats);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.statistic.pool.JBossDefaultSubPoolStatisticFormatter
 * JD-Core Version:    0.6.0
 */