/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ 
/*     */ class SubjectActions
/*     */ {
/*     */   static void addCredentials(Subject subject, PasswordCredential cred)
/*     */   {
/* 137 */     AddCredentialsAction action = new AddCredentialsAction(subject, cred);
/* 138 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void addPrincipals(Subject subject, Principal p)
/*     */   {
/* 143 */     AddPrincipalsAction action = new AddPrincipalsAction(subject, p);
/* 144 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void removeCredentials(Subject subject, ManagedConnectionFactory mcf)
/*     */   {
/* 149 */     RemoveCredentialsAction action = new RemoveCredentialsAction(subject, mcf);
/* 150 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void addRoles(Subject subject, Set runAsRoles)
/*     */   {
/* 155 */     if (System.getSecurityManager() != null)
/*     */     {
/* 157 */       AddRolesActions.PRIVILEGED.addRoles(subject, runAsRoles);
/*     */     }
/*     */     else
/*     */     {
/* 161 */       AddRolesActions.NON_PRIVILEGED.addRoles(subject, runAsRoles);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Group addSubjectRoles(Subject theSubject, Set roles)
/*     */   {
/* 167 */     Set subjectGroups = theSubject.getPrincipals(Group.class);
/* 168 */     Iterator iter = subjectGroups.iterator();
/* 169 */     Group roleGrp = null;
/* 170 */     while (iter.hasNext())
/*     */     {
/* 172 */       Group grp = (Group)iter.next();
/* 173 */       String name = grp.getName();
/* 174 */       if (name.equals("Roles")) {
/* 175 */         roleGrp = grp;
/*     */       }
/*     */     }
/*     */ 
/* 179 */     if (roleGrp == null)
/*     */     {
/* 181 */       roleGrp = new SimpleGroup("Roles");
/* 182 */       theSubject.getPrincipals().add(roleGrp);
/*     */     }
/*     */ 
/* 185 */     iter = roles.iterator();
/* 186 */     while (iter.hasNext())
/*     */     {
/* 188 */       Principal role = (Principal)iter.next();
/* 189 */       roleGrp.addMember(role);
/*     */     }
/* 191 */     return roleGrp;
/*     */   }
/*     */ 
/*     */   static class RemoveCredentialsAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject subject;
/*     */     ManagedConnectionFactory mcf;
/*     */ 
/*     */     RemoveCredentialsAction(Subject subject, ManagedConnectionFactory mcf)
/*     */     {
/* 114 */       this.subject = subject;
/* 115 */       this.mcf = mcf;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 120 */       Iterator i = this.subject.getPrivateCredentials().iterator();
/* 121 */       while (i.hasNext())
/*     */       {
/* 123 */         Object o = i.next();
/* 124 */         if ((o instanceof PasswordCredential))
/*     */         {
/* 126 */           PasswordCredential pc = (PasswordCredential)o;
/* 127 */           if (pc.getManagedConnectionFactory() == this.mcf)
/* 128 */             i.remove();
/*     */         }
/*     */       }
/* 131 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class AddPrincipalsAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject subject;
/*     */     Principal p;
/*     */ 
/*     */     AddPrincipalsAction(Subject subject, Principal p)
/*     */     {
/*  96 */       this.subject = subject;
/*  97 */       this.p = p;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/* 102 */       this.subject.getPrincipals().add(this.p);
/* 103 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class AddCredentialsAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Subject subject;
/*     */     PasswordCredential cred;
/*     */ 
/*     */     AddCredentialsAction(Subject subject, PasswordCredential cred)
/*     */     {
/*  78 */       this.subject = subject;
/*  79 */       this.cred = cred;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*  84 */       this.subject.getPrivateCredentials().add(this.cred);
/*  85 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface AddRolesActions
/*     */   {
/*  45 */     public static final AddRolesActions PRIVILEGED = new AddRolesActions()
/*     */     {
/*     */       public void addRoles(Subject subject, Set roles)
/*     */       {
/*  49 */         AccessController.doPrivileged(new PrivilegedAction(subject, roles)
/*     */         {
/*     */           public Object run()
/*     */           {
/*  53 */             SubjectActions.access$000(this.val$subject, this.val$roles);
/*  54 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*  45 */     };
/*     */ 
/*  60 */     public static final AddRolesActions NON_PRIVILEGED = new AddRolesActions()
/*     */     {
/*     */       public void addRoles(Subject subject, Set roles)
/*     */       {
/*  64 */         SubjectActions.access$000(subject, roles);
/*     */       }
/*  60 */     };
/*     */ 
/*     */     public abstract void addRoles(Subject paramSubject, Set paramSet);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.SubjectActions
 * JD-Core Version:    0.6.0
 */