/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class JaasSecurityDomainIdentityLoginModule extends AbstractPasswordCredentialLoginModule
/*     */ {
/*  82 */   private static final Logger log = Logger.getLogger(JaasSecurityDomainIdentityLoginModule.class);
/*     */   private String username;
/*     */   private String password;
/*     */   private ObjectName jaasSecurityDomain;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  91 */     super.initialize(subject, handler, sharedState, options);
/*     */ 
/*  93 */     this.username = ((String)options.get("username"));
/*  94 */     if (this.username == null)
/*     */     {
/*  97 */       this.username = ((String)options.get("userName"));
/*  98 */       if (this.username == null)
/*     */       {
/* 100 */         throw new IllegalArgumentException("The user name is a required option");
/*     */       }
/*     */     }
/*     */ 
/* 104 */     this.password = ((String)options.get("password"));
/* 105 */     if (this.password == null)
/*     */     {
/* 107 */       throw new IllegalArgumentException("The password is a required option");
/*     */     }
/*     */ 
/* 110 */     String name = (String)options.get("jaasSecurityDomain");
/* 111 */     if (name == null)
/*     */     {
/* 113 */       throw new IllegalArgumentException("The jaasSecurityDomain is a required option");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 118 */       this.jaasSecurityDomain = new ObjectName(name);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 122 */       throw new IllegalArgumentException("Invalid jaasSecurityDomain: " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean login() throws LoginException
/*     */   {
/* 128 */     log.trace("login called");
/* 129 */     if (super.login() == true) {
/* 130 */       return true;
/*     */     }
/* 132 */     this.loginOk = true;
/* 133 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean commit() throws LoginException
/*     */   {
/* 138 */     Principal principal = new SimplePrincipal(this.username);
/* 139 */     SubjectActions.addPrincipals(this.subject, principal);
/* 140 */     this.sharedState.put("javax.security.auth.login.name", this.username);
/*     */     try
/*     */     {
/* 144 */       char[] decodedPassword = DecodeAction.decode(this.password, this.jaasSecurityDomain, getServer());
/*     */ 
/* 146 */       PasswordCredential cred = new PasswordCredential(this.username, decodedPassword);
/* 147 */       cred.setManagedConnectionFactory(getMcf());
/* 148 */       SubjectActions.addCredentials(this.subject, cred);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 152 */       log.debug("Failed to decode password", e);
/* 153 */       throw new LoginException("Failed to decode password: " + e.getMessage());
/*     */     }
/* 155 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean abort()
/*     */   {
/* 160 */     this.username = null;
/* 161 */     this.password = null;
/* 162 */     return true;
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/* 167 */     log.trace("getIdentity called, username=" + this.username);
/* 168 */     Principal principal = new SimplePrincipal(this.username);
/* 169 */     return principal;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets() throws LoginException
/*     */   {
/* 174 */     Group[] empty = new Group[0];
/* 175 */     return empty;
/*     */   }
/*     */ 
/*     */   private static class DecodeAction implements PrivilegedExceptionAction {
/*     */     String password;
/*     */     ObjectName jaasSecurityDomain;
/*     */     MBeanServer server;
/*     */ 
/*     */     DecodeAction(String password, ObjectName jaasSecurityDomain, MBeanServer server) {
/* 187 */       this.password = password;
/* 188 */       this.jaasSecurityDomain = jaasSecurityDomain;
/* 189 */       this.server = server;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */       throws Exception
/*     */     {
/* 200 */       Object[] args = { this.password };
/* 201 */       String[] sig = { String.class.getName() };
/* 202 */       byte[] secret = (byte[])(byte[])this.server.invoke(this.jaasSecurityDomain, "decode64", args, sig);
/*     */ 
/* 205 */       String secretPassword = new String(secret, "UTF-8");
/* 206 */       return secretPassword.toCharArray();
/*     */     }
/*     */ 
/*     */     static char[] decode(String password, ObjectName jaasSecurityDomain, MBeanServer server)
/*     */       throws Exception
/*     */     {
/* 212 */       DecodeAction action = new DecodeAction(password, jaasSecurityDomain, server);
/*     */       try
/*     */       {
/* 215 */         char[] decode = (char[])(char[])AccessController.doPrivileged(action);
/* 216 */         return decode;
/*     */       }
/*     */       catch (PrivilegedActionException e) {
/*     */       }
/* 220 */       throw e.getException();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.JaasSecurityDomainIdentityLoginModule
 * JD-Core Version:    0.6.0
 */