/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ 
/*     */ class GetPrincipalInfoAction
/*     */ {
/*     */   private static char[] getPassword()
/*     */   {
/*  44 */     Object credential = SecurityAssociation.getCredential();
/*  45 */     char[] password = null;
/*  46 */     if ((credential instanceof char[]))
/*     */     {
/*  48 */       password = (char[])(char[])credential;
/*     */     }
/*  50 */     else if ((credential instanceof byte[]))
/*     */     {
/*     */       try
/*     */       {
/*  54 */         String tmp = new String((byte[])(byte[])credential, "UTF-8");
/*  55 */         password = tmp.toCharArray();
/*     */       }
/*     */       catch (UnsupportedEncodingException e)
/*     */       {
/*  59 */         throw new SecurityException(e.getMessage());
/*     */       }
/*     */     }
/*  62 */     else if (credential != null)
/*     */     {
/*  64 */       String tmp = credential.toString();
/*  65 */       password = tmp.toCharArray();
/*     */     }
/*  67 */     return password;
/*     */   }
/*     */ 
/*     */   static Principal getPrincipal()
/*     */   {
/*     */     Principal principal;
/*     */     Principal principal;
/* 140 */     if (System.getSecurityManager() == null)
/*     */     {
/* 142 */       principal = PrincipalActions.NON_PRIVILEGED.getPrincipal();
/*     */     }
/*     */     else
/*     */     {
/* 146 */       principal = PrincipalActions.PRIVILEGED.getPrincipal();
/*     */     }
/* 148 */     return principal;
/*     */   }
/*     */ 
/*     */   static char[] getCredential()
/*     */   {
/*     */     char[] credential;
/*     */     char[] credential;
/* 153 */     if (System.getSecurityManager() == null)
/*     */     {
/* 155 */       credential = PrincipalActions.NON_PRIVILEGED.getCredential();
/*     */     }
/*     */     else
/*     */     {
/* 159 */       credential = PrincipalActions.PRIVILEGED.getCredential();
/*     */     }
/* 161 */     return credential;
/*     */   }
/*     */ 
/*     */   static RunAsIdentity peekRunAsIdentity() {
/* 165 */     if (System.getSecurityManager() == null)
/*     */     {
/* 167 */       return PrincipalActions.NON_PRIVILEGED.peek();
/*     */     }
/*     */ 
/* 171 */     return PrincipalActions.PRIVILEGED.peek();
/*     */   }
/*     */ 
/*     */   static abstract interface PrincipalActions
/*     */   {
/*  72 */     public static final PrincipalActions PRIVILEGED = new PrincipalActions()
/*     */     {
/*  74 */       private final PrivilegedAction peekAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  78 */           return SecurityAssociation.peekRunAsIdentity();
/*     */         }
/*  74 */       };
/*     */ 
/*  82 */       private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  86 */           return SecurityAssociation.getPrincipal();
/*     */         }
/*  82 */       };
/*     */ 
/*  90 */       private final PrivilegedAction getCredentialAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  94 */           return GetPrincipalInfoAction.access$000();
/*     */         }
/*  90 */       };
/*     */ 
/*     */       public RunAsIdentity peek()
/*     */       {
/* 100 */         return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
/*     */       }
/*     */ 
/*     */       public Principal getPrincipal()
/*     */       {
/* 105 */         return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
/*     */       }
/*     */ 
/*     */       public char[] getCredential()
/*     */       {
/* 110 */         return (char[])(char[])AccessController.doPrivileged(this.getCredentialAction);
/*     */       }
/*  72 */     };
/*     */ 
/* 114 */     public static final PrincipalActions NON_PRIVILEGED = new PrincipalActions()
/*     */     {
/*     */       public RunAsIdentity peek()
/*     */       {
/* 118 */         return SecurityAssociation.peekRunAsIdentity();
/*     */       }
/*     */ 
/*     */       public Principal getPrincipal()
/*     */       {
/* 123 */         return SecurityAssociation.getPrincipal();
/*     */       }
/*     */ 
/*     */       public char[] getCredential()
/*     */       {
/* 128 */         return GetPrincipalInfoAction.access$000();
/*     */       }
/* 114 */     };
/*     */ 
/*     */     public abstract Principal getPrincipal();
/*     */ 
/*     */     public abstract char[] getCredential();
/*     */ 
/*     */     public abstract RunAsIdentity peek();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.GetPrincipalInfoAction
 * JD-Core Version:    0.6.0
 */