/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class CallerIdentityLoginModule extends AbstractPasswordCredentialLoginModule
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(CallerIdentityLoginModule.class);
/*     */   private String userName;
/*     */   private char[] password;
/*     */   private boolean addRunAsRoles;
/*     */   private Set runAsRoles;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  94 */     super.initialize(subject, handler, sharedState, options);
/*     */ 
/*  96 */     this.userName = ((String)options.get("userName"));
/*  97 */     if (this.userName == null)
/*     */     {
/*  99 */       log.debug("No default username supplied.");
/*     */     }
/*     */ 
/* 102 */     String pass = (String)options.get("password");
/* 103 */     if (pass == null)
/*     */     {
/* 105 */       log.debug("No default password supplied.");
/*     */     }
/*     */     else
/*     */     {
/* 109 */       this.password = pass.toCharArray();
/*     */     }
/*     */ 
/* 113 */     String flag = (String)options.get("addRunAsRoles");
/* 114 */     this.addRunAsRoles = Boolean.valueOf(flag).booleanValue();
/*     */ 
/* 116 */     log.debug("got default principal: " + this.userName + ", username: " + this.userName + ", password: " + (this.password == null ? "null" : "****") + " addRunAsRoles: " + this.addRunAsRoles);
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 132 */     log.trace("Caller Association login called");
/*     */ 
/* 136 */     String username = this.userName;
/*     */     try
/*     */     {
/* 141 */       Principal user = GetPrincipalInfoAction.getPrincipal();
/* 142 */       char[] userPassword = GetPrincipalInfoAction.getCredential();
/*     */ 
/* 144 */       if (userPassword != null)
/*     */       {
/* 146 */         this.password = userPassword;
/*     */       }
/*     */ 
/* 149 */       if (user != null)
/*     */       {
/* 151 */         username = user.getName();
/* 152 */         if (log.isTraceEnabled())
/*     */         {
/* 154 */           log.trace("Current Calling principal is: " + username + " ThreadName: " + Thread.currentThread().getName());
/*     */         }
/*     */ 
/* 158 */         RunAsIdentity runAs = GetPrincipalInfoAction.peekRunAsIdentity();
/* 159 */         if (runAs != null)
/*     */         {
/* 161 */           this.runAsRoles = runAs.getRunAsRoles();
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 167 */       throw new LoginException("Unable to get the calling principal or its credentials for resource association");
/*     */     }
/*     */ 
/* 171 */     this.userName = username;
/* 172 */     if (super.login() == true)
/*     */     {
/* 174 */       return true;
/*     */     }
/*     */ 
/* 178 */     this.sharedState.put("javax.security.auth.login.name", username);
/* 179 */     this.loginOk = true;
/*     */ 
/* 181 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean commit()
/*     */     throws LoginException
/*     */   {
/* 187 */     this.sharedState.put("javax.security.auth.login.name", this.userName);
/*     */ 
/* 189 */     if ((this.addRunAsRoles) && (this.runAsRoles != null))
/*     */     {
/* 191 */       SubjectActions.addRoles(this.subject, this.runAsRoles);
/*     */     }
/*     */ 
/* 195 */     PasswordCredential cred = new PasswordCredential(this.userName, this.password);
/* 196 */     cred.setManagedConnectionFactory(getMcf());
/* 197 */     SubjectActions.addCredentials(this.subject, cred);
/* 198 */     return super.commit();
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/* 203 */     log.trace("getIdentity called");
/* 204 */     Principal principal = new SimplePrincipal(this.userName);
/* 205 */     return principal;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets() throws LoginException
/*     */   {
/* 210 */     log.trace("getRoleSets called");
/* 211 */     return new Group[0];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.CallerIdentityLoginModule
 * JD-Core Version:    0.6.0
 */