/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.security.auth.spi.AbstractServerLoginModule;
/*     */ 
/*     */ public abstract class AbstractPasswordCredentialLoginModule extends AbstractServerLoginModule
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(AbstractPasswordCredentialLoginModule.class);
/*     */   private MBeanServer server;
/*     */   private ObjectName managedConnectionFactoryName;
/*     */   private ManagedConnectionFactory mcf;
/*     */   private Boolean ignoreMissigingMCF;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  64 */     super.initialize(subject, handler, sharedState, options);
/*  65 */     String name = (String)options.get("managedConnectionFactoryName");
/*     */     try
/*     */     {
/*  68 */       this.managedConnectionFactoryName = new ObjectName(name);
/*     */     }
/*     */     catch (MalformedObjectNameException mone)
/*     */     {
/*  72 */       throw new IllegalArgumentException("Malformed ObjectName: " + name);
/*     */     }
/*     */ 
/*  75 */     if (this.managedConnectionFactoryName == null)
/*     */     {
/*  77 */       throw new IllegalArgumentException("Must supply a managedConnectionFactoryName!");
/*     */     }
/*  79 */     Object flag = options.get("ignoreMissigingMCF");
/*  80 */     if ((flag instanceof Boolean))
/*  81 */       this.ignoreMissigingMCF = ((Boolean)flag);
/*  82 */     else if (flag != null)
/*  83 */       this.ignoreMissigingMCF = Boolean.valueOf(flag.toString());
/*  84 */     this.server = MBeanServerLocator.locateJBoss();
/*  85 */     getMcf();
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/*  96 */     if (this.mcf == null)
/*     */     {
/*  98 */       return false;
/*     */     }
/* 100 */     return super.login();
/*     */   }
/*     */ 
/*     */   public boolean logout() throws LoginException
/*     */   {
/* 105 */     removeCredentials();
/* 106 */     return super.logout();
/*     */   }
/*     */ 
/*     */   protected ManagedConnectionFactory getMcf()
/*     */   {
/* 111 */     if (this.mcf == null)
/*     */     {
/*     */       try
/*     */       {
/* 115 */         this.mcf = ((ManagedConnectionFactory)this.server.getAttribute(this.managedConnectionFactoryName, "ManagedConnectionFactory"));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 121 */         log.error("The ConnectionManager mbean: " + this.managedConnectionFactoryName + " specified in a ConfiguredIdentityLoginModule could not be found." + " ConnectionFactory will be unusable!");
/*     */ 
/* 124 */         if (Boolean.TRUE != this.ignoreMissigingMCF)
/*     */         {
/* 126 */           throw new IllegalArgumentException("Managed Connection Factory not found: " + this.managedConnectionFactoryName);
/*     */         }
/*     */       }
/*     */ 
/* 130 */       if (log.isTraceEnabled())
/*     */       {
/* 132 */         log.trace("mcfname: " + this.managedConnectionFactoryName);
/*     */       }
/*     */     }
/*     */ 
/* 136 */     return this.mcf;
/*     */   }
/*     */ 
/*     */   protected MBeanServer getServer()
/*     */   {
/* 141 */     return this.server;
/*     */   }
/*     */ 
/*     */   protected void removeCredentials()
/*     */   {
/* 150 */     this.sharedState.remove("javax.security.auth.login.name");
/* 151 */     this.sharedState.remove("javax.security.auth.login.password");
/* 152 */     SubjectActions.removeCredentials(this.subject, this.mcf);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.AbstractPasswordCredentialLoginModule
 * JD-Core Version:    0.6.0
 */