/*     */ package org.jboss.resource.metadata.mcf;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
/*     */ 
/*     */ @XmlAccessorType(XmlAccessType.FIELD)
/*     */ public abstract class NonXADataSourceDeploymentMetaData extends DataSourceDeploymentMetaData
/*     */ {
/*     */ 
/*     */   @XmlElement(name="driver-class", required=true)
/*     */   private String driverClass;
/*     */ 
/*     */   @XmlElement(name="connection-url", required=true)
/*     */   private String connectionUrl;
/*     */ 
/*     */   @XmlElement(name="connection-property")
/*  53 */   private List<DataSourceConnectionPropertyMetaData> connectionProperties = new ArrayList();
/*     */ 
/*     */   @ManagementProperty(name="connection-url", description="The DataSource connection URL")
/*     */   public String getConnectionUrl()
/*     */   {
/*  59 */     return this.connectionUrl;
/*     */   }
/*     */ 
/*     */   public void setConnectionUrl(String connectionUrl)
/*     */   {
/*  64 */     this.connectionUrl = connectionUrl;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="driver-class", description="The DataSource connection driver class name")
/*     */   public String getDriverClass() {
/*  70 */     return this.driverClass;
/*     */   }
/*     */ 
/*     */   public void setDriverClass(String driverClass)
/*     */   {
/*  75 */     this.driverClass = driverClass;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="connection-properties", description="The DataSource connection properties", managed=true)
/*     */   public List<DataSourceConnectionPropertyMetaData> getDataSourceConnectionProperties() {
/*  81 */     return this.connectionProperties;
/*     */   }
/*     */ 
/*     */   public void setDataSourceConnectionProperties(List<DataSourceConnectionPropertyMetaData> connectionProperties)
/*     */   {
/*  86 */     this.connectionProperties = connectionProperties;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="config-property", description="The connection factory property info", managed=true, propertyFactory=ConnectionFactoryProperty.class)
/*     */   public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties()
/*     */   {
/*  94 */     List properties = super.getManagedConnectionFactoryProperties();
/*  95 */     ManagedConnectionFactoryPropertyMetaData property = null;
/*     */ 
/*  97 */     if (getConnectionUrl() != null)
/*     */     {
/*  99 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 100 */       property.setName("ConnectionURL");
/* 101 */       property.setValue(getConnectionUrl());
/* 102 */       properties.add(property);
/*     */     }
/*     */ 
/* 106 */     if (getDriverClass() != null)
/*     */     {
/* 108 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 109 */       property.setName("DriverClass");
/* 110 */       property.setValue(getDriverClass());
/* 111 */       properties.add(property);
/*     */     }
/*     */ 
/* 114 */     StringBuffer propBuff = new StringBuffer();
/* 115 */     List dsProps = getDataSourceConnectionProperties();
/*     */ 
/* 117 */     if (dsProps != null)
/*     */     {
/* 119 */       for (DataSourceConnectionPropertyMetaData prop : dsProps)
/*     */       {
/* 121 */         propBuff.append(prop.getName() + "=" + prop.getValue() + "\n");
/*     */       }
/*     */     }
/*     */ 
/* 125 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 126 */     property.setName("ConnectionProperties");
/* 127 */     property.setValue(propBuff.toString());
/* 128 */     properties.add(property);
/*     */ 
/* 130 */     return properties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.mcf.NonXADataSourceDeploymentMetaData
 * JD-Core Version:    0.6.0
 */