/*     */ package org.jboss.resource.metadata;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Locale;
/*     */ 
/*     */ public class DescriptionMetaData
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -3100028904830435509L;
/*     */   private String lang;
/*     */   private String description;
/*     */ 
/*     */   public DescriptionMetaData()
/*     */   {
/*  48 */     this(null);
/*     */   }
/*     */ 
/*     */   public DescriptionMetaData(String lang)
/*     */   {
/*  58 */     if (lang == null)
/*  59 */       this.lang = Locale.getDefault().getLanguage();
/*     */     else
/*  61 */       this.lang = lang;
/*     */   }
/*     */ 
/*     */   public String getLanguage()
/*     */   {
/*  71 */     return this.lang;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/*  81 */     return this.description;
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/*  91 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  96 */     StringBuffer buffer = new StringBuffer();
/*  97 */     buffer.append("DescriptionMetaData").append('@');
/*  98 */     buffer.append(Integer.toHexString(System.identityHashCode(this)));
/*  99 */     buffer.append("[language=").append(this.lang);
/* 100 */     if (this.description != null)
/* 101 */       buffer.append(" description=").append(this.description);
/* 102 */     buffer.append(']');
/* 103 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.DescriptionMetaData
 * JD-Core Version:    0.6.0
 */