/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.JBossRAMetaData;
/*     */ import org.jboss.resource.metadata.RARDeploymentMetaData;
/*     */ 
/*     */ public class ResourceAdapterFactory
/*     */ {
/*  47 */   public static final String DUMMY_RA_CLASS = DummyResourceAdapter.class.getName();
/*     */ 
/*     */   public static ResourceAdapter createResourceAdapter(RARDeploymentMetaData ramd)
/*     */     throws Exception
/*     */   {
/*  58 */     ResourceAdapter adapter = createResourceAdapter(ramd.getConnectorMetaData());
/*     */ 
/*  60 */     for (Iterator iter = ramd.getRaXmlMetaData().getProperties().iterator(); iter.hasNext(); )
/*     */     {
/*  62 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)iter.next();
/*  63 */       applyProperty(cpmd, adapter.getClass(), adapter);
/*     */     }
/*     */ 
/*  67 */     return adapter;
/*     */   }
/*     */ 
/*     */   public static ResourceAdapter createResourceAdapter(ConnectorMetaData cmd)
/*     */     throws Exception
/*     */   {
/*  79 */     String className = cmd.getRAClass();
/*  80 */     if (className == null) {
/*  81 */       className = DUMMY_RA_CLASS;
/*     */     }
/*     */ 
/*  84 */     Class raClass = Thread.currentThread().getContextClassLoader().loadClass(className);
/*  85 */     if (!ResourceAdapter.class.isAssignableFrom(raClass))
/*  86 */       throw new DeploymentException(raClass.getName() + " is not a resource adapter class");
/*  87 */     ResourceAdapter result = (ResourceAdapter)raClass.newInstance();
/*     */ 
/*  90 */     for (Iterator i = cmd.getProperties().iterator(); i.hasNext(); )
/*     */     {
/*  92 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/*  93 */       applyProperty(cpmd, raClass, result);
/*     */     }
/*     */ 
/*  98 */     return result;
/*     */   }
/*     */ 
/*     */   private static void applyProperty(ConfigPropertyMetaData cpmd, Class clz, ResourceAdapter ra)
/*     */     throws Exception
/*     */   {
/* 104 */     String name = cpmd.getName();
/* 105 */     String type = cpmd.getType();
/* 106 */     String value = cpmd.getValue();
/*     */ 
/* 108 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
/* 109 */     PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
/* 110 */     if (editor == null)
/* 111 */       throw new IllegalArgumentException("No property editor found for property " + cpmd);
/* 112 */     editor.setAsText(value);
/* 113 */     Object object = editor.getValue();
/*     */     try
/*     */     {
/* 117 */       String setter = "set" + Character.toUpperCase(name.charAt(0));
/* 118 */       if (name.length() > 1)
/* 119 */         setter = setter.concat(name.substring(1));
/* 120 */       Method method = clz.getMethod(setter, new Class[] { clazz });
/* 121 */       method.invoke(ra, new Object[] { object });
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 125 */       DeploymentException.rethrowAsDeploymentException("Error for resource adapter class " + clz.getName() + " setting property " + cpmd, e.getTargetException());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 129 */       DeploymentException.rethrowAsDeploymentException("Error for resource adapter class " + clz.getName() + " accessing property setter " + cpmd, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.ResourceAdapterFactory
 * JD-Core Version:    0.6.0
 */