/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Timer;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.BootstrapContext;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import javax.resource.spi.UnavailableException;
/*     */ import javax.resource.spi.XATerminator;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.metadata.AuthenticationMechanismMetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionGroupMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionMetaData;
/*     */ import org.jboss.resource.metadata.JBossRAMetaData;
/*     */ import org.jboss.resource.metadata.LicenseMetaData;
/*     */ import org.jboss.resource.metadata.MessageListenerMetaData;
/*     */ import org.jboss.resource.metadata.RARDeploymentMetaData;
/*     */ import org.jboss.system.ServiceDynamicMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ 
/*     */ public class RARDeployment extends ServiceDynamicMBeanSupport
/*     */   implements BootstrapContext
/*     */ {
/*     */   protected DeploymentInfo di;
/*     */   protected RARDeployer deployer;
/*     */   protected RARDeploymentMetaData rdmd;
/*     */   protected ConnectorMetaData cmd;
/*     */   protected JBossRAMetaData ramd;
/*     */   protected ResourceAdapter resourceAdapter;
/*     */ 
/*     */   public RARDeployment(DeploymentInfo di)
/*     */   {
/*  87 */     this.di = di;
/*  88 */     this.deployer = ((RARDeployer)di.deployer);
/*  89 */     this.rdmd = ((RARDeploymentMetaData)di.metaData);
/*  90 */     this.cmd = this.rdmd.getConnectorMetaData();
/*  91 */     this.ramd = this.rdmd.getRaXmlMetaData();
/*     */   }
/*     */ 
/*     */   public Timer createTimer()
/*     */     throws UnavailableException
/*     */   {
/*  99 */     return new Timer(true);
/*     */   }
/*     */ 
/*     */   public WorkManager getWorkManager()
/*     */   {
/* 104 */     return this.deployer.workManager;
/*     */   }
/*     */ 
/*     */   public XATerminator getXATerminator()
/*     */   {
/* 109 */     return this.deployer.xaTerminator;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 114 */     if (this.cmd.getLicense().getRequired())
/*     */     {
/* 116 */       this.log.info("Required license terms exist, view META-INF/ra.xml in " + ServerConfigUtil.shortUrlFromServerHome(this.di.url.toString()));
/* 117 */       this.log.debug("License terms full URL: " + this.di.url);
/*     */     }
/* 119 */     this.resourceAdapter = ResourceAdapterFactory.createResourceAdapter(this.rdmd);
/* 120 */     this.resourceAdapter.start(this);
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 125 */     this.resourceAdapter.stop();
/*     */   }
/*     */ 
/*     */   protected String getInternalDescription()
/*     */   {
/* 130 */     String description = null;
/* 131 */     DescriptionGroupMetaData dgmd = this.cmd.getDescription();
/* 132 */     if (dgmd != null)
/* 133 */       description = dgmd.getDescription();
/* 134 */     if (description == null)
/* 135 */       description = "RAR Deployment " + this.di.url;
/* 136 */     return description;
/*     */   }
/*     */ 
/*     */   protected MBeanAttributeInfo[] getInternalAttributeInfo()
/*     */   {
/* 141 */     Collection properties = this.cmd.getProperties();
/* 142 */     MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[11 + properties.size()];
/* 143 */     attrs[0] = new MBeanAttributeInfo("MetaData", ConnectorMetaData.class.getName(), "The meta data", true, false, false);
/* 144 */     attrs[1] = new MBeanAttributeInfo("AuthenticationMechanism", String.class.getName(), "The authentication mechanism", true, false, false);
/* 145 */     attrs[2] = new MBeanAttributeInfo("EISType", String.class.getName(), "The EIS type", true, false, false);
/* 146 */     attrs[3] = new MBeanAttributeInfo("License", String.class.getName(), "The license", true, false, false);
/* 147 */     attrs[4] = new MBeanAttributeInfo("RAClass", String.class.getName(), "The resource adapter class", true, false, false);
/* 148 */     attrs[5] = new MBeanAttributeInfo("RAVersion", String.class.getName(), "The resource adapter version", true, false, false);
/* 149 */     attrs[6] = new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The transaction support", true, false, false);
/* 150 */     attrs[7] = new MBeanAttributeInfo("VendorName", String.class.getName(), "The vendor name", true, false, false);
/* 151 */     attrs[8] = new MBeanAttributeInfo("Version", String.class.getName(), "The spec version", true, false, false);
/* 152 */     attrs[9] = new MBeanAttributeInfo("ReauthenticationSupport", Boolean.TYPE.getName(), "Whether reauthentication support is supported", true, false, false);
/* 153 */     attrs[10] = new MBeanAttributeInfo("ResourceAdapter", ResourceAdapter.class.getName(), "The resource adapter instance", true, false, false);
/* 154 */     int n = 11;
/* 155 */     for (Iterator i = properties.iterator(); i.hasNext(); )
/*     */     {
/* 157 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/* 158 */       attrs[(n++)] = new MBeanAttributeInfo(cpmd.getName(), cpmd.getType(), cpmd.getDescription().getDescription(), true, false, false);
/*     */     }
/* 160 */     return attrs;
/*     */   }
/*     */ 
/*     */   protected Object getInternalAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 166 */     if ("MetaData".equals(attribute))
/* 167 */       return this.cmd;
/* 168 */     if ("AuthenticationMechanism".equals(attribute))
/* 169 */       return this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
/* 170 */     if ("EISType".equals(attribute))
/* 171 */       return this.cmd.getEISType();
/* 172 */     if ("License".equals(attribute))
/* 173 */       return this.cmd.getLicense().getDescription().getDescription();
/* 174 */     if ("RAClass".equals(attribute))
/* 175 */       return this.cmd.getRAClass();
/* 176 */     if ("RAVersion".equals(attribute))
/* 177 */       return this.cmd.getRAVersion();
/* 178 */     if ("TransactionSupport".equals(attribute))
/* 179 */       return this.cmd.getTransactionSupport();
/* 180 */     if ("VendorName".equals(attribute))
/* 181 */       return this.cmd.getVendorName();
/* 182 */     if ("Version".equals(attribute))
/* 183 */       return this.cmd.getVersion();
/* 184 */     if ("ReauthenticationSupport".equals(attribute))
/* 185 */       return new Boolean(this.cmd.getReauthenticationSupport());
/* 186 */     if ("ResourceAdapter".equals(attribute))
/* 187 */       return this.resourceAdapter;
/* 188 */     Object property = this.cmd.getProperty(attribute);
/* 189 */     if (property != null) {
/* 190 */       return property;
/*     */     }
/* 192 */     return super.getInternalAttribute(attribute);
/*     */   }
/*     */ 
/*     */   protected MBeanOperationInfo[] getInternalOperationInfo()
/*     */   {
/* 197 */     MBeanOperationInfo[] ops = new MBeanOperationInfo[3];
/*     */ 
/* 199 */     MBeanParameterInfo[] createActivationSpecParams = { new MBeanParameterInfo("MessagingType", Class.class.getName(), "The type of the message listener"), new MBeanParameterInfo("ActivationConfig", Collection.class.getName(), "A collection of activation config properties") };
/*     */ 
/* 204 */     ops[0] = new MBeanOperationInfo("createActivationSpec", "Create an activation spec", createActivationSpecParams, ActivationSpec.class.getName(), 1);
/*     */ 
/* 207 */     MBeanParameterInfo[] activationParams = { new MBeanParameterInfo("MessageEndpointFactory", MessageEndpointFactory.class.getName(), "The message endpoint factory"), new MBeanParameterInfo("ActivationSpec", ActivationSpec.class.getName(), "The activation spec") };
/*     */ 
/* 212 */     ops[1] = new MBeanOperationInfo("endpointActivation", "Active the endpoint", activationParams, Void.class.getName(), 1);
/*     */ 
/* 214 */     ops[2] = new MBeanOperationInfo("endpointDeactivation", "Deactive the endpoint", activationParams, Void.class.getName(), 1);
/*     */ 
/* 217 */     return ops;
/*     */   }
/*     */ 
/*     */   protected Object internalInvoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 223 */     if ("createActivationSpec".equals(actionName))
/*     */     {
/* 225 */       if (params.length != 2)
/* 226 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 227 */       Class messagingType = (Class)params[0];
/* 228 */       Collection activationConfig = (Collection)params[1];
/* 229 */       return createActivationSpec(messagingType, activationConfig);
/*     */     }
/* 231 */     if ("endpointActivation".equals(actionName))
/*     */     {
/* 233 */       if (params.length != 2)
/* 234 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 235 */       MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
/* 236 */       ActivationSpec activationSpec = (ActivationSpec)params[1];
/* 237 */       endpointActivation(messageEndpointFactory, activationSpec);
/* 238 */       return null;
/*     */     }
/* 240 */     if ("endpointDeactivation".equals(actionName))
/*     */     {
/* 242 */       if (params.length != 2)
/* 243 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 244 */       MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
/* 245 */       ActivationSpec activationSpec = (ActivationSpec)params[1];
/* 246 */       endpointDeactivation(messageEndpointFactory, activationSpec);
/* 247 */       return null;
/*     */     }
/* 249 */     return super.internalInvoke(actionName, params, signature);
/*     */   }
/*     */ 
/*     */   protected ActivationSpec createActivationSpec(Class messagingType, Collection activationConfig) throws MBeanException
/*     */   {
/* 254 */     boolean trace = this.log.isTraceEnabled();
/* 255 */     if (trace) {
/* 256 */       this.log.trace("CreateActivateSpec rar=" + getServiceName() + " messagingType=" + messagingType.getName() + " activationConfig=" + activationConfig);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 261 */       MessageListenerMetaData mlmd = this.cmd.getMessageListener(messagingType.getName());
/* 262 */       if (mlmd == null) {
/* 263 */         throw new DeploymentException("MessagingType '" + messagingType.getName() + "' not found in resource deployment " + getServiceName());
/*     */       }
/* 265 */       return ActivationSpecFactory.createActivationSpec(getServiceName(), messagingType.getName(), activationConfig, mlmd);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 269 */     throw new MBeanException(e, "Error in create activation spec " + getServiceName());
/*     */   }
/*     */ 
/*     */   protected void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec)
/*     */     throws MBeanException
/*     */   {
/* 275 */     boolean trace = this.log.isTraceEnabled();
/* 276 */     if (trace) {
/* 277 */       this.log.trace("EndpointActivation rar=" + getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec);
/*     */     }
/*     */     try
/*     */     {
/* 281 */       activationSpec.setResourceAdapter(this.resourceAdapter);
/* 282 */       this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 286 */       throw new MBeanException(e, "Error in endpoint activation " + getServiceName());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws MBeanException
/*     */   {
/* 292 */     boolean trace = this.log.isTraceEnabled();
/* 293 */     if (trace) {
/* 294 */       this.log.trace("EndpointDeactivation rar=" + getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec);
/*     */     }
/*     */     try
/*     */     {
/* 298 */       this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 302 */       throw new MBeanException(e, "Error in endpoint deactivation " + getServiceName());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.RARDeployment
 * JD-Core Version:    0.6.0
 */